/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.nio.DoubleBuffer;
import org.apache.sis.image.Interpolation;

final class LanczosInterpolation
extends Interpolation {
    private final double a;
    private final int span;

    LanczosInterpolation(int a) {
        this.a = a;
        this.span = 2 * a;
    }

    public String toString() {
        return "LANCZOS";
    }

    @Override
    public Dimension getSupportSize() {
        return new Dimension(this.span, this.span);
    }

    @Override
    public void interpolate(DoubleBuffer source, int numBands, double xfrac, double yfrac, double[] writeTo, int writeToOffset) {
        source.mark();
        double[] kx = new double[this.span];
        double xp = (xfrac - (1.0 - this.a)) * Math.PI;
        double yp = (yfrac - (1.0 - this.a)) * Math.PI;
        double sinx = Math.sin(xp);
        double siny = Math.sin(yp);
        kx[0] = this.kernel(xp, sinx);
        double ky = this.kernel(yp, siny);
        double k = kx[0] * ky;
        for (int b = 0; b < numBands; ++b) {
            writeTo[writeToOffset + b] = k * source.get();
        }
        int i = 1;
        while (i < this.span) {
            int n = i++;
            sinx = -sinx;
            kx[n] = k = this.kernel((xfrac - ((double)i - this.a)) * Math.PI, sinx);
            k *= ky;
            for (int b = 0; b < numBands; ++b) {
                int n2 = writeToOffset + b;
                writeTo[n2] = writeTo[n2] + k * source.get();
            }
        }
        int j = 1;
        while (j < this.span) {
            siny = -siny;
            ky = this.kernel((yfrac - ((double)(++j) - this.a)) * Math.PI, siny);
            for (int i2 = 0; i2 < this.span; ++i2) {
                double k2 = kx[i2] * ky;
                for (int b = 0; b < numBands; ++b) {
                    int n = writeToOffset + b;
                    writeTo[n] = writeTo[n] + k2 * source.get();
                }
            }
        }
        source.reset();
    }

    private double kernel(double x, double sinx) {
        double y = sinx * Math.sin(x / this.a) * this.a / (x * x);
        return y <= 1.0 ? y : 1.0;
    }
}

