/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.grammar;

import java.lang.reflect.Array;
import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.tinkerpop.gremlin.language.grammar.DefaultGremlinBaseVisitor;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinAntlrToJava;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParserException;
import org.apache.tinkerpop.gremlin.language.grammar.VariableResolver;
import org.apache.tinkerpop.gremlin.process.traversal.step.GType;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class ArgumentVisitor
extends DefaultGremlinBaseVisitor<Object> {
    private final VariableResolver resolver;
    private final GremlinAntlrToJava antlr;

    public ArgumentVisitor(VariableResolver resolver, GremlinAntlrToJava antlr) {
        this.resolver = resolver;
        this.antlr = antlr;
    }

    public Map parseMap(GremlinParser.GenericLiteralMapNullableArgumentContext ctx) {
        Object literalOrVar = this.visitGenericLiteralMapNullableArgument(ctx);
        if (GValue.valueInstanceOf(literalOrVar, GType.MAP)) {
            return (Map)((GValue)literalOrVar).get();
        }
        return (Map)literalOrVar;
    }

    public Object[] parseObjectVarargs(GremlinParser.GenericLiteralListArgumentContext ctx) {
        if (ctx.genericLiteralList() != null) {
            return this.antlr.genericVisitor.parseObjectList(ctx.genericLiteralList());
        }
        Object l = this.visitVariable(ctx.variable());
        if (null == l) {
            return null;
        }
        if (l.getClass().isArray()) {
            int length = Array.getLength(l);
            Object[] result = new Object[length];
            for (int i = 0; i < length; ++i) {
                result[i] = Array.get(l, i);
            }
            return result;
        }
        if (l instanceof Iterable) {
            return IteratorUtils.list(((Iterable)l).iterator()).toArray();
        }
        return new Object[]{l};
    }

    public GValue<String>[] parseStringVarargs(GremlinParser.StringLiteralVarargsContext varargsContext) {
        if (varargsContext == null || varargsContext.stringNullableArgument() == null) {
            return new GValue[0];
        }
        return (GValue[])varargsContext.stringNullableArgument().stream().filter(Objects::nonNull).map(this.antlr.argumentVisitor::parseString).toArray(GValue[]::new);
    }

    public GValue<String> parseString(GremlinParser.StringNullableArgumentContext ctx) {
        Object literalOrVar = this.visitStringNullableArgument(ctx);
        if (GValue.valueInstanceOf(literalOrVar, GType.STRING)) {
            return (GValue)literalOrVar;
        }
        return GValue.ofString(null, (String)literalOrVar);
    }

    public Object parseLong(GremlinParser.IntegerArgumentContext ctx) {
        if (ctx.integerLiteral() != null) {
            return this.antlr.genericVisitor.parseIntegral(ctx.integerLiteral()).longValue();
        }
        Object var = this.visitVariable(ctx.variable());
        if (var instanceof Number) {
            return ((Number)var).longValue();
        }
        if (GValue.valueInstanceOf(var, GType.LONG)) {
            return var;
        }
        if (GValue.valueInstanceOf(var, GType.INTEGER)) {
            return GValue.ofLong(((GValue)var).getName(), ((Integer)((GValue)var).get()).longValue());
        }
        if (GValue.valueInstanceOf(var, GType.SHORT)) {
            return GValue.ofLong(((GValue)var).getName(), ((Short)((GValue)var).get()).longValue());
        }
        if (GValue.valueInstanceOf(var, GType.BYTE)) {
            return GValue.ofLong(((GValue)var).getName(), ((Byte)((GValue)var).get()).longValue());
        }
        throw new GremlinParserException(String.format("Expected variable [%s] to resolve to an integer type, instead found: %s", ctx.variable().Identifier().getSymbol(), var.getClass().getName()));
    }

    @Override
    public Object visitBooleanArgument(GremlinParser.BooleanArgumentContext ctx) {
        if (ctx.booleanLiteral() != null) {
            return this.antlr.genericVisitor.parseBoolean(ctx.booleanLiteral());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitIntegerArgument(GremlinParser.IntegerArgumentContext ctx) {
        if (ctx.integerLiteral() != null) {
            return this.antlr.genericVisitor.parseIntegral(ctx.integerLiteral());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitFloatArgument(GremlinParser.FloatArgumentContext ctx) {
        if (ctx.floatLiteral() != null) {
            return this.antlr.genericVisitor.parseFloating(ctx.floatLiteral());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitStringArgument(GremlinParser.StringArgumentContext ctx) {
        if (ctx.stringLiteral() != null) {
            return this.antlr.genericVisitor.parseString(ctx.stringLiteral());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitStringNullableArgument(GremlinParser.StringNullableArgumentContext ctx) {
        if (ctx.stringNullableLiteral() != null) {
            return this.antlr.genericVisitor.parseString(ctx.stringNullableLiteral());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitDateArgument(GremlinParser.DateArgumentContext ctx) {
        if (ctx.dateLiteral() != null) {
            return this.antlr.genericVisitor.parseDate(ctx.dateLiteral());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitGenericLiteralArgument(GremlinParser.GenericLiteralArgumentContext ctx) {
        if (ctx.genericLiteral() != null) {
            return this.antlr.genericVisitor.visitGenericLiteral(ctx.genericLiteral());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitGenericLiteral(GremlinParser.GenericLiteralContext ctx) {
        return this.antlr.genericVisitor.visitGenericLiteral(ctx);
    }

    @Override
    public Object visitGenericLiteralListArgument(GremlinParser.GenericLiteralListArgumentContext ctx) {
        if (ctx.genericLiteralList() != null) {
            return this.antlr.genericVisitor.visitChildren((RuleNode)ctx.genericLiteralList());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitStructureVertexArgument(GremlinParser.StructureVertexArgumentContext ctx) {
        if (ctx.structureVertex() != null) {
            return this.antlr.structureVisitor.visitStructureVertex(ctx.structureVertex());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitGenericLiteralMapArgument(GremlinParser.GenericLiteralMapArgumentContext ctx) {
        if (ctx.genericLiteralMap() != null) {
            return this.antlr.genericVisitor.visitGenericLiteralMap(ctx.genericLiteralMap());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitGenericLiteralMapNullableArgument(GremlinParser.GenericLiteralMapNullableArgumentContext ctx) {
        if (ctx.nullLiteral() != null) {
            return null;
        }
        if (ctx.genericLiteralMap() != null) {
            return this.antlr.genericVisitor.visitGenericLiteralMap(ctx.genericLiteralMap());
        }
        return this.visitVariable(ctx.variable());
    }

    @Override
    public Object visitVariable(GremlinParser.VariableContext ctx) {
        return this.resolver.apply(ctx.getText(), ctx);
    }

    public static <V> GValue<V> asGValue(V value) {
        if (value instanceof GValue) {
            return (GValue)value;
        }
        return GValue.of(null, value);
    }
}

