/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;

public class RequestUtil {
    private RequestUtil() {
    }

    public static String normalize(String path) {
        return RequestUtil.normalize(path, true);
    }

    public static String normalize(String path, boolean replaceBackSlash) {
        int index;
        if (path == null) {
            return null;
        }
        Object normalized = path;
        if (replaceBackSlash && ((String)normalized).indexOf(92) >= 0) {
            normalized = ((String)normalized).replace('\\', '/');
        }
        if (!((String)normalized).startsWith("/")) {
            normalized = "/" + (String)normalized;
        }
        boolean addedTrailingSlash = false;
        if (((String)normalized).endsWith("/.") || ((String)normalized).endsWith("/..")) {
            normalized = (String)normalized + "/";
            addedTrailingSlash = true;
        }
        while ((index = ((String)normalized).indexOf("//")) >= 0) {
            normalized = ((String)normalized).substring(0, index) + ((String)normalized).substring(index + 1);
        }
        while ((index = ((String)normalized).indexOf("/./")) >= 0) {
            normalized = ((String)normalized).substring(0, index) + ((String)normalized).substring(index + 2);
        }
        while ((index = ((String)normalized).indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = ((String)normalized).lastIndexOf(47, index - 1);
            normalized = ((String)normalized).substring(0, index2) + ((String)normalized).substring(index + 3);
        }
        if (((String)normalized).length() > 1 && addedTrailingSlash) {
            normalized = ((String)normalized).substring(0, ((String)normalized).length() - 1);
        }
        return normalized;
    }

    public static boolean isSameOrigin(HttpServletRequest request, String origin) {
        StringBuilder target = new StringBuilder();
        String scheme = request.getScheme();
        String host = request.getServerName();
        if (scheme == null || host == null) {
            return false;
        }
        scheme = scheme.toLowerCase(Locale.ENGLISH);
        target.append(scheme).append("://").append(host);
        int port = request.getServerPort();
        if (target.length() == origin.length()) {
            if (("http".equals(scheme) || "ws".equals(scheme)) && port != 80 || ("https".equals(scheme) || "wss".equals(scheme)) && port != 443) {
                target.append(':');
                target.append(port);
            }
        } else {
            target.append(':');
            target.append(port);
        }
        return origin.contentEquals(target);
    }

    public static boolean isValidOrigin(String origin) {
        URI originURI;
        if (origin.contains("%")) {
            return false;
        }
        if ("null".equals(origin)) {
            return true;
        }
        if (origin.startsWith("file://")) {
            return true;
        }
        try {
            originURI = new URI(origin);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return originURI.getScheme() != null;
    }
}

