/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.testcontainer;

import java.io.File;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.fulcrum.yaafi.container.Container;
import org.apache.fulcrum.yaafi.framework.container.ServiceContainer;
import org.apache.fulcrum.yaafi.framework.factory.ServiceContainerConfiguration;
import org.apache.fulcrum.yaafi.framework.factory.ServiceContainerFactory;
import org.apache.fulcrum.yaafi.framework.logger.Log4j2Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;

public class YAAFIContainer
extends AbstractLogEnabled
implements Container {
    private ServiceContainerConfiguration config;
    private ServiceContainer manager;
    private Level logLevel = Level.DEBUG;
    Logger logger = LogManager.getLogger((String)"avalon");

    public YAAFIContainer() {
        Configurator.setLevel((String)"avalon", (Level)this.logLevel);
        this.enableLogging((org.apache.avalon.framework.logger.Logger)new Log4j2Logger(this.logger));
        this.config = new ServiceContainerConfiguration();
    }

    public YAAFIContainer(int logLevel) {
        this.logLevel = logLevel == 0 ? Level.DEBUG : (logLevel == 0 ? Level.DEBUG : (logLevel == 1 ? Level.INFO : (logLevel == 2 ? Level.WARN : (logLevel == 3 ? Level.ERROR : (logLevel == 4 ? Level.FATAL : (logLevel == 5 ? Level.OFF : Level.INFO))))));
        Configurator.setLevel((String)"avalon", (Level)this.logLevel);
        this.enableLogging((org.apache.avalon.framework.logger.Logger)new Log4j2Logger(this.logger));
        this.config = new ServiceContainerConfiguration();
    }

    public void startup(String configFileName, String roleFileName, String parametersFileName) {
        this.getLogger().debug("Starting YAAFI container... ");
        this.getLogger().debug("with logger: " + this.getLogger().getClass().getName());
        this.config.setComponentConfigurationLocation(configFileName);
        this.config.setComponentRolesLocation(roleFileName);
        this.config.setParametersLocation(parametersFileName);
        this.config.setLogger((org.apache.avalon.framework.logger.Logger)new Log4j2Logger(this.logger));
        File configFile = new File(configFileName);
        if (!configFile.exists()) {
            throw new RuntimeException("Could not initialize the container because the config file could not be found:" + String.valueOf(configFile));
        }
        try {
            this.initialize();
            this.getLogger().info("YAFFI Container ready.");
        }
        catch (Exception e) {
            this.getLogger().error("Could not initialize the container", (Throwable)e);
            throw new RuntimeException("Could not initialize the container");
        }
    }

    public void initialize() throws Exception {
        this.manager = ServiceContainerFactory.create((ServiceContainerConfiguration)this.config);
    }

    public void dispose() {
        this.getLogger().debug("Disposing of container...");
        if (this.manager != null) {
            this.manager.dispose();
        }
        this.getLogger().info("YAFFI Container has been disposed.");
    }

    public Object lookup(String roleName) throws ComponentException {
        try {
            return this.manager.lookup(roleName);
        }
        catch (Exception e) {
            String msg = "Failed to lookup role " + roleName;
            throw new ComponentException(roleName, msg, (Throwable)e);
        }
    }

    public void release(Component component) {
        this.manager.release((Object)component);
    }

    public void release(Object component) {
        this.manager.release(component);
    }
}

