/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.xmlmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.xmlmodel.XmlGroup;
import org.xml.sax.Attributes;

public class AppData
implements Serializable {
    private static final long serialVersionUID = -3953843038383617960L;
    private List inputs = new ArrayList();
    private String basePackage;
    private String groupPrefix;

    public void loadFromXML(Attributes attrib) {
        String basePkg = attrib.getValue("basePackage");
        if (basePkg == null) {
            this.setBasePackage("");
        } else if (basePkg.charAt(basePkg.length() - 1) != '.') {
            this.setBasePackage(basePkg + '.');
        } else {
            this.setBasePackage(basePkg);
        }
        this.setGroupPrefix(attrib.getValue("groupPrefix"));
    }

    public List getGroups() {
        return this.inputs;
    }

    public XmlGroup getGroup(String groupName) throws IntakeException {
        if (groupName == null) {
            throw new IntakeException("Intake AppData.getGroup(groupName) is null");
        }
        String groupPrefix = this.getGroupPrefix();
        Iterator it = this.inputs.iterator();
        while (it.hasNext()) {
            XmlGroup group = (XmlGroup)it.next();
            if (group.getName().equals(groupName)) {
                return group;
            }
            if (groupPrefix == null) continue;
            StringBuffer qualifiedGroupName = new StringBuffer();
            qualifiedGroupName.append(groupPrefix).append(':').append(group.getName());
            if (!qualifiedGroupName.toString().equals(groupName)) continue;
            return group;
        }
        return null;
    }

    public XmlGroup addGroup(Attributes attrib) {
        XmlGroup input = new XmlGroup();
        input.loadFromXML(attrib);
        this.addGroup(input);
        return input;
    }

    public void addGroup(XmlGroup input) {
        input.setAppData(this);
        this.inputs.add(input);
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String v) {
        this.basePackage = v;
    }

    public String getGroupPrefix() {
        return this.groupPrefix;
    }

    public void setGroupPrefix(String groupPrefix) {
        this.groupPrefix = groupPrefix;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("<input-data>\n");
        Iterator iter = this.inputs.iterator();
        while (iter.hasNext()) {
            result.append(iter.next());
        }
        result.append("</input-data>");
        return result.toString();
    }
}

