/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security.ldap;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.configuration.Configuration;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.services.security.UserManager;
import org.apache.turbine.services.security.ldap.LDAPSecurityConstants;
import org.apache.turbine.services.security.ldap.LDAPUser;
import org.apache.turbine.util.security.DataBackendException;
import org.apache.turbine.util.security.EntityExistsException;
import org.apache.turbine.util.security.PasswordMismatchException;
import org.apache.turbine.util.security.UnknownEntityException;

public class LDAPUserManager
implements UserManager {
    @Override
    public void init(Configuration conf) {
    }

    @Override
    public boolean accountExists(User user) throws DataBackendException {
        return this.accountExists(user.getName());
    }

    @Override
    public boolean accountExists(String username) throws DataBackendException {
        try {
            User ldapUser = this.retrieve(username);
        }
        catch (UnknownEntityException ex) {
            return false;
        }
        return true;
    }

    @Override
    public User retrieve(String username) throws UnknownEntityException, DataBackendException {
        try {
            DirContext ctx = LDAPUserManager.bindAsAdmin();
            String userBaseSearch = LDAPSecurityConstants.getBaseSearch();
            String filter = LDAPSecurityConstants.getNameAttribute();
            filter = "(" + filter + "=" + username + ")";
            SearchControls ctls = new SearchControls();
            NamingEnumeration<SearchResult> answer = ctx.search(userBaseSearch, filter, ctls);
            if (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attribs = sr.getAttributes();
                LDAPUser ldapUser = this.createLDAPUser();
                ldapUser.setLDAPAttributes(attribs);
                ldapUser.setTemp("turbine.user", ldapUser);
                return ldapUser;
            }
            throw new UnknownEntityException("The given user: " + username + "\n does not exist.");
        }
        catch (NamingException ex) {
            throw new DataBackendException("The LDAP server specified is unavailable", ex);
        }
    }

    @Override
    public User[] retrieve(Object criteria) throws DataBackendException {
        return this.retrieveList(criteria).toArray(new User[0]);
    }

    @Override
    public List retrieveList(Object criteria) throws DataBackendException {
        Vector<LDAPUser> users = new Vector<LDAPUser>(0);
        try {
            DirContext ctx = LDAPUserManager.bindAsAdmin();
            String userBaseSearch = LDAPSecurityConstants.getBaseSearch();
            String filter = LDAPSecurityConstants.getNameAttribute();
            filter = "(" + filter + "=*)";
            SearchControls ctls = new SearchControls();
            NamingEnumeration<SearchResult> answer = ctx.search(userBaseSearch, filter, ctls);
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attribs = sr.getAttributes();
                LDAPUser ldapUser = this.createLDAPUser();
                ldapUser.setLDAPAttributes(attribs);
                ldapUser.setTemp("turbine.user", ldapUser);
                users.add(ldapUser);
            }
        }
        catch (NamingException ex) {
            throw new DataBackendException("The LDAP server specified is unavailable", ex);
        }
        return users;
    }

    @Override
    public User retrieve(String username, String password) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        User user = this.retrieve(username);
        this.authenticate(user, password);
        return user;
    }

    @Override
    public void store(User user) throws UnknownEntityException, DataBackendException {
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getName() + "' does not exist");
        }
        try {
            LDAPUser ldapUser = (LDAPUser)user;
            Attributes attrs = ldapUser.getLDAPAttributes();
            String name = ldapUser.getDN();
            DirContext ctx = LDAPUserManager.bindAsAdmin();
            ctx.modifyAttributes(name, 2, attrs);
        }
        catch (NamingException ex) {
            throw new DataBackendException("NamingException caught", ex);
        }
    }

    @Override
    public void saveOnSessionUnbind(User user) throws UnknownEntityException, DataBackendException {
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getName() + "' does not exist");
        }
    }

    @Override
    public void authenticate(User user, String password) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        LDAPUser ldapUser = (LDAPUser)user;
        try {
            LDAPUserManager.bind(ldapUser.getDN(), password);
        }
        catch (AuthenticationException ex) {
            throw new PasswordMismatchException("The given password for: " + ldapUser.getDN() + " is invalid\n");
        }
        catch (NamingException ex) {
            throw new DataBackendException("NamingException caught:", ex);
        }
    }

    @Override
    public void changePassword(User user, String oldPass, String newPass) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        throw new DataBackendException("The method changePassword has no implementation.");
    }

    @Override
    public void forcePassword(User user, String password) throws UnknownEntityException, DataBackendException {
        throw new DataBackendException("The method forcePassword has no implementation.");
    }

    @Override
    public void createAccount(User user, String initialPassword) throws EntityExistsException, DataBackendException {
        if (this.accountExists(user)) {
            throw new EntityExistsException("The account '" + user.getName() + "' already exist");
        }
        try {
            LDAPUser ldapUser = (LDAPUser)user;
            Attributes attrs = ldapUser.getLDAPAttributes();
            String name = ldapUser.getDN();
            DirContext ctx = LDAPUserManager.bindAsAdmin();
            ctx.bind(name, null, attrs);
        }
        catch (NamingException ex) {
            throw new DataBackendException("NamingException caught", ex);
        }
    }

    @Override
    public void removeAccount(User user) throws UnknownEntityException, DataBackendException {
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getName() + "' does not exist");
        }
        try {
            LDAPUser ldapUser = (LDAPUser)user;
            String name = ldapUser.getDN();
            DirContext ctx = LDAPUserManager.bindAsAdmin();
            ctx.unbind(name);
        }
        catch (NamingException ex) {
            throw new DataBackendException("NamingException caught", ex);
        }
    }

    public static DirContext bindAsAdmin() throws NamingException {
        String adminUser = LDAPSecurityConstants.getAdminUsername();
        String adminPassword = LDAPSecurityConstants.getAdminPassword();
        return LDAPUserManager.bind(adminUser, adminPassword);
    }

    public static DirContext bind(String username, String password) throws NamingException {
        String host = LDAPSecurityConstants.getLDAPHost();
        String port = LDAPSecurityConstants.getLDAPPort();
        String providerURL = "ldap://" + host + ":" + port;
        String ldapProvider = LDAPSecurityConstants.getLDAPProvider();
        String authentication = LDAPSecurityConstants.getLDAPAuthentication();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", ldapProvider);
        env.put("java.naming.provider.url", providerURL);
        env.put("java.naming.security.authentication", authentication);
        env.put("java.naming.security.principal", username);
        env.put("java.naming.security.credentials", password);
        InitialDirContext ctx = new InitialDirContext(env);
        return ctx;
    }

    private LDAPUser createLDAPUser() throws DataBackendException {
        try {
            return (LDAPUser)TurbineSecurity.getUserInstance();
        }
        catch (ClassCastException ex) {
            throw new DataBackendException("ClassCastException:", ex);
        }
        catch (UnknownEntityException ex) {
            throw new DataBackendException("UnknownEntityException:", ex);
        }
    }
}

