/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.io.Serializable;
import java.sql.Connection;
import org.apache.commons.lang.ObjectUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.Transaction;
import org.apache.turbine.services.schedule.AbstractJobEntry;
import org.apache.turbine.services.schedule.JobEntryTorque;
import org.apache.turbine.services.schedule.JobEntryTorquePeer;

public abstract class BaseJobEntryTorque
extends AbstractJobEntry
implements Persistent,
Serializable {
    private static final long serialVersionUID = 1450726821044L;
    private int jobId = 0;
    private int second = -1;
    private int minute = -1;
    private int hour = -1;
    private int weekDay = -1;
    private int dayOfMonth = -1;
    private String task = null;
    private String email = null;
    private byte[] property = null;
    private boolean modified = true;
    private boolean isNew = true;
    private boolean saving = false;
    private boolean loading = false;
    private boolean deleted = false;
    private static final JobEntryTorquePeer peer = new JobEntryTorquePeer();

    @Override
    public int getJobId() {
        return this.jobId;
    }

    @Override
    public void setJobId(int v) {
        if (this.jobId != v) {
            this.setModified(true);
        }
        this.jobId = v;
    }

    @Override
    public int getSecond() {
        return this.second;
    }

    @Override
    public void setSecond(int v) {
        if (this.second != v) {
            this.setModified(true);
        }
        this.second = v;
    }

    @Override
    public int getMinute() {
        return this.minute;
    }

    @Override
    public void setMinute(int v) {
        if (this.minute != v) {
            this.setModified(true);
        }
        this.minute = v;
    }

    @Override
    public int getHour() {
        return this.hour;
    }

    @Override
    public void setHour(int v) {
        if (this.hour != v) {
            this.setModified(true);
        }
        this.hour = v;
    }

    @Override
    public int getWeekDay() {
        return this.weekDay;
    }

    @Override
    public void setWeekDay(int v) {
        if (this.weekDay != v) {
            this.setModified(true);
        }
        this.weekDay = v;
    }

    @Override
    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    @Override
    public void setDayOfMonth(int v) {
        if (this.dayOfMonth != v) {
            this.setModified(true);
        }
        this.dayOfMonth = v;
    }

    @Override
    public String getTask() {
        return this.task;
    }

    @Override
    public void setTask(String v) {
        if (!ObjectUtils.equals((Object)this.task, (Object)v)) {
            this.setModified(true);
        }
        this.task = v;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String v) {
        if (!ObjectUtils.equals((Object)this.email, (Object)v)) {
            this.setModified(true);
        }
        this.email = v;
    }

    public byte[] getProperty() {
        return this.property;
    }

    public void setProperty(byte[] v) {
        if (!ObjectUtils.equals((Object)this.property, (Object)v)) {
            this.setModified(true);
        }
        this.property = v;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void resetModified() {
        this.modified = false;
    }

    public boolean isSaving() {
        return this.saving;
    }

    public void setSaving(boolean saving) {
        this.saving = saving;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void save() throws TorqueException {
        this.save(JobEntryTorquePeer.DATABASE_NAME);
    }

    public void save(String dbName) throws TorqueException {
        Connection con = null;
        try {
            con = Transaction.begin((String)dbName);
            this.save(con);
            Transaction.commit((Connection)con);
        }
        catch (TorqueException e) {
            Transaction.safeRollback((Connection)con);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Connection con) throws TorqueException {
        if (this.isSaving()) {
            return;
        }
        try {
            this.setSaving(true);
            if (this.isModified()) {
                if (this.isNew()) {
                    JobEntryTorquePeer.doInsert((JobEntryTorque)this, con);
                    this.setNew(false);
                } else {
                    JobEntryTorquePeer.doUpdate((JobEntryTorque)this, con);
                }
            }
        }
        finally {
            this.setSaving(false);
        }
    }

    public void setPrimaryKey(ObjectKey key) {
        this.setJobId(((NumberKey)key).intValue());
    }

    public void setPrimaryKey(String key) {
        this.setJobId(Integer.parseInt(key));
    }

    public ObjectKey getPrimaryKey() {
        return SimpleKey.keyFor((int)this.getJobId());
    }

    public JobEntryTorque copy() throws TorqueException {
        return this.copy(true);
    }

    public JobEntryTorque copy(Connection con) throws TorqueException {
        return this.copy(true, con);
    }

    public JobEntryTorque copy(boolean deepcopy) throws TorqueException {
        JobEntryTorque jobEntryTorque = new JobEntryTorque();
        return this.copyInto(jobEntryTorque, deepcopy);
    }

    public JobEntryTorque copy(boolean deepcopy, Connection con) throws TorqueException {
        JobEntryTorque jobEntryTorque = new JobEntryTorque();
        return this.copyInto(jobEntryTorque, deepcopy, con);
    }

    public JobEntryTorque copyInto(JobEntryTorque copyObj) throws TorqueException {
        return this.copyInto(copyObj, true);
    }

    public JobEntryTorque copyInto(JobEntryTorque copyObj, Connection con) throws TorqueException {
        return this.copyInto(copyObj, true, con);
    }

    protected JobEntryTorque copyInto(JobEntryTorque copyObj, boolean deepcopy) throws TorqueException {
        copyObj.setJobId(0);
        copyObj.setSecond(this.second);
        copyObj.setMinute(this.minute);
        copyObj.setHour(this.hour);
        copyObj.setWeekDay(this.weekDay);
        copyObj.setDayOfMonth(this.dayOfMonth);
        copyObj.setTask(this.task);
        copyObj.setEmail(this.email);
        copyObj.setProperty(this.property);
        if (deepcopy) {
            // empty if block
        }
        return copyObj;
    }

    public JobEntryTorque copyInto(JobEntryTorque copyObj, boolean deepcopy, Connection con) throws TorqueException {
        copyObj.setJobId(0);
        copyObj.setSecond(this.second);
        copyObj.setMinute(this.minute);
        copyObj.setHour(this.hour);
        copyObj.setWeekDay(this.weekDay);
        copyObj.setDayOfMonth(this.dayOfMonth);
        copyObj.setTask(this.task);
        copyObj.setEmail(this.email);
        copyObj.setProperty(this.property);
        if (deepcopy) {
            // empty if block
        }
        return copyObj;
    }

    public JobEntryTorquePeer getPeer() {
        return peer;
    }

    public TableMap getTableMap() throws TorqueException {
        return JobEntryTorquePeer.getTableMap();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("JobEntryTorque:\n");
        str.append("jobId = ").append(this.getJobId()).append("\n");
        str.append("second = ").append(this.getSecond()).append("\n");
        str.append("minute = ").append(this.getMinute()).append("\n");
        str.append("hour = ").append(this.getHour()).append("\n");
        str.append("weekDay = ").append(this.getWeekDay()).append("\n");
        str.append("dayOfMonth = ").append(this.getDayOfMonth()).append("\n");
        str.append("task = ").append(this.getTask()).append("\n");
        str.append("email = ").append(this.getEmail()).append("\n");
        str.append("property = ").append("<binary>").append("\n");
        return str.toString();
    }

    public boolean equals(Object toCompare) {
        if (toCompare == null) {
            return false;
        }
        if (this == toCompare) {
            return true;
        }
        if (!this.getClass().equals(toCompare.getClass())) {
            return false;
        }
        JobEntryTorque other = (JobEntryTorque)toCompare;
        if (this.getPrimaryKey() == null || other.getPrimaryKey() == null) {
            return false;
        }
        return this.getPrimaryKey().equals((Object)other.getPrimaryKey());
    }

    public int hashCode() {
        ObjectKey ok = this.getPrimaryKey();
        if (ok == null) {
            return super.hashCode();
        }
        return ok.hashCode();
    }

    public boolean valueEquals(JobEntryTorque toCompare) {
        if (toCompare == null) {
            return false;
        }
        if (this == toCompare) {
            return true;
        }
        if (this.jobId != toCompare.getJobId()) {
            return false;
        }
        if (this.second != toCompare.getSecond()) {
            return false;
        }
        if (this.minute != toCompare.getMinute()) {
            return false;
        }
        if (this.hour != toCompare.getHour()) {
            return false;
        }
        if (this.weekDay != toCompare.getWeekDay()) {
            return false;
        }
        if (this.dayOfMonth != toCompare.getDayOfMonth()) {
            return false;
        }
        if (!ObjectUtils.equals((Object)this.task, (Object)toCompare.getTask())) {
            return false;
        }
        if (!ObjectUtils.equals((Object)this.email, (Object)toCompare.getEmail())) {
            return false;
        }
        return ObjectUtils.equals((Object)this.property, (Object)toCompare.getProperty());
    }
}

