/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.sql.whereclausebuilder;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.Adapter;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.criteria.PreparedStatementPart;
import org.apache.torque.criteria.SqlEnum;
import org.apache.torque.sql.WhereClauseExpression;
import org.apache.torque.sql.whereclausebuilder.AbstractWhereClausePsPartBuilder;

public class InBuilder
extends AbstractWhereClausePsPartBuilder {
    public PreparedStatementPart buildPs(WhereClauseExpression whereClausePart, boolean ignoreCase, Adapter adapter) throws TorqueException {
        PreparedStatementPart result = new PreparedStatementPart();
        boolean ignoreCaseApplied = false;
        ArrayList<String> inClause = new ArrayList<String>();
        boolean nullContained = false;
        if (whereClausePart.getRValue() instanceof Iterable) {
            for (Object listValue : (Iterable)whereClausePart.getRValue()) {
                if (listValue == null) {
                    nullContained = true;
                    continue;
                }
                result.getPreparedStatementReplacements().add(listValue);
                if (ignoreCase && listValue instanceof String) {
                    inClause.add(adapter.ignoreCase("?"));
                    ignoreCaseApplied = true;
                    continue;
                }
                inClause.add("?");
            }
        } else if (whereClausePart.getRValue().getClass().isArray()) {
            for (Object arrayValue : (Object[])whereClausePart.getRValue()) {
                if (arrayValue == null) {
                    nullContained = true;
                    continue;
                }
                result.getPreparedStatementReplacements().add(arrayValue);
                if (ignoreCase && arrayValue instanceof String) {
                    inClause.add(adapter.ignoreCase("?"));
                    ignoreCaseApplied = true;
                    continue;
                }
                inClause.add("?");
            }
        } else {
            throw new IllegalArgumentException("Unknown rValue type " + whereClausePart.getRValue().getClass().getName() + ". rValue must be an instance of " + " Iterable or Array");
        }
        if (nullContained) {
            result.getSql().append('(');
        }
        result.append(InBuilder.getObjectOrColumnPsPartBuilder().buildPs(whereClausePart.getLValue(), ignoreCaseApplied, adapter));
        result.getSql().append(whereClausePart.getOperator()).append('(').append(StringUtils.join(inClause.iterator(), (String)",")).append(')');
        if (nullContained) {
            if (whereClausePart.getOperator() == SqlEnum.IN) {
                result.getSql().append(" OR ");
                result.append(InBuilder.getObjectOrColumnPsPartBuilder().buildPs(whereClausePart.getLValue(), false, adapter));
                result.getSql().append(SqlEnum.ISNULL);
            } else if (whereClausePart.getOperator() == SqlEnum.NOT_IN) {
                result.getSql().append(" AND ");
                result.append(InBuilder.getObjectOrColumnPsPartBuilder().buildPs(whereClausePart.getLValue(), false, adapter));
                result.getSql().append(SqlEnum.ISNOTNULL);
            }
            result.getSql().append(')');
        }
        return result;
    }

    public boolean isApplicable(WhereClauseExpression whereClauseExpression, Adapter adapter) {
        return (whereClauseExpression.getOperator().equals(Criteria.IN) || whereClauseExpression.getOperator().equals(Criteria.NOT_IN)) && !(whereClauseExpression.getRValue() instanceof Criteria);
    }
}

