/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.parser;

import java.beans.IndexedPropertyDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.fulcrum.parser.ParserService;
import org.apache.fulcrum.parser.ParserServiceSupport;
import org.apache.fulcrum.parser.ValueParser;

public class BaseValueParser
implements ValueParser,
ParserServiceSupport,
LogEnabled {
    protected ParserService parserService;
    private Logger logger;
    private static final String[] trueValues = new String[]{"TRUE", "T", "YES", "Y", "1", "ON"};
    private static final String[] falseValues = new String[]{"FALSE", "F", "NO", "N", "0", "OFF"};
    private String characterEncoding = "US-ASCII";
    protected Hashtable<String, Object> parameters = new Hashtable();
    private Locale locale = Locale.getDefault();
    private DateFormat dateFormat = DateFormat.getDateInstance(3, this.locale);
    private NumberFormat numberFormat = NumberFormat.getNumberInstance(this.locale);
    private boolean disposed;

    public BaseValueParser() {
        this("US-ASCII");
    }

    public BaseValueParser(String characterEncoding) {
        this(characterEncoding, Locale.getDefault());
    }

    public BaseValueParser(String characterEncoding, Locale locale) {
        this.recycle(characterEncoding);
        this.setLocale(locale);
    }

    @Override
    public void setParserService(ParserService parserService) {
        this.parserService = parserService;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public void recycle() {
        this.recycle("US-ASCII");
    }

    public void recycle(String characterEncoding) {
        this.setCharacterEncoding(characterEncoding);
    }

    public void dispose() {
        this.clear();
        this.disposed = true;
    }

    @Override
    public void clear() {
        this.parameters.clear();
    }

    @Override
    public void setCharacterEncoding(String s) {
        this.characterEncoding = s;
    }

    @Override
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Override
    public void setLocale(Locale l) {
        this.locale = l;
        this.setDateFormat(DateFormat.getDateInstance(3, this.locale));
        this.setNumberFormat(NumberFormat.getNumberInstance(this.locale));
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setDateFormat(DateFormat df) {
        this.dateFormat = df;
    }

    @Override
    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public void setNumberFormat(NumberFormat nf) {
        this.numberFormat = nf;
    }

    @Override
    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    @Override
    public void add(String name, double value) {
        this.add(name, this.numberFormat.format(value));
    }

    @Override
    public void add(String name, int value) {
        this.add(name, (long)value);
    }

    @Override
    public void add(String name, Integer value) {
        if (value != null) {
            this.add(name, (int)value);
        }
    }

    @Override
    public void add(String name, long value) {
        this.add(name, Long.toString(value));
    }

    @Override
    public void add(String name, String value) {
        if (value != null) {
            Object[] items = this.getParam(name);
            items = (String[])ArrayUtils.add((Object[])items, (Object)value);
            this.putParam(name, (String[])items);
        }
    }

    @Override
    public void add(String name, String[] value) {
        if (value != null) {
            for (int i = 0; i < value.length; ++i) {
                if (value[i] == null) continue;
                this.add(name, value[i]);
            }
        }
    }

    @Override
    public Object remove(String name) {
        return this.parameters.remove(this.convert(name));
    }

    @Override
    public String convert(String value) {
        return this.convertAndTrim(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.parameters.containsKey(this.convert(String.valueOf(key)));
    }

    @Override
    public Set<String> keySet() {
        return this.parameters.keySet();
    }

    @Override
    public String[] getKeys() {
        return this.keySet().toArray(new String[0]);
    }

    @Override
    public Iterator<String> iterator() {
        return this.parameters.keySet().iterator();
    }

    private Boolean parseBoolean(String string) {
        Boolean result = null;
        String value = StringUtils.trim((String)string);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            for (int cnt = 0; cnt < Math.max(trueValues.length, falseValues.length); ++cnt) {
                if (cnt < trueValues.length && value.equalsIgnoreCase(trueValues[cnt])) {
                    result = Boolean.TRUE;
                    break;
                }
                if (cnt >= falseValues.length || !value.equalsIgnoreCase(falseValues[cnt])) continue;
                result = Boolean.FALSE;
                break;
            }
            if (result == null && this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Parameter with value of (" + value + ") could not be converted to a Boolean");
            }
        }
        return result;
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        Boolean result = this.getBooleanObject(name);
        return result == null ? defaultValue : result;
    }

    @Override
    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    @Override
    public boolean[] getBooleans(String name) {
        boolean[] result = null;
        String[] value = this.getParam(name);
        if (value != null) {
            result = new boolean[value.length];
            for (int i = 0; i < value.length; ++i) {
                Boolean bool = this.parseBoolean(value[i]);
                result[i] = bool == null ? false : bool;
            }
        }
        return result;
    }

    @Override
    public Boolean getBooleanObject(String name) {
        return this.parseBoolean(this.getString(name));
    }

    @Override
    public Boolean getBooleanObject(String name, Boolean defaultValue) {
        Boolean result = this.getBooleanObject(name);
        return result == null ? defaultValue : result;
    }

    @Override
    public Boolean[] getBooleanObjects(String name) {
        Boolean[] result = null;
        String[] value = this.getParam(name);
        if (value != null) {
            result = new Boolean[value.length];
            for (int i = 0; i < value.length; ++i) {
                result[i] = this.parseBoolean(value[i]);
            }
        }
        return result;
    }

    private Number parseNumber(String string) {
        Number result = null;
        String value = StringUtils.trim((String)string);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            ParsePosition pos = new ParsePosition(0);
            Number number = this.numberFormat.parse(value, pos);
            if (pos.getIndex() == value.length()) {
                result = number;
            } else if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Parameter with value of (" + value + ") could not be converted to a Number at position " + pos.getIndex());
            }
        }
        return result;
    }

    private Number getNumber(String name) {
        return this.parseNumber(this.getString(name));
    }

    @Override
    public double getDouble(String name, double defaultValue) {
        Number number = this.getNumber(name);
        return number == null ? defaultValue : number.doubleValue();
    }

    @Override
    public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    @Override
    public double[] getDoubles(String name) {
        double[] result = null;
        String[] value = this.getParam(name);
        if (value != null) {
            result = new double[value.length];
            for (int i = 0; i < value.length; ++i) {
                Number number = this.parseNumber(value[i]);
                result[i] = number == null ? 0.0 : number.doubleValue();
            }
        }
        return result;
    }

    @Override
    public Double getDoubleObject(String name, Double defaultValue) {
        Number result = this.getNumber(name);
        return result == null ? defaultValue : new Double(result.doubleValue());
    }

    @Override
    public Double getDoubleObject(String name) {
        return this.getDoubleObject(name, null);
    }

    @Override
    public Double[] getDoubleObjects(String name) {
        Double[] result = null;
        String[] value = this.getParam(name);
        if (value != null) {
            result = new Double[value.length];
            for (int i = 0; i < value.length; ++i) {
                Number number = this.parseNumber(value[i]);
                result[i] = number == null ? null : new Double(number.doubleValue());
            }
        }
        return result;
    }

    @Override
    public float getFloat(String name, float defaultValue) {
        Number number = this.getNumber(name);
        return number == null ? defaultValue : number.floatValue();
    }

    @Override
    public float getFloat(String name) {
        return this.getFloat(name, 0.0f);
    }

    @Override
    public float[] getFloats(String name) {
        float[] result = null;
        String[] value = this.getParam(name);
        if (value != null) {
            result = new float[value.length];
            for (int i = 0; i < value.length; ++i) {
                Number number = this.parseNumber(value[i]);
                result[i] = number == null ? 0.0f : number.floatValue();
            }
        }
        return result;
    }

    @Override
    public Float getFloatObject(String name, Float defaultValue) {
        Number result = this.getNumber(name);
        return result == null ? defaultValue : new Float(result.floatValue());
    }

    @Override
    public Float getFloatObject(String name) {
        return this.getFloatObject(name, null);
    }

    @Override
    public Float[] getFloatObjects(String name) {
        Float[] result = null;
        String[] value = this.getParam(name);
        if (value != null) {
            result = new Float[value.length];
            for (int i = 0; i < value.length; ++i) {
                Number number = this.parseNumber(value[i]);
                result[i] = number == null ? null : new Float(number.floatValue());
            }
        }
        return result;
    }

    @Override
    public BigDecimal getBigDecimal(String name, BigDecimal defaultValue) {
        Number result = this.getNumber(name);
        return result == null ? defaultValue : new BigDecimal(result.doubleValue());
    }

    @Override
    public BigDecimal getBigDecimal(String name) {
        return this.getBigDecimal(name, null);
    }

    @Override
    public BigDecimal[] getBigDecimals(String name) {
        BigDecimal[] result = null;
        String[] value = this.getParam(name);
        if (value != null) {
            result = new BigDecimal[value.length];
            for (int i = 0; i < value.length; ++i) {
                Number number = this.parseNumber(value[i]);
                result[i] = number == null ? null : new BigDecimal(number.doubleValue());
            }
        }
        return result;
    }

    @Override
    public int getInt(String name, int defaultValue) {
        Number result = this.getNumber(name);
        return result == null || result instanceof Double ? defaultValue : result.intValue();
    }

    @Override
    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    @Override
    public int[] getInts(String name) {
        int[] result = null;
        String[] value = this.getParam(name);
        if (value != null) {
            result = new int[value.length];
            for (int i = 0; i < value.length; ++i) {
                Number number = this.parseNumber(value[i]);
                result[i] = number == null || number instanceof Double ? 0 : number.intValue();
            }
        }
        return result;
    }

    @Override
    public Integer getIntObject(String name, Integer defaultValue) {
        Number result = this.getNumber(name);
        return result == null || result instanceof Double ? defaultValue : Integer.valueOf(result.intValue());
    }

    @Override
    public Integer getIntObject(String name) {
        return this.getIntObject(name, null);
    }

    @Override
    public Integer[] getIntObjects(String name) {
        Integer[] result = null;
        String[] value = this.getParam(name);
        if (value != null) {
            result = new Integer[value.length];
            for (int i = 0; i < value.length; ++i) {
                Number number = this.parseNumber(value[i]);
                result[i] = number == null || number instanceof Double ? null : Integer.valueOf(number.intValue());
            }
        }
        return result;
    }

    @Override
    public long getLong(String name, long defaultValue) {
        Number result = this.getNumber(name);
        return result == null || result instanceof Double ? defaultValue : result.longValue();
    }

    @Override
    public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    @Override
    public long[] getLongs(String name) {
        long[] result = null;
        String[] value = this.getParam(name);
        if (value != null) {
            result = new long[value.length];
            for (int i = 0; i < value.length; ++i) {
                Number number = this.parseNumber(value[i]);
                result[i] = number == null || number instanceof Double ? 0L : number.longValue();
            }
        }
        return result;
    }

    @Override
    public Long[] getLongObjects(String name) {
        Long[] result = null;
        String[] value = this.getParam(name);
        if (value != null) {
            result = new Long[value.length];
            for (int i = 0; i < value.length; ++i) {
                Number number = this.parseNumber(value[i]);
                result[i] = number == null || number instanceof Double ? null : Long.valueOf(number.longValue());
            }
        }
        return result;
    }

    @Override
    public Long getLongObject(String name) {
        return this.getLongObject(name, null);
    }

    @Override
    public Long getLongObject(String name, Long defaultValue) {
        Number result = this.getNumber(name);
        return result == null || result instanceof Double ? defaultValue : Long.valueOf(result.longValue());
    }

    @Override
    public byte getByte(String name, byte defaultValue) {
        Number result = this.getNumber(name);
        return result == null || result instanceof Double ? defaultValue : result.byteValue();
    }

    @Override
    public byte getByte(String name) {
        return this.getByte(name, (byte)0);
    }

    @Override
    public byte[] getBytes(String name) throws UnsupportedEncodingException {
        byte[] result = null;
        String value = this.getString(name);
        if (value != null) {
            result = value.getBytes(this.getCharacterEncoding());
        }
        return result;
    }

    @Override
    public Byte getByteObject(String name, Byte defaultValue) {
        Number result = this.getNumber(name);
        return result == null || result instanceof Double ? defaultValue : Byte.valueOf(result.byteValue());
    }

    @Override
    public Byte getByteObject(String name) {
        return this.getByteObject(name, null);
    }

    @Override
    public String getString(String name) {
        String[] value = this.getParam(name);
        return value == null || value.length == 0 ? null : value[0];
    }

    @Override
    public String get(String name) {
        return this.getString(name);
    }

    @Override
    public String getString(String name, String defaultValue) {
        String value = this.getString(name);
        return StringUtils.isEmpty((CharSequence)value) ? defaultValue : value;
    }

    @Override
    public void setString(String name, String value) {
        if (value != null) {
            this.putParam(name, new String[]{value});
        }
    }

    @Override
    public String[] getStrings(String name) {
        return this.getParam(name);
    }

    @Override
    public String[] getStrings(String name, String[] defaultValue) {
        String[] value = this.getParam(name);
        return value == null || value.length == 0 ? defaultValue : value;
    }

    @Override
    public void setStrings(String name, String[] values) {
        if (values != null) {
            this.putParam(name, values);
        }
    }

    @Override
    public Object getObject(String name) {
        return this.getString(name);
    }

    @Override
    public Object[] getObjects(String name) {
        return this.getParam(name);
    }

    @Override
    public Date getDate(String name, DateFormat df, Date defaultValue) {
        Date result = defaultValue;
        String value = StringUtils.trim((String)this.getString(name));
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            try {
                df.setLenient(false);
                result = df.parse(value);
            }
            catch (ParseException e) {
                this.logConversionFailure(name, value, "Date");
            }
        }
        return result;
    }

    @Override
    public Date getDate(String name) {
        return this.getDate(name, this.dateFormat, null);
    }

    @Override
    public Date getDate(String name, DateFormat df) {
        return this.getDate(name, df, null);
    }

    @Override
    public void setProperties(Object bean) throws Exception {
        PropertyDescriptor[] props;
        Class<?> beanClass = bean.getClass();
        for (PropertyDescriptor pd : props = Introspector.getBeanInfo(beanClass).getPropertyDescriptors()) {
            String propname = pd.getName();
            Method setter = pd.getWriteMethod();
            if (setter == null || !this.containsKey(propname)) continue;
            this.setProperty(bean, pd);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String name : this.keySet()) {
            sb.append('{');
            sb.append(name);
            sb.append('=');
            Object[] params = this.getToStringParam(name);
            if (params == null) {
                sb.append("unknown?");
            } else if (params.length == 0) {
                sb.append("empty");
            } else {
                sb.append('[');
                sb.append(StringUtils.join((Object[])params, (String)", "));
                sb.append(']');
            }
            sb.append("}\n");
        }
        return sb.toString();
    }

    protected Object[] getToStringParam(String name) {
        return this.getParam(name);
    }

    protected void setProperty(Object bean, PropertyDescriptor prop) throws Exception {
        if (prop instanceof IndexedPropertyDescriptor) {
            throw new Exception(prop.getName() + " is an indexed property (not supported)");
        }
        Method setter = prop.getWriteMethod();
        if (setter == null) {
            throw new Exception(prop.getName() + " is a read only property");
        }
        Class<?> propclass = prop.getPropertyType();
        Object arg = null;
        if (propclass == String.class) {
            arg = this.getString(prop.getName());
        } else if (propclass == Byte.class || propclass == Byte.TYPE) {
            arg = this.getByteObject(prop.getName());
        } else if (propclass == Integer.class || propclass == Integer.TYPE) {
            arg = this.getIntObject(prop.getName());
        } else if (propclass == Long.class || propclass == Long.TYPE) {
            arg = this.getLongObject(prop.getName());
        } else if (propclass == Boolean.class || propclass == Boolean.TYPE) {
            arg = this.getBooleanObject(prop.getName());
        } else if (propclass == Double.class || propclass == Double.TYPE) {
            arg = this.getDoubleObject(prop.getName());
        } else if (propclass == Float.class || propclass == Float.TYPE) {
            arg = this.getFloatObject(prop.getName());
        } else if (propclass == BigDecimal.class) {
            arg = this.getBigDecimal(prop.getName());
        } else if (propclass == String[].class) {
            arg = this.getStrings(prop.getName());
        } else if (propclass == Object.class) {
            arg = this.getObject(prop.getName());
        } else if (propclass == int[].class) {
            arg = this.getInts(prop.getName());
        } else if (propclass == Integer[].class) {
            arg = this.getIntObjects(prop.getName());
        } else if (propclass == Date.class) {
            arg = this.getDate(prop.getName());
        } else {
            throw new Exception("property " + prop.getName() + " is of unsupported type " + propclass.toString());
        }
        setter.invoke(bean, arg);
    }

    protected void putParam(String name, String[] value) {
        String key = this.convert(name);
        if (key != null) {
            this.parameters.put(key, value);
        }
    }

    protected String[] getParam(String name) {
        String key = this.convert(name);
        Object value = this.parameters.get(key);
        if (value instanceof String[]) {
            return (String[])this.parameters.get(key);
        }
        return null;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    private void logConversionFailure(String paramName, String value, String type) {
        this.getLogger().warn("Parameter (" + paramName + ") with value of (" + value + ") could not be converted to a " + type);
    }

    @Override
    public String convertAndTrim(String value) {
        return this.parserService.convertAndTrim(value);
    }

    @Override
    public String convertAndTrim(String value, ValueParser.URLCaseFolding fold) {
        return this.parserService.convertAndTrim(value, fold);
    }

    @Override
    public ValueParser.URLCaseFolding getUrlFolding() {
        return this.parserService.getUrlFolding();
    }

    public boolean isValid() {
        return this.parameters.size() == 0;
    }
}

