/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.actions;

import org.apache.commons.lang3.StringUtils;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.FulcrumSecurityException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.annotation.TurbineConfiguration;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.modules.Action;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.security.SecurityService;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;

public class LoginUser
implements Action {
    public static final String CGI_USERNAME = "username";
    public static final String CGI_PASSWORD = "password";
    private static Logger log = LogManager.getLogger(LoginUser.class);
    @TurbineService
    private SecurityService security;
    @TurbineConfiguration(value="login.error")
    private String loginError = "";
    @TurbineConfiguration(value="template.login")
    private String templateLogin;
    @TurbineConfiguration(value="screen.login")
    private String screenLogin;

    @Override
    public void doPerform(PipelineData pipelineData) throws FulcrumSecurityException {
        RunData data = pipelineData.getRunData();
        String username = data.getParameters().getString(CGI_USERNAME, "");
        String password = data.getParameters().getString(CGI_PASSWORD, "");
        if (StringUtils.isEmpty((CharSequence)username)) {
            return;
        }
        try {
            if (username.equals(this.security.getAnonymousUser().getName())) {
                throw new TurbineException("Anonymous user cannot login");
            }
            Object user = this.security.getAuthenticatedUser(username, password);
            data.setUser(user);
            user.setHasLoggedIn(Boolean.TRUE);
            user.updateLastLogin();
            data.save();
        }
        catch (Exception e) {
            if (e instanceof DataBackendException) {
                log.error((Object)e);
            }
            data.setMessage(this.loginError);
            Object anonymousUser = this.security.getAnonymousUser();
            data.setUser(anonymousUser);
            if (StringUtils.isNotEmpty((CharSequence)this.templateLogin)) {
                data.setScreenTemplate(this.templateLogin);
            }
            data.setScreen(this.screenLogin);
        }
    }
}

