/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs.ee.ejb;

import java.lang.reflect.InvocationTargetException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.jobs.ee.ejb.EJBInvokerJob;

public class EJB3InvokerJob
extends EJBInvokerJob {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap dataMap = context.getMergedJobDataMap();
        String ejb = dataMap.getString("ejb");
        String method = dataMap.getString("method");
        Object[] arguments = (Object[])dataMap.get("args");
        if (arguments == null) {
            arguments = new Object[]{};
        }
        if (ejb == null) {
            throw new JobExecutionException("must specify EJB_JNDI_NAME_KEY");
        }
        if (method == null) {
            throw new JobExecutionException("must specify EJB_METHOD_KEY");
        }
        InitialContext jndiContext = null;
        Object value = null;
        try {
            try {
                jndiContext = this.getInitialContext(dataMap);
                value = jndiContext.lookup(ejb);
            }
            catch (NamingException ne) {
                throw new JobExecutionException(ne);
            }
            Class[] argTypes = (Class[])dataMap.get("argTypes");
            if (argTypes == null) {
                argTypes = new Class[arguments.length];
                for (int i = 0; i < arguments.length; ++i) {
                    argTypes[i] = arguments[i].getClass();
                }
            }
            try {
                Object returnValue = value.getClass().getMethod(method, argTypes).invoke(value, arguments);
                context.setResult(returnValue);
            }
            catch (IllegalAccessException iae) {
                throw new JobExecutionException(iae);
            }
            catch (InvocationTargetException ite) {
                throw new JobExecutionException(ite.getTargetException());
            }
            catch (NoSuchMethodException nsme) {
                throw new JobExecutionException(nsme);
            }
        }
        finally {
            if (jndiContext != null) {
                try {
                    jndiContext.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

