<!--- Licensed to the Apache Software Foundation (ASF) under one -->
<!--- or more contributor license agreements.  See the NOTICE file -->
<!--- distributed with this work for additional information -->
<!--- regarding copyright ownership.  The ASF licenses this file -->
<!--- to you under the Apache License, Version 2.0 (the -->
<!--- "License"); you may not use this file except in compliance -->
<!--- with the License.  You may obtain a copy of the License at -->

<!---   http://www.apache.org/licenses/LICENSE-2.0 -->

<!--- Unless required by applicable law or agreed to in writing, -->
<!--- software distributed under the License is distributed on an -->
<!--- "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY -->
<!--- KIND, either express or implied.  See the License for the -->
<!--- specific language governing permissions and limitations -->
<!--- under the License. -->

TVM Contributors
================
TVM adopts the Apache way and governs by merit. We believe that it is important to create an inclusive community where everyone can use,
contribute to, and influence the direction of the project. We actively invite contributors who have earned the merit to be part of the development community.

See the [community structure document](https://tvm.apache.org/docs/contribute/community.html) for the explanation of community structure and contribution guidelines.


## Committers

We add tag along with committer name to show areas that they are familiar with.
We do encourage everyone to work anything they are interested in.

- [Aditya Atluri](https://github.com/adityaatluri): @adityaatluri - rocm
- [Matthew Barrett](https://github.com/mbaret): @mbaret - byoc, arm
- [Matthew Brookhart](https://github.com/mbrookhart): @mbrookhart - relay, frontends
- [Liangfu Chen](https://github.com/liangfu): @liangfu - vta, chisel, intel FPGA, c runtime
- [Tianqi Chen](https://github.com/tqchen) (PMC): @tqchen - topi, compiler, relay, docs
- [Wei Chen](https://github.com/wweic): @wweic - runtime, relay, vm
- [Zhi Chen](https://github.com/zhiics) (PMC): @zhiics - relay, quantization, pass manager
- [Siyuan Feng](https://github.com/Hzfengsy): @Hzfengsy - tir
- [Josh Fromm](https://github.com/jwfromm): @jwfromm - frontends, quantization, topi
- [Yuwei Hu](https://github.com/Huyuwei): @Huyuwei - topi, frontends
- [Nick Hynes](https://github.com/nhynes): @nhynes: - sgx, rust
- [Animesh Jain](https://github.com/anijain2305): @anijain2305 - quantization, relay
- [Chenfan Jia](https://github.com/jcf94): @jcf94 - auto_scheduler
- [Ziheng Jiang](https://github.com/ZihengJiang) (PMC): @ZihengJiang - relay, compiler
- [Manupa Karunaratne](https://github.com/manupa-arm): @manupa-arm - ethos-u, memory planner
- [Marisa Kirisame](https://github.com/MarisaKirisame): @MarisaKirisame - relay
- [Wuwei Lin](https://github.com/vinx13): @vinx13 - relay, topi
- [Yizhi Liu](https://github.com/yzhliu) (PMC): @yzhliu - jvm, topi, relay
- [Hao Lu](https://github.com/hlu1): @hlu1 - nnpack, frontends
- [Steven Lyubomirsky](https://github.com/slyubomirsky): @slyubomirsky - relay
- [Masahiro Masuda](https://github.com/masahi) (PMC): @masahi - topi, relay
- [Thierry Moreau](https://github.com/tmoreau89) (PMC): @tmoreau89 - vta
- [Kazutaka Morita](https://github.com/kazum): @kazum - frontends, opencl
- [Trevor Morris](https://github.com/trevor-m): @trevor-m - byoc, compiler
- [Leandro Nunes](https://github.com/leandron): @leandron - tvmc
- [Krzysztof Parzyszek](https://github.com/kparzysz-quic): @kparzysz-quic - hexagon, llvm
- [Andrew Reusch](https://github.com/areusch): @areusch - runtime, microTVM
- [Jared Roesch](https://github.com/jroesch) (PMC): @jroesch - relay
- [Giuseppe Rossini](https://github.com/giuseros): @giuseros - aot, arm
- [Siju Samuel](https://github.com/siju-samuel): @siju-samuel - frontends
- [Junru Shao](https://github.com/junrushao1994) (PMC): @junrushao1994 - relay, compiler
- [Haichen Shen](https://github.com/icemelon) (PMC): @icemelon - relay, topi
- [Siva Rama Krishna Reddy](https://github.com/srkreddy1238): @srkreddy1238 - frontends, golang
- [Zhixun Tan](https://github.com/phisiart): @phisiart - opengl, web
- [Andrew Tulloch](https://github.com/ajtulloch): @ajtulloch - topi, compiler, runtime
- [Luis Vega](https://github.com/vegaluisjose): @vegaluisjose - vta, chisel
- [Leyuan Wang](https://github.com/Laurawly) (PMC): @Laurawly: - topi
- [Yao Wang](https://github.com/kevinthesun): @kevinthesun (PMC): - topi, vision
- [Jian Weng](https://github.com/were): @were: - hybrid script
- [Zhao Wu](https://github.com/FrozenGene): @FrozenGene - runtime, topi, frontends
- [Eddie Yan](https://github.com/eqy) (PMC): @eqy - runtime, autotvm, rpc, topi
- [Hao Yu](https://github.com/comaniac): @comaniac (PMC) - relay, byoc, auto_scheduler
- [Lianmin Zheng](https://github.com/merrymercy) (PMC): @merrymercy - autotvm, auto_scheduler, topi, relay

## Reviewers

- [Aditya Atluri](https://github.com/adityaatluri): @adityaatluri
- [Matthew Barrett](https://github.com/mbaret): @mbaret
- [Arnaud Bergeron](https://github.com/abergeron): @abergeron
- [Matthew Brookhart](https://github.com/mbrookhart): @mbrookhart
- [Liangfu Chen](https://github.com/liangfu): @liangfu
- [Tianqi Chen](https://github.com/tqchen): @tqchen
- [Zhi Chen](https://github.com/zhiics): @zhiics
- [Neo Chien](https://github.com/cchung100m): @cchung100m
- [Meghan Cowan](https://github.com/cowanmeg): @cowanmeg
- [Balint Cristian](https://github.com/cbalint13): @cbalint13
- [Egor Churaev](https://github.com/echuraev): @echuraev - metal
- [Xiaoqiang Dan](https://github.com/xqdan): @xqdan
- [Haozheng Fan](https://github.com/hzfan): @hzfan
- [Siyuan Feng](https://github.com/Hzfengsy): @Hzfengsy
- [Josh Fromm](https://github.com/jwfromm): @jwfromm
- [Sergei Grechanik](https://github.com/sgrechanik-h): @sgrechanik-h
- [Mehrdad Hessar](https://github.com/mehrdadh): @mehrdadh
- [Bohan Hou](https://github.com/spectrometerHBH): @spectrometerHBH
- [Yuwei Hu](https://github.com/Huyuwei): @Huyuwei
- [Luke Hutton](https://github.com/lhutton1): @lhutton1
- [Nick Hynes](https://github.com/nhynes): @nhynes
- [Animesh Jain](https://github.com/anijain2305): @anijain2305
- [Chenfan Jia](https://github.com/jcf94): @jcf94
- [Hua Jiang](https://github.com/huajsj): @huajsj
- [Ziheng Jiang](https://github.com/ZihengJiang): @ZihengJiang
- [Manupa Karunaratne](https://github.com/manupa-arm): @manupa-arm
- [Marisa Kirisame](https://github.com/MarisaKirisame): @MarisaKirisame
- [Tristan Konolige](https://github.com/tkonolige): @tkonolige
- [Wuwei Lin](https://github.com/vinx13): @vinx13
- [Andrew Liu](https://github.com/hypercubestart): @hypercubestart
- [Henry Liu](https://github.com/optima2005): @optima2005
- [Xin Liu](https://github.com/Meteorix): @Meteorix
- [Yizhi Liu](https://github.com/yzhliu) : @yzhliu
- [Hao Lu](https://github.com/hlu1): @hlu1
- [Eric Lunderberg](https://github.com/Lunderberg): @Lunderberg
- [Andrew Z. Luo](https://github.com/AndrewZhaoLuo): @AndrewZhaoLuo
- [Steven Lyubomirsky](https://github.com/slyubomirsky): @slyubomirsky
- [Masahiro Masuda](https://github.com/masahi): @masahi
- [Andrey Malyshev](https://github.com/elvin-n): @elvin-n
- [Sergey Mironov](https://github.com/grwlf): @grwlf
- [Thierry Moreau](https://github.com/tmoreau89): @tmoreau89
- [Kazutaka Morita](https://github.com/kazum): @kazum
- [Trevor Morris](https://github.com/trevor-m): @trevor-m
- [Tatsuya Nishiyama](https://github.com/nishi-t): @nishi-t
- [Leandro Nunes](https://github.com/leandron): @leandron
- [Jiawei Liu](https://github.com/ganler): @ganler
- [Lily Orth-Smith](https://github.com/electriclilies): @electriclilies
- [Wei Pan](https://github.com/wpan11nv): @wpan11nv
- [Krzysztof Parzyszek](https://github.com/kparzysz-quic): @kparzysz-quic
- [Pariksheet Pinjari](https://github.com/PariksheetPinjari909): @PariksheetPinjari909
- [Josh Pollock](https://github.com/joshpoll): @joshpoll
- [Andrew Reusch](https://github.com/areusch): @areusch
- [Jared Roesch](https://github.com/jroesch): @jroesch
- [Gustavo Romero](https://github.com/gromero): @gromero
- [Giuseppe Rossini](https://github.com/giuseros): @giuseros
- [Siju Samuel](https://github.com/siju-samuel): @siju-samuel
- [Junru Shao](https://github.com/junrushao1994): @junrushao1994
- [Haichen Shen](https://github.com/icemelon): @icemelon
- [Xingjian Shi](https://github.com/sxjscience): @sxjscience
- [Mark Shields](https://github.com/mbs-octoml): @mbs-octoml
- [Christopher Sidebottom](https://github.com/mousius): @mousius
- [Siva Rama Krishna Reddy](https://github.com/srkreddy1238): @srkreddy1238
- [Dmitriy Smirnov](https://github.com/d-smirnov): @d-smirnov
- [Jon Soifer](https://github.com/soiferj): @soiferj
- [Chris Sullivan](https://github.com/csullivan): @csullivan
- [Zhixun Tan](https://github.com/phisiart): @phisiart
- [Andrew Tulloch](https://github.com/ajtulloch): @ajtulloch
- [Jorn Tuyls](https://github.com/jtuyls): @jtuyls
- [Luis Vega](https://github.com/vegaluisjose): @vegaluisjose
- [Thomas Viehmann](https://github.com/t-vi): @t-vi
- [Yao Wang](https://github.com/kevinthesun): @kevinthesun
- [Yuchen Wang](https://github.com/wyc-ruiker): @wyc-ruiker
- [Leyuan Wang](https://github.com/Laurawly): @Laurawly
- [Alex Weaver](https://github.com/alex-weaver): @alex-weaver
- [Logan Weber](https://github.com/weberlo): @weberlo
- [Matt Welsh](https://github.com/mdw-octoml): @mdw-octoml
- [Jian Weng](https://github.com/were): @were
- [wrongtest](https://github.com/wrongtest): @wrongtest
- [Yong Wu](https://github.com/yongwww): @yongwww
- [Zhao Wu](https://github.com/FrozenGene): @FrozenGene
- [Bing Xu](https://github.com/antinucleon): @antinucleon
- [Eddie Yan](https://github.com/eqy): @eqy
- [Hao Yu](https://github.com/comaniac): @comaniac
- [Joshua Z. Zhang](https://github.com/zhreshold): @zhreshold
- [Lianmin Zheng](https://github.com/merrymercy): @merrymercy
- [Xiyou Zhou](https://github.com/zxybazh): @zxybazh

## List of Contributors
- [Full List of Contributors](https://github.com/apache/tvm/graphs/contributors)

## Mentors

TVM is now a top-level Apache project. During our Incubator phase, we were fortunate to have the following mentors.

- Markus Weimer @markusweimer
- Sebastian Schelter @sscdotopen
- Byung-Gon Chun @bgchun
- Henry Saputra @hsaputra
- Timothy Chen @tnachen
- Furkan KAMACI @kamaci
