/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#include <stdio.h>
#include <tvm_runtime.h>

#include "ethosu_mod.h"
#include "uart.h"

// Header files generated by convert_image.py and convert_labels.py
#include "inputs.h"
#include "labels.h"
#include "outputs.h"

int abs(int v) { return v * ((v > 0) - (v < 0)); }

int main(int argc, char** argv) {
  uart_init();
  printf("Starting Demo\n");
  EthosuInit();

  printf("Allocating memory\n");
  StackMemoryManager_Init(&app_workspace, g_aot_memory, WORKSPACE_SIZE);

  printf("Running inference\n");
  struct tvmgen_default_outputs outputs = {
      .output = output,
  };
  struct tvmgen_default_inputs inputs = {
      .input = input,
  };
  tvmgen_default_run(&inputs, &outputs);

  // Calculate index of max value
  uint8_t max_value = 0;
  int32_t max_index = -1;
  for (unsigned int i = 0; i < output_len; ++i) {
    if (output[i] > max_value) {
      max_value = output[i];
      max_index = i;
    }
  }
  printf("The image has been classified as '%s'\n", labels[max_index]);

  // The FVP will shut down when it receives "EXITTHESIM" on the UART
  printf("EXITTHESIM\n");
  while (1 == 1)
    ;
  return 0;
}
