/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.extension;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.ruta.textruler.TextRulerPlugin;
import org.apache.uima.ruta.textruler.core.GlobalCASSource;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.ruta.textruler.extension.TextRulerPreprocessorDelegate;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class TextRulerPreprocessor {
    public String run(String inFolder, String tmFile, String tmpDir, TextRulerPreprocessorDelegate delegate) {
        AnalysisEngine ae = TextRulerToolkit.loadAnalysisEngine(TextRulerToolkit.getEngineDescriptorFromTMSourceFile((IPath)new Path(tmFile)));
        File inputFolder = new File(inFolder);
        File outputFolder = new File(tmpDir + "input");
        File[] files = inputFolder.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xmi");
            }
        });
        try {
            outputFolder.mkdir();
        }
        catch (Exception e) {
            TextRulerPlugin.error(e);
            return null;
        }
        CAS cas = null;
        for (File file : files) {
            if (delegate != null && delegate.shouldAbort()) {
                TextRulerToolkit.log("[PREPROCESSOR] ABORT");
                break;
            }
            TextRulerToolkit.log("Load INPUT XMI file: " + file.getName());
            if (delegate != null) {
                delegate.preprocessorStatusUpdate(this, "Loading input XMI file: " + file.getName());
            }
            cas = TextRulerToolkit.readCASfromXMIFile(file, ae, cas);
            System.out.print("Processing...");
            try {
                ae.process(cas);
                TextRulerToolkit.log(" OK");
                TextRulerToolkit.writeCAStoXMIFile(cas, outputFolder + "/processed_" + file.getName());
            }
            catch (Exception e) {
                TextRulerPlugin.error(e);
                TextRulerToolkit.log(" ERROR!");
            }
            cas.reset();
            if (delegate == null) continue;
            delegate.preprocessorStatusUpdate(this, "Done");
        }
        if (cas != null) {
            cas.reset();
            GlobalCASSource.releaseCAS(cas);
        }
        return tmpDir + "input";
    }
}

