/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.GenericSorter;
import net.sf.saxon.sort.NodeOrderComparer;
import net.sf.saxon.sort.Sortable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;

public final class DocumentOrderIterator
implements SequenceIterator,
Sortable {
    private SequenceIterator iterator;
    private SequenceExtent sequence;
    private NodeOrderComparer comparer;
    private NodeInfo current = null;
    private int position = 0;

    public DocumentOrderIterator(SequenceIterator sequenceIterator, NodeOrderComparer nodeOrderComparer) throws XPathException {
        this.comparer = nodeOrderComparer;
        this.sequence = new SequenceExtent(sequenceIterator);
        if (this.sequence.getLength() > 1) {
            GenericSorter.quickSort(0, this.sequence.getLength(), this);
        }
        this.iterator = this.sequence.iterate();
    }

    private DocumentOrderIterator() {
    }

    public int compare(int n, int n2) {
        return this.comparer.compare((NodeInfo)this.sequence.itemAt(n), (NodeInfo)this.sequence.itemAt(n2));
    }

    public void swap(int n, int n2) {
        this.sequence.swap(n, n2);
    }

    public Item next() throws XPathException {
        NodeInfo nodeInfo;
        do {
            if ((nodeInfo = (NodeInfo)this.iterator.next()) != null) continue;
            this.current = null;
            this.position = -1;
            return null;
        } while (this.current != null && nodeInfo.isSameNodeInfo(this.current));
        ++this.position;
        this.current = nodeInfo;
        return this.current;
    }

    public int getProperties() {
        return 0;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        DocumentOrderIterator documentOrderIterator = new DocumentOrderIterator();
        documentOrderIterator.iterator = this.iterator.getAnother();
        return documentOrderIterator;
    }
}

