/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cpm;

import java.io.File;
import java.io.IOException;
import javax.swing.JCheckBox;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.tools.cpm.MetaDataPanel;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;

public class AnalysisEnginePanel
extends MetaDataPanel {
    private static final long serialVersionUID = -5927337001602381195L;
    JCheckBox shouldRunCheckBox = new JCheckBox((String)null, true);
    ResourceSpecifier aeSpecifier;
    File specifierFile;
    long lastFileSyncTimestamp;

    public AnalysisEnginePanel(ResourceSpecifier aeSpecifier, File specifierFile, long fileModStamp) {
        super(4);
        this.aeSpecifier = aeSpecifier;
        this.specifierFile = specifierFile;
        this.lastFileSyncTimestamp = fileModStamp;
    }

    public ResourceSpecifier getAnalysisEngineSpecifier() {
        return this.aeSpecifier;
    }

    public long getLastFileSyncTimestamp() {
        return this.lastFileSyncTimestamp;
    }

    public void setLastFileSyncTimestamp(long timestamp) {
        this.lastFileSyncTimestamp = timestamp;
    }

    public boolean hasFileChanged(long lastCheck) {
        return this.specifierFile.lastModified() > this.lastFileSyncTimestamp && this.specifierFile.lastModified() > lastCheck;
    }

    public void refreshFromFile() throws InvalidXMLException, IOException {
        this.clearAll();
        this.aeSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(this.specifierFile));
        if (this.aeSpecifier instanceof AnalysisEngineDescription) {
            AnalysisEngineDescription aeDescription = (AnalysisEngineDescription)this.aeSpecifier;
            this.populate(aeDescription.getMetaData(), null);
        } else {
            this.removeAll();
        }
        this.lastFileSyncTimestamp = this.specifierFile.lastModified();
    }
}

