/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.uima.UimaSerializable;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Marker;
import org.apache.uima.cas.impl.BinaryCasSerDes;
import org.apache.uima.cas.impl.BinaryCasSerDes6;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CommonSerDes;
import org.apache.uima.cas.impl.CommonSerDesSequential;
import org.apache.uima.cas.impl.FSsTobeAddedback;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.FeatureStructureImplC;
import org.apache.uima.cas.impl.MarkerImpl;
import org.apache.uima.cas.impl.SlotKinds;
import org.apache.uima.cas.impl.SlotKindsConstants;
import org.apache.uima.cas.impl.StringHeap;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.Int2ObjHashMap;
import org.apache.uima.internal.util.IntListIterator;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.internal.util.Obj2IntIdentityHashMap;
import org.apache.uima.internal.util.PositiveIntSet;
import org.apache.uima.internal.util.PositiveIntSet_impl;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.BooleanArray;
import org.apache.uima.jcas.cas.ByteArray;
import org.apache.uima.jcas.cas.DoubleArray;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.FloatArray;
import org.apache.uima.jcas.cas.IntegerArray;
import org.apache.uima.jcas.cas.LongArray;
import org.apache.uima.jcas.cas.ShortArray;
import org.apache.uima.jcas.cas.Sofa;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.util.CasIOUtils;
import org.apache.uima.util.impl.DataIO;
import org.apache.uima.util.impl.OptimizeStrings;
import org.apache.uima.util.impl.SerializationMeasures;

public class BinaryCasSerDes4
implements SlotKindsConstants {
    private static final boolean TRACE_SER = false;
    private static final boolean TRACE_DES = false;
    private static final boolean TRACE_DOUBLE = false;
    public static final int TYPECODE_COMPR = 8;
    public static final boolean IS_DIFF_ENCODE = true;
    public static final boolean CAN_BE_NEGATIVE = true;
    public static final boolean IGNORED = true;
    public static final boolean IN_MAIN_HEAP = true;
    private final TypeSystemImpl ts;
    private final boolean doMeasurements;
    final TypeImpl fsArrayType;

    public BinaryCasSerDes4(TypeSystemImpl ts, boolean doMeasurements) {
        this.ts = ts;
        this.doMeasurements = doMeasurements;
        this.fsArrayType = ts.fsArrayType;
    }

    public SerializationMeasures serialize(AbstractCas cas, Object out, Marker trackingMark, CompressLevel compressLevel, CompressStrat compressStrategy) throws IOException {
        SerializationMeasures sm = this.doMeasurements ? new SerializationMeasures() : null;
        CASImpl casImpl = (CASImpl)(cas instanceof JCas ? ((JCas)cas).getCas() : cas);
        if (null != trackingMark && !trackingMark.isValid()) {
            throw new CASRuntimeException("INVALID_MARKER", "Invalid Marker.");
        }
        Serializer serializer = new Serializer(casImpl, BinaryCasSerDes4.makeDataOutputStream(out), (MarkerImpl)trackingMark, sm, compressLevel, compressStrategy, false);
        serializer.serialize();
        return sm;
    }

    public void serializeWithTsi(CASImpl casImpl, Object out) throws IOException {
        Serializer serializer = new Serializer(casImpl, BinaryCasSerDes4.makeDataOutputStream(out), null, null, CompressLevel.Default, CompressStrat.Default, true);
        serializer.serialize();
    }

    public SerializationMeasures serialize(AbstractCas cas, Object out, Marker trackingMark, CompressLevel compressLevel) throws IOException {
        return this.serialize(cas, out, trackingMark, compressLevel, CompressStrat.Default);
    }

    public SerializationMeasures serialize(AbstractCas cas, Object out, Marker trackingMark) throws IOException {
        return this.serialize(cas, out, trackingMark, CompressLevel.Default, CompressStrat.Default);
    }

    public SerializationMeasures serialize(AbstractCas cas, Object out) throws IOException {
        return this.serialize(cas, out, null);
    }

    public void deserialize(CASImpl cas, InputStream deserIn, boolean isDelta, CommonSerDes.Header h) throws IOException {
        DataInput in = (DataInput)((Object)deserIn);
        Deserializer deserializer = new Deserializer(cas, in, isDelta);
        deserializer.deserialize(h);
    }

    private static DataOutputStream makeDataOutputStream(Object f) throws FileNotFoundException {
        if (f instanceof DataOutputStream) {
            return (DataOutputStream)f;
        }
        if (f instanceof OutputStream) {
            return new DataOutputStream((OutputStream)f);
        }
        if (f instanceof File) {
            FileOutputStream fos = new FileOutputStream((File)f);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            return new DataOutputStream(bos);
        }
        throw new RuntimeException(String.format("Invalid class passed to method, class was %s", f.getClass().getName()));
    }

    static CommonSerDesSequential getCsds(CASImpl cas, boolean isDelta) {
        CommonSerDesSequential tmpCsds = cas.getCsds();
        if (!isDelta || null == tmpCsds || tmpCsds.isEmpty()) {
            tmpCsds = cas.newCsds();
            tmpCsds.setup(null, 1);
        } else assert (null != tmpCsds);
        return tmpCsds;
    }

    public static void dumpCas(CASImpl cas) {
        CommonSerDesSequential csds = new CommonSerDesSequential(cas);
        csds.setup(null, 1);
        for (TOP fs : csds.getSortedFSs()) {
            System.out.format("debug heapAddr: %,d type: %s%n", csds.fs2addr.get(fs), fs._getTypeImpl().getShortName());
        }
        System.out.format("debug heapend: %,d%n", csds.getHeapEnd());
    }

    private class Deserializer {
        private final CASImpl baseCas;
        private final CASImpl ivCas;
        private final BinaryCasSerDes bcsd;
        private final CommonSerDesSequential csds;
        private final DataInput deserIn;
        private final DataInputStream[] dataInputs = new DataInputStream[SlotKindsConstants.NBR_SLOT_KIND_ZIP_STREAMS];
        private Inflater[] inflaters = new Inflater[SlotKindsConstants.NBR_SLOT_KIND_ZIP_STREAMS];
        private TOP currentFs;
        private final List<Runnable> singleFsDefer = new ArrayList<Runnable>();
        private int sofaNum;
        private String sofaName;
        private Sofa sofaRef;
        private int heapStart;
        private int heapEnd;
        private final List<Runnable> fixupsNeeded = new ArrayList<Runnable>();
        private final List<Runnable> uimaSerializableFixups = new ArrayList<Runnable>();
        private final StringHeap stringHeapObj = new StringHeap();
        private final boolean isDelta;
        private String[] readCommonString;
        private boolean only1CommonString;
        private final DataInputStream arrayLength_dis;
        private final DataInputStream heapRef_dis;
        private final DataInputStream int_dis;
        private final DataInputStream byte_dis;
        private final DataInputStream short_dis;
        private final DataInputStream typeCode_dis;
        private final DataInputStream strOffset_dis;
        private final DataInputStream strLength_dis;
        private final DataInputStream long_High_dis;
        private final DataInputStream long_Low_dis;
        private final DataInputStream float_Mantissa_Sign_dis;
        private final DataInputStream float_Exponent_dis;
        private final DataInputStream double_Mantissa_Sign_dis;
        private final DataInputStream double_Exponent_dis;
        private final DataInputStream fsIndexes_dis;
        private final DataInputStream strChars_dis;
        private final DataInputStream control_dis;
        private final DataInputStream strSeg_dis;
        private final int[][] prevFsRefsByType = new int[BinaryCasSerDes4.access$300(BinaryCasSerDes4.this).getTypeArraySize()][];
        private int[] prevFsRefs;
        private final TOP[] prevFsByType = new TOP[BinaryCasSerDes4.access$300(BinaryCasSerDes4.this).getTypeArraySize()];
        private TOP prevFs;
        private final Int2ObjHashMap<TOP, TOP> seq2fs = new Int2ObjHashMap(TOP.class);

        Deserializer(CASImpl cas, DataInput deserIn, boolean isDelta) throws IOException {
            int i;
            this.baseCas = cas.getBaseCAS();
            this.ivCas = this.baseCas.getInitialView();
            this.bcsd = cas.getBinaryCasSerDes();
            this.csds = BinaryCasSerDes4.getCsds(this.baseCas, isDelta);
            this.deserIn = deserIn;
            this.isDelta = isDelta;
            int nbrEntries = deserIn.readInt();
            IntVector idxAndLen = new IntVector(nbrEntries * 3);
            for (i = 0; i < nbrEntries; ++i) {
                idxAndLen.add(deserIn.readUnsignedByte());
                idxAndLen.add(deserIn.readInt());
                idxAndLen.add(deserIn.readInt());
            }
            i = 0;
            while (i < idxAndLen.size()) {
                this.setupReadStream(idxAndLen.get(i++), idxAndLen.get(i++), idxAndLen.get(i++));
            }
            this.arrayLength_dis = this.dataInputs[SlotKindsConstants.arrayLength_i];
            this.heapRef_dis = this.dataInputs[SlotKindsConstants.heapRef_i];
            this.int_dis = this.dataInputs[SlotKindsConstants.int_i];
            this.byte_dis = this.dataInputs[SlotKindsConstants.byte_i];
            this.short_dis = this.dataInputs[SlotKindsConstants.short_i];
            this.typeCode_dis = this.dataInputs[SlotKindsConstants.typeCode_i];
            this.strOffset_dis = this.dataInputs[SlotKindsConstants.strOffset_i];
            this.strLength_dis = this.dataInputs[SlotKindsConstants.strLength_i];
            this.long_High_dis = this.dataInputs[SlotKindsConstants.long_High_i];
            this.long_Low_dis = this.dataInputs[SlotKindsConstants.long_Low_i];
            this.float_Mantissa_Sign_dis = this.dataInputs[SlotKindsConstants.float_Mantissa_Sign_i];
            this.float_Exponent_dis = this.dataInputs[SlotKindsConstants.float_Exponent_i];
            this.double_Mantissa_Sign_dis = this.dataInputs[SlotKindsConstants.double_Mantissa_Sign_i];
            this.double_Exponent_dis = this.dataInputs[SlotKindsConstants.double_Exponent_i];
            this.fsIndexes_dis = this.dataInputs[SlotKindsConstants.fsIndexes_i];
            this.strChars_dis = this.dataInputs[SlotKindsConstants.strChars_i];
            this.control_dis = this.dataInputs[SlotKindsConstants.control_i];
            this.strSeg_dis = this.dataInputs[SlotKindsConstants.strSeg_i];
        }

        private void deserialize(CommonSerDes.Header h) throws IOException {
            TypeImpl typeImpl;
            this.seq2fs.clear();
            this.stringHeapObj.reset();
            int lenCmnStrs = this.readVnumber(this.strChars_dis);
            this.readCommonString = new String[lenCmnStrs];
            for (int i = 0; i < lenCmnStrs; ++i) {
                this.readCommonString[i] = DataIO.readUTFv(this.strChars_dis);
            }
            this.only1CommonString = lenCmnStrs == 1;
            int seq = 1;
            for (TOP tOP : this.csds.getSortedFSs()) {
                this.seq2fs.put(seq++, tOP);
            }
            int deltaHeapSize = this.readVnumber(this.control_dis);
            this.heapStart = this.isDelta ? this.csds.getHeapEnd() : 0;
            this.heapEnd = this.heapStart + deltaHeapSize;
            for (int[] ia : this.prevFsRefsByType) {
                if (ia == null) continue;
                Arrays.fill(ia, 0);
            }
            if (this.heapStart == 0) {
                this.heapStart = 1;
            }
            int arraySize = 0;
            Arrays.fill(this.prevFsByType, null);
            for (int iHeap = this.heapStart; iHeap < this.heapEnd; iHeap += typeImpl.getFsSpaceReq(arraySize)) {
                int typeCode = this.readVnumber(this.typeCode_dis);
                typeImpl = BinaryCasSerDes4.this.ts.getTypeForCode(typeCode);
                this.prevFs = this.prevFsByType[typeCode];
                this.prevFsRefs = this.getPrevFsRef(typeImpl);
                if (typeImpl.isArray()) {
                    this.currentFs = this.readArray(iHeap, typeImpl);
                    arraySize = ((CommonArrayFS)((Object)this.currentFs)).size();
                } else {
                    if (!((BinaryCasSerDes4)BinaryCasSerDes4.this).ts.annotBaseType.subsumes(typeImpl) && ((BinaryCasSerDes4)BinaryCasSerDes4.this).ts.sofaType != typeImpl) {
                        this.createCurrentFs(typeImpl, this.ivCas);
                    } else {
                        this.currentFs = null;
                        this.singleFsDefer.clear();
                        this.sofaRef = null;
                        this.sofaNum = -1;
                        this.sofaName = null;
                    }
                    for (FeatureImpl feat : typeImpl.getFeatureImpls()) {
                        this.readByKind(feat, typeImpl);
                    }
                }
                if (this.currentFs == null) {
                    if (((BinaryCasSerDes4)BinaryCasSerDes4.this).ts.sofaType == typeImpl) {
                        this.currentFs = this.baseCas.hasView(this.sofaName) ? (TOP)((Object)this.baseCas.getView(this.sofaName).getSofa()) : this.baseCas.createSofa(this.sofaNum, this.sofaName, null);
                    } else {
                        CASImpl view = null == this.sofaRef ? this.baseCas.getInitialView() : this.baseCas.getView(this.sofaRef);
                        this.createCurrentFs(typeImpl, view);
                    }
                    if (typeImpl.getCode() == 36) {
                        boolean wasRemoved = this.baseCas.checkForInvalidFeatureSetting(this.currentFs, this.baseCas.getAddbackSingle());
                        for (Runnable r : this.singleFsDefer) {
                            r.run();
                        }
                        this.baseCas.addbackSingleIfWasRemoved(wasRemoved, this.currentFs);
                    } else {
                        for (Runnable r : this.singleFsDefer) {
                            r.run();
                        }
                    }
                }
                assert (this.currentFs != null);
                this.csds.addFS(this.currentFs, iHeap);
                int s2 = 1 + this.seq2fs.size();
                this.seq2fs.put(s2, this.currentFs);
                this.prevFsByType[typeCode] = this.currentFs;
            }
            this.csds.setHeapEnd(this.heapEnd);
            for (Runnable r : this.fixupsNeeded) {
                r.run();
            }
            for (Runnable r : this.uimaSerializableFixups) {
                r.run();
            }
            this.readIndexedFeatureStructures();
            if (this.isDelta) {
                new ReadModifiedFSs().readModifiedFSs();
            }
            this.closeDataInputs();
        }

        private void createCurrentFs(TypeImpl type, CASImpl view) {
            this.currentFs = (TOP)view.createFS(type);
            if (this.currentFs instanceof UimaSerializable) {
                UimaSerializable ufs = (UimaSerializable)((Object)this.currentFs);
                this.uimaSerializableFixups.add(() -> ufs._init_from_cas_data());
            }
        }

        private TOP readArray(int iHeap, TypeImpl type) throws IOException {
            int length = this.readArrayLength();
            TOP fs = this.ivCas.createArray(type, length);
            if (length == 0) {
                return fs;
            }
            SlotKinds.SlotKind refKind = type.getComponentSlotKind();
            switch (refKind) {
                case Slot_BooleanRef: {
                    boolean[] ba = ((BooleanArray)fs)._getTheArray();
                    for (int i = 0; i < length; ++i) {
                        ba[i] = this.byte_dis.readByte() == 1;
                    }
                    break;
                }
                case Slot_ByteRef: {
                    this.readIntoByteArray(((ByteArray)fs)._getTheArray());
                    break;
                }
                case Slot_ShortRef: {
                    this.readIntoShortArray(((ShortArray)fs)._getTheArray());
                    break;
                }
                case Slot_Int: {
                    int[] ia = ((IntegerArray)fs)._getTheArray();
                    int prev = this.getPrevIntValue(refKind, null);
                    for (int i = 0; i < length; ++i) {
                        int v;
                        prev = v = this.readDiff(SlotKinds.SlotKind.Slot_Int, prev);
                        if (i == 0) {
                            this.savePrevHeapRef(type.getCode(), 1, 0, v);
                        }
                        ia[i] = v;
                    }
                    break;
                }
                case Slot_LongRef: {
                    this.readIntoLongArray(((LongArray)fs)._getTheArray());
                    break;
                }
                case Slot_Float: {
                    float[] fa = ((FloatArray)fs)._getTheArray();
                    for (int i = 0; i < length; ++i) {
                        int floatRef = this.readFloat();
                        fa[i] = Float.intBitsToFloat(floatRef);
                    }
                    break;
                }
                case Slot_DoubleRef: {
                    this.readIntoDoubleArray(((DoubleArray)fs)._getTheArray());
                    break;
                }
                case Slot_HeapRef: {
                    TOP[] a = ((FSArray)fs)._getTheArray();
                    int prev = this.getPrevIntValue(refKind, null);
                    int i = 0;
                    while (i < a.length) {
                        int v;
                        prev = v = this.readDiff(SlotKinds.SlotKind.Slot_HeapRef, prev);
                        if (i == 0) {
                            this.savePrevHeapRef(type.getCode(), 1, 0, v);
                        }
                        int local_i = i++;
                        this.maybeStoreOrDefer_slotFixups(v, refd_fs -> {
                            a[local_i] = refd_fs;
                        });
                    }
                    break;
                }
                case Slot_StrRef: {
                    String[] sa = ((StringArray)fs)._getTheArray();
                    for (int i = 0; i < length; ++i) {
                        sa[i] = this.readString();
                    }
                    break;
                }
                default: {
                    Misc.internalError();
                }
            }
            return fs;
        }

        private int readArrayLength() throws IOException {
            return this.readVnumber(this.arrayLength_dis);
        }

        private void readByKind(FeatureImpl feat, TypeImpl type) throws IOException {
            SlotKinds.SlotKind kind = feat.getSlotKind();
            switch (kind) {
                case Slot_Int: {
                    int i = this.readDiffWithPrevTypeSlot(kind, feat);
                    if (feat == ((BinaryCasSerDes4)BinaryCasSerDes4.this).ts.sofaNum) {
                        this.sofaNum = i;
                        break;
                    }
                    this.maybeStoreOrDefer(lfs -> lfs._setIntValueNcNj(feat, i));
                    break;
                }
                case Slot_Short: {
                    int i = this.readDiffWithPrevTypeSlot(kind, feat);
                    this.maybeStoreOrDefer(lfs -> lfs._setIntLikeValueNcNj(kind, feat, i));
                    break;
                }
                case Slot_Float: {
                    int i = this.readFloat();
                    this.maybeStoreOrDefer(lfs -> lfs._setFloatValueNcNj(feat, CASImpl.int2float(i)));
                    break;
                }
                case Slot_Boolean: {
                    byte i = this.byte_dis.readByte();
                    this.maybeStoreOrDefer(lfs -> lfs._setBooleanValueNcNj(feat, i == 1));
                    break;
                }
                case Slot_Byte: {
                    byte i = this.byte_dis.readByte();
                    this.maybeStoreOrDefer(lfs -> lfs._setByteValueNcNj(feat, i));
                    break;
                }
                case Slot_HeapRef: {
                    int vh = this.readDiffWithPrevTypeSlot(kind, feat);
                    if (((BinaryCasSerDes4)BinaryCasSerDes4.this).ts.annotBaseSofaFeat == feat) {
                        this.sofaRef = (Sofa)this.seq2fs(vh);
                    }
                    if (((BinaryCasSerDes4)BinaryCasSerDes4.this).ts.annotBaseSofaFeat == feat && this.sofaRef != null) break;
                    this.maybeStoreOrDefer(lfs -> {
                        if (feat == ((BinaryCasSerDes4)BinaryCasSerDes4.this).ts.sofaArray) {
                            this.maybeStoreOrDefer_slotFixups(vh, ref_fs -> ((Sofa)lfs).setLocalSofaData((FeatureStructure)ref_fs));
                        } else {
                            this.maybeStoreOrDefer_slotFixups(vh, ref_fs -> lfs._setFeatureValueNcNj(feat, ref_fs));
                        }
                    });
                    break;
                }
                case Slot_StrRef: {
                    String s = this.readString();
                    if (null == s) break;
                    if (((BinaryCasSerDes4)BinaryCasSerDes4.this).ts.sofaType.subsumes(type)) {
                        if (feat == ((BinaryCasSerDes4)BinaryCasSerDes4.this).ts.sofaId) {
                            this.sofaName = s;
                            break;
                        }
                        if (feat == ((BinaryCasSerDes4)BinaryCasSerDes4.this).ts.sofaMime) {
                            this.maybeStoreOrDefer(lfs -> ((Sofa)lfs).setMimeType(s));
                            break;
                        }
                        if (feat == ((BinaryCasSerDes4)BinaryCasSerDes4.this).ts.sofaUri) {
                            this.maybeStoreOrDefer(lfs -> ((Sofa)lfs).setRemoteSofaURI(s));
                            break;
                        }
                        if (feat == ((BinaryCasSerDes4)BinaryCasSerDes4.this).ts.sofaString) {
                            this.maybeStoreOrDefer(lfs -> ((Sofa)lfs).setLocalSofaDataNoDocAnnotUpdate(s));
                            break;
                        }
                    }
                    this.maybeStoreOrDefer(lfs -> lfs._setStringValueNcNj(feat, s));
                    break;
                }
                case Slot_LongRef: {
                    long prevLong = this.prevFs == null ? 0L : this.prevFs._getLongValueNc(feat);
                    long v = this.readLongOrDouble(kind, prevLong);
                    this.maybeStoreOrDefer(lfs -> lfs._setLongValueNcNj(feat, v));
                    break;
                }
                case Slot_DoubleRef: {
                    long v = this.readDouble();
                    this.maybeStoreOrDefer(lfs -> lfs._setDoubleValueNcNj(feat, CASImpl.long2double(v)));
                    break;
                }
                default: {
                    Misc.internalError();
                }
            }
        }

        private void readIndexedFeatureStructures() throws IOException {
            int i2;
            int nbrViews = this.readVnumber(this.control_dis);
            int nbrSofas = this.readVnumber(this.control_dis);
            IntVector fsIndexes = new IntVector(nbrViews + nbrSofas + 100);
            fsIndexes.add(nbrViews);
            fsIndexes.add(nbrSofas);
            for (i2 = 0; i2 < nbrSofas; ++i2) {
                fsIndexes.add(this.readVnumber(this.control_dis));
            }
            for (i2 = 0; i2 < nbrViews; ++i2) {
                this.readFsxPart(fsIndexes);
                if (!this.isDelta) continue;
                this.readFsxPart(fsIndexes);
                this.readFsxPart(fsIndexes);
            }
            this.bcsd.reinitIndexedFSs(fsIndexes.getArray(), this.isDelta, i -> this.seq2fs.get(i), i -> this.csds.addr2fs.get(i));
        }

        private void maybeStoreOrDefer(Consumer<TOP> storeAction) {
            if (null == this.currentFs) {
                this.singleFsDefer.add(() -> storeAction.accept(this.currentFs));
            } else {
                storeAction.accept(this.currentFs);
            }
        }

        private void maybeStoreOrDefer_slotFixups(int tgtSeq, Consumer<TOP> r) {
            if (tgtSeq == 0) {
                r.accept(null);
                return;
            }
            TOP src = this.seq2fs(tgtSeq);
            if (src == null) {
                this.fixupsNeeded.add(() -> r.accept(this.seq2fs(tgtSeq)));
            } else {
                r.accept(src);
            }
        }

        private void readFsxPart(IntVector fsIndexes) throws IOException {
            int nbrEntries = this.readVnumber(this.fsIndexes_dis);
            fsIndexes.add(nbrEntries);
            int prev = 0;
            for (int i = 0; i < nbrEntries; ++i) {
                int v;
                prev = v = this.readVnumber(this.fsIndexes_dis) + prev;
                fsIndexes.add(v);
            }
        }

        private void setupReadStream(int slotIndex, int bytesCompr, int bytesOrig) throws IOException {
            Inflater inflater;
            byte[] b = new byte[bytesCompr + 1];
            this.deserIn.readFully(b, 0, bytesCompr);
            this.inflaters[slotIndex] = inflater = new Inflater(true);
            ByteArrayInputStream baiStream = new ByteArrayInputStream(b);
            int zipBufSize = Math.max(1024, bytesCompr);
            InflaterInputStream iis = new InflaterInputStream(baiStream, inflater, zipBufSize);
            this.dataInputs[slotIndex] = new DataInputStream(new BufferedInputStream(iis, zipBufSize));
        }

        private void closeDataInputs() {
            for (DataInputStream is : this.dataInputs) {
                if (null == is) continue;
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            for (Inflater inflater : this.inflaters) {
                if (null == inflater) continue;
                inflater.end();
            }
        }

        private DataInput getInputStream(SlotKinds.SlotKind kind) {
            return this.dataInputs[kind.ordinal()];
        }

        private int readVnumber(DataInputStream dis) throws IOException {
            return DataIO.readVnumber(dis);
        }

        private long readVlong(DataInputStream dis) throws IOException {
            return DataIO.readVlong(dis);
        }

        private void readIntoByteArray(byte[] ba) throws IOException {
            this.byte_dis.readFully(ba);
        }

        private void readIntoShortArray(short[] sa) throws IOException {
            int prev = 0;
            for (int i = 0; i < sa.length; ++i) {
                prev = (short)this.readDiff(this.short_dis, prev);
            }
        }

        private void readIntoDoubleArray(double[] da) throws IOException {
            for (int i = 0; i < da.length; ++i) {
                da[i] = CASImpl.long2double(this.readDouble());
            }
        }

        private void readIntoLongArray(long[] la) throws IOException {
            long prev = 0L;
            for (int i = 0; i < la.length; ++i) {
                la[i] = prev = this.readLongOrDouble(SlotKinds.SlotKind.Slot_LongRef, prev);
            }
        }

        private int readDiffWithPrevTypeSlot(SlotKinds.SlotKind kind, FeatureImpl feat) throws IOException {
            int prev = this.getPrevIntValue(kind, feat);
            int v = this.readDiff(kind, prev);
            if (kind == SlotKinds.SlotKind.Slot_HeapRef) {
                TypeImpl type = (TypeImpl)feat.getDomain();
                this.savePrevHeapRef(type.getCode(), type.getNumberOfFeatures(), feat.getOffset(), v);
            }
            return v;
        }

        private int getPrevIntValue(SlotKinds.SlotKind kind, FeatureImpl feat) {
            if (kind == SlotKinds.SlotKind.Slot_HeapRef) {
                return this.prevFsRefs == null ? 0 : this.prevFsRefs[feat == null ? 0 : feat.getOffset()];
            }
            return this.prevFs == null ? 0 : this.prevFs._getIntLikeValue(kind, feat);
        }

        private void savePrevHeapRef(int typecode, int nbrOfSlots, int offset, int v) {
            if (this.prevFsRefs == null) {
                this.prevFsRefs = new int[nbrOfSlots];
                this.prevFsRefsByType[typecode] = this.prevFsRefs;
            }
            this.prevFsRefs[offset] = v;
        }

        private int readDiff(SlotKinds.SlotKind kind, int prev) throws IOException {
            return this.readDiff(this.getInputStream(kind), prev);
        }

        private int readDiff(DataInput in, int prev) throws IOException {
            long encoded = this.readVlong(in);
            boolean isDelta1 = 0L != (encoded & 1L);
            boolean isNegative = 0L != (encoded & 2L);
            int v = (int)(encoded >>> 2);
            if (isNegative) {
                if (v == 0) {
                    return Integer.MIN_VALUE;
                }
                v = -v;
            }
            if (isDelta1) {
                v += prev;
            }
            return v;
        }

        private long readLongOrDouble(SlotKinds.SlotKind kind, long prev) throws IOException {
            if (kind == SlotKinds.SlotKind.Slot_DoubleRef) {
                return this.readDouble();
            }
            int vh = this.readDiff(this.long_High_dis, (int)(prev >>> 32));
            int vl = this.readDiff(this.long_Low_dis, (int)prev);
            long v = (long)vh << 32 | 0xFFFFFFFFL & (long)vl;
            return v;
        }

        private int readFloat() throws IOException {
            int exponent = this.readVnumber(this.float_Exponent_dis);
            if (exponent == 0) {
                return 0;
            }
            int mants = this.readVnumber(this.float_Mantissa_Sign_dis);
            boolean isNegative = (mants & 1) == 1;
            mants >>>= 1;
            mants = Integer.reverse(mants) >>> 9;
            return exponent - 1 << 23 | mants | (isNegative ? Integer.MIN_VALUE : 0);
        }

        private int decodeIntSign(int v) {
            if (1 == (v & 1)) {
                return -(v >>> 1);
            }
            return v >>> 1;
        }

        private long readDouble() throws IOException {
            int exponent = this.readVnumber(this.double_Exponent_dis);
            if (exponent == 0) {
                return 0L;
            }
            long mants = this.readVlong(this.double_Mantissa_Sign_dis);
            long raw = this.decodeDouble(mants, exponent);
            return raw;
        }

        private long decodeDouble(long mants, int exponent) {
            if ((exponent = this.decodeIntSign(exponent)) > 0) {
                --exponent;
            }
            long r = (long)((exponent += 1023) & 0x7FF) << 52;
            boolean isNegative = 1L == (mants & 1L);
            mants = Long.reverse(mants >>> 1) >>> 12;
            r = r | mants | (isNegative ? Long.MIN_VALUE : 0L);
            return r;
        }

        private long readVlong(DataInput dis) throws IOException {
            return DataIO.readVlong(dis);
        }

        private String readString() throws IOException {
            int length = this.decodeIntSign(this.readVnumber(this.strLength_dis));
            if (0 == length) {
                return null;
            }
            if (1 == length) {
                this.stringHeapObj.addString("");
                return "";
            }
            if (length < 0) {
                return this.stringHeapObj.getStringForCode(-length);
            }
            int offset = this.readVnumber(this.strOffset_dis);
            int segmentIndex = this.only1CommonString ? 0 : this.readVnumber(this.strSeg_dis);
            String s = this.readCommonString[segmentIndex].substring(offset, offset + length - 1);
            this.stringHeapObj.addString(s);
            return s;
        }

        private int[] getPrevFsRef(TypeImpl type) {
            if (BinaryCasSerDes4.this.fsArrayType.subsumes(type)) {
                int[] cache = this.prevFsRefsByType[type.getCode()];
                if (null == cache) {
                    cache = new int[]{0};
                    this.prevFsRefsByType[type.getCode()] = cache;
                }
                return cache;
            }
            if (type.isArray()) {
                return null;
            }
            int[] cache = this.prevFsRefsByType[type.getCode()];
            if (null == cache && type.hasRefFeature) {
                cache = new int[type.getNumberOfFeatures()];
                this.prevFsRefsByType[type.getCode()] = cache;
            }
            return cache;
        }

        private TOP seq2fs(int s) {
            return s == 0 ? null : this.seq2fs.get(s);
        }

        private class ReadModifiedFSs {
            private int vPrevModInt = 0;
            private int vPrevModHeapRef = 0;
            private short vPrevModShort = 0;
            private long vPrevModLong = 0L;
            private int iHeap;
            private boolean wasRemoved;
            private FSsTobeAddedback.FSsTobeAddedbackSingle addbackSingle;

            private ReadModifiedFSs() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void readModifiedFSs() throws IOException {
                int modFSsLength = Deserializer.this.readVnumber(Deserializer.this.control_dis);
                int iPrevHeap = 0;
                for (int i = 0; i < modFSsLength; ++i) {
                    boolean isSkippedEntry;
                    this.iHeap = Deserializer.this.readVnumber(Deserializer.this.fsIndexes_dis) + iPrevHeap;
                    boolean bl = isSkippedEntry = this.iHeap == iPrevHeap;
                    if (isSkippedEntry) continue;
                    iPrevHeap = this.iHeap;
                    TOP fs = ((Deserializer)Deserializer.this).csds.addr2fs.get(this.iHeap);
                    assert (fs != null);
                    TypeImpl type = fs._getTypeImpl();
                    int numberOfModsInThisFs = Deserializer.this.readVnumber(Deserializer.this.fsIndexes_dis);
                    if (type.isArray() && !type.isHeapStoredArray()) {
                        this.readModifiedAuxHeap(numberOfModsInThisFs, fs, type);
                        continue;
                    }
                    try {
                        this.readModifiedMainHeap(numberOfModsInThisFs, fs, type);
                        continue;
                    }
                    finally {
                        Deserializer.this.baseCas.addbackSingle(fs);
                    }
                }
            }

            private void readModifiedAuxHeap(int numberOfMods, TOP fs, TypeImpl type) throws IOException {
                int prevOffset = 0;
                SlotKinds.SlotKind kind = type.getComponentSlotKind();
                block7: for (int i2 = 0; i2 < numberOfMods; ++i2) {
                    int offset;
                    prevOffset = offset = Deserializer.this.readVnumber(Deserializer.this.fsIndexes_dis) + prevOffset;
                    switch (kind) {
                        case Slot_BooleanRef: {
                            ((BooleanArray)fs).set(offset, Deserializer.this.byte_dis.readByte() == 1);
                            continue block7;
                        }
                        case Slot_ByteRef: {
                            ((ByteArray)fs).set(offset, Deserializer.this.byte_dis.readByte());
                            continue block7;
                        }
                        case Slot_ShortRef: {
                            short v;
                            this.vPrevModShort = v = (short)Deserializer.this.readDiff(Deserializer.this.int_dis, this.vPrevModShort);
                            ((ShortArray)fs).set(offset, v);
                            continue block7;
                        }
                        case Slot_LongRef: {
                            long v;
                            this.vPrevModLong = v = Deserializer.this.readLongOrDouble(kind, this.vPrevModLong);
                            ((LongArray)fs).set(offset, v);
                            continue block7;
                        }
                        case Slot_DoubleRef: {
                            ((DoubleArray)fs).set(offset, CASImpl.long2double(Deserializer.this.readDouble()));
                            continue block7;
                        }
                        default: {
                            Misc.internalError();
                        }
                    }
                }
            }

            private void readModifiedMainHeap(int numberOfMods, TOP fs, TypeImpl type) throws IOException {
                boolean isArray = type.isArray();
                int iPrevOffsetInFs = 0;
                FeatureImpl[] features = isArray ? null : type.getFeatureImpls();
                this.wasRemoved = false;
                this.addbackSingle = Deserializer.this.baseCas.getAddbackSingle();
                block11: for (int i = 0; i < numberOfMods; ++i) {
                    SlotKinds.SlotKind kind;
                    int offsetInFs;
                    iPrevOffsetInFs = offsetInFs = Deserializer.this.readVnumber(Deserializer.this.fsIndexes_dis) + iPrevOffsetInFs;
                    FeatureImpl feat = features == null ? null : features[offsetInFs - 1];
                    SlotKinds.SlotKind slotKind = kind = isArray ? type.getComponentSlotKind() : feat.getSlotKind();
                    if (!isArray && kind != SlotKinds.SlotKind.Slot_HeapRef && !this.wasRemoved) {
                        this.wasRemoved = Deserializer.this.baseCas.checkForInvalidFeatureSetting(fs, feat.getCode(), this.addbackSingle);
                    }
                    switch (kind) {
                        case Slot_Boolean: {
                            fs.setBooleanValue(feat, Deserializer.this.byte_dis.readByte() == 1);
                            continue block11;
                        }
                        case Slot_Byte: {
                            fs.setByteValue(feat, Deserializer.this.byte_dis.readByte());
                            continue block11;
                        }
                        case Slot_Short: {
                            short v;
                            this.vPrevModShort = v = (short)Deserializer.this.readDiff(Deserializer.this.short_dis, this.vPrevModShort);
                            fs.setShortValue(feat, v);
                            continue block11;
                        }
                        case Slot_Int: {
                            int v;
                            this.vPrevModInt = v = Deserializer.this.readDiff(Deserializer.this.int_dis, this.vPrevModInt);
                            if (isArray) {
                                ((IntegerArray)fs).set(offsetInFs - 2, v);
                                continue block11;
                            }
                            fs.setIntValue(feat, v);
                            continue block11;
                        }
                        case Slot_LongRef: {
                            long v;
                            this.vPrevModLong = v = Deserializer.this.readLongOrDouble(kind, this.vPrevModLong);
                            fs.setLongValue(feat, v);
                            continue block11;
                        }
                        case Slot_Float: {
                            float v = Float.intBitsToFloat(Deserializer.this.readFloat());
                            if (isArray) {
                                ((FloatArray)fs).set(offsetInFs - 2, v);
                                continue block11;
                            }
                            fs.setFloatValue(feat, v);
                            continue block11;
                        }
                        case Slot_DoubleRef: {
                            long v = Deserializer.this.readDouble();
                            fs.setDoubleValue(feat, CASImpl.long2double(v));
                            continue block11;
                        }
                        case Slot_StrRef: {
                            String s = Deserializer.this.readString();
                            if (isArray) {
                                ((StringArray)fs).set(offsetInFs - 2, s);
                                continue block11;
                            }
                            fs.setStringValue(feat, s);
                            continue block11;
                        }
                        case Slot_HeapRef: {
                            int v;
                            this.vPrevModHeapRef = v = Deserializer.this.readDiff(Deserializer.this.heapRef_dis, this.vPrevModHeapRef);
                            TOP ref_fs = Deserializer.this.seq2fs(v);
                            if (isArray) {
                                ((FSArray)fs).set(offsetInFs - 2, ref_fs);
                                continue block11;
                            }
                            fs.setFeatureValue(feat, ref_fs);
                            continue block11;
                        }
                        default: {
                            Misc.internalError();
                        }
                    }
                }
            }
        }
    }

    private class Serializer {
        private final DataOutputStream serializedOut;
        private final CASImpl baseCas;
        private final BinaryCasSerDes bcsd;
        private final MarkerImpl mark;
        private final SerializationMeasures sm;
        private final ByteArrayOutputStream[] baosZipSources = new ByteArrayOutputStream[SlotKindsConstants.NBR_SLOT_KIND_ZIP_STREAMS];
        private final DataOutputStream[] dosZipSources = new DataOutputStream[SlotKindsConstants.NBR_SLOT_KIND_ZIP_STREAMS];
        private int heapStart;
        private int heapEnd;
        private final boolean isDelta;
        private final boolean isTsi;
        private final boolean doMeasurement;
        private final OptimizeStrings os;
        private final CompressLevel compressLevel;
        private final CompressStrat compressStrategy;
        private final TOP[] prevFsByType;
        private TOP prevFs;
        private boolean only1CommonString;
        private final DataOutputStream byte_dos;
        private final DataOutputStream typeCode_dos;
        private final DataOutputStream strOffset_dos;
        private final DataOutputStream strLength_dos;
        private final DataOutputStream float_Mantissa_Sign_dos;
        private final DataOutputStream float_Exponent_dos;
        private final DataOutputStream double_Mantissa_Sign_dos;
        private final DataOutputStream double_Exponent_dos;
        private final DataOutputStream fsIndexes_dos;
        private final DataOutputStream control_dos;
        private final DataOutputStream strSeg_dos;
        private final CommonSerDesSequential csds;
        private final Obj2IntIdentityHashMap<TOP> fs2seq = new Obj2IntIdentityHashMap<TOP>(TOP.class, TOP._singleton);
        private PositiveIntSet uimaSerializableSavedToCas;

        private Serializer(CASImpl cas, DataOutputStream serializedOut, MarkerImpl mark, SerializationMeasures sm, CompressLevel compressLevel, CompressStrat compressStrategy, boolean isTsi) {
            this.baseCas = cas.getBaseCAS();
            this.bcsd = cas.getBinaryCasSerDes();
            this.isDelta = mark != null;
            this.serializedOut = serializedOut;
            this.mark = mark;
            this.sm = sm;
            this.compressLevel = compressLevel;
            this.compressStrategy = compressStrategy;
            this.isTsi = isTsi;
            this.doMeasurement = sm != null;
            this.os = new OptimizeStrings(this.doMeasurement);
            BinaryCasSerDes6.setupOutputStreams(this.baseCas, this.baosZipSources, this.dosZipSources);
            this.byte_dos = this.dosZipSources[SlotKindsConstants.byte_i];
            this.typeCode_dos = this.dosZipSources[SlotKindsConstants.typeCode_i];
            this.strOffset_dos = this.dosZipSources[SlotKindsConstants.strOffset_i];
            this.strLength_dos = this.dosZipSources[SlotKindsConstants.strLength_i];
            this.float_Mantissa_Sign_dos = this.dosZipSources[SlotKindsConstants.float_Mantissa_Sign_i];
            this.float_Exponent_dos = this.dosZipSources[SlotKindsConstants.float_Exponent_i];
            this.double_Mantissa_Sign_dos = this.dosZipSources[SlotKindsConstants.double_Mantissa_Sign_i];
            this.double_Exponent_dos = this.dosZipSources[SlotKindsConstants.double_Exponent_i];
            this.fsIndexes_dos = this.dosZipSources[SlotKindsConstants.fsIndexes_i];
            this.control_dos = this.dosZipSources[SlotKindsConstants.control_i];
            this.strSeg_dos = this.dosZipSources[SlotKindsConstants.strSeg_i];
            this.uimaSerializableSavedToCas = new PositiveIntSet_impl(1024, 1, 1024);
            this.prevFsByType = new TOP[BinaryCasSerDes4.this.ts.getTypeArraySize()];
            this.csds = BinaryCasSerDes4.getCsds(this.baseCas, this.isDelta);
            this.csds.getSortedFSs().stream().map(FeatureStructureImplC::_id).forEach(this.uimaSerializableSavedToCas::add);
            assert (null != this.csds);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void serialize() throws IOException {
            CASImpl.SharedViewData sharedViewData = this.baseCas.svd;
            synchronized (sharedViewData) {
                CommonSerDes.createHeader().v3().seqVer(2).form4().delta(this.isDelta).typeSystemIndexDefIncluded(this.isTsi).write(this.serializedOut);
                if (this.isTsi) {
                    CasIOUtils.writeTypeSystem(this.baseCas, this.serializedOut, true);
                }
                int origHeapEnd = this.csds.getHeapEnd();
                if (this.isDelta) {
                    this.csds.setup(this.mark, origHeapEnd);
                }
                this.fs2seq.clear();
                int seq = 1;
                List<TOP> localSortedFSs = this.csds.getSortedFSs();
                for (TOP tOP : localSortedFSs) {
                    this.fs2seq.put(tOP, seq++);
                    if (!(tOP instanceof UimaSerializable) || this.uimaSerializableSavedToCas.contains(tOP._id)) continue;
                    ((UimaSerializable)((Object)tOP))._save_to_cas_data();
                    this.uimaSerializableSavedToCas.add(tOP._id);
                }
                List<TOP> newSortedFSs = CASImpl.filterAboveMark(this.csds.getSortedFSs(), this.mark);
                for (TOP tOP : newSortedFSs) {
                    this.extractStrings(tOP);
                }
                if (this.isDelta) {
                    CASImpl.FsChange[] fsChangeArray;
                    for (CASImpl.FsChange fsChange : fsChangeArray = this.baseCas.getModifiedFSList()) {
                        if (fsChange.fs instanceof UimaSerializable && !this.uimaSerializableSavedToCas.contains(fsChange.fs._id)) {
                            ((UimaSerializable)((Object)fsChange.fs))._save_to_cas_data();
                            this.uimaSerializableSavedToCas.add(fsChange.fs._id);
                        }
                        this.extractStringsFromModifications(fsChange);
                    }
                }
                this.os.optimize();
                this.writeStringInfo();
                this.heapEnd = this.csds.getHeapEnd();
                this.heapStart = this.isDelta ? origHeapEnd : 0;
                this.writeVnumber(this.control_dos, this.heapEnd - this.heapStart);
                Arrays.fill(this.prevFsByType, null);
                for (TOP tOP : newSortedFSs) {
                    this.writeFs(tOP);
                }
                this.serializeIndexedFeatureStructures(this.csds);
                if (this.isDelta) {
                    new SerializeModifiedFSs(this.csds).serializeModifiedFSs();
                }
                this.collectAndZip();
                if (this.doMeasurement) {
                    this.sm.totalTime = System.currentTimeMillis() - this.sm.totalTime;
                }
            }
        }

        private void writeStringInfo() throws IOException {
            String[] commonStrings = this.os.getCommonStrings();
            this.writeVnumber(SlotKindsConstants.strChars_i, commonStrings.length);
            DataOutputStream out = this.dosZipSources[SlotKindsConstants.strChars_i];
            for (int i = 0; i < commonStrings.length; ++i) {
                int startPos = BinaryCasSerDes4.this.doMeasurements ? out.size() : 0;
                DataIO.writeUTFv(commonStrings[i], out);
                if (!BinaryCasSerDes4.this.doMeasurements) continue;
                float len = out.size() - startPos;
                float excess = len / (float)commonStrings[i].length() - 1.0f;
                int encAs2 = (int)(excess * (float)commonStrings[i].length());
                this.sm.statDetails[SlotKindsConstants.strChars_i].countTotal += commonStrings[i].length();
                this.sm.statDetails[SlotKindsConstants.strChars_i].c[0] = commonStrings[i].length() - encAs2;
                this.sm.statDetails[SlotKindsConstants.strChars_i].c[1] = encAs2;
                this.sm.statDetails[SlotKindsConstants.strChars_i].lengthTotal = (int)((float)this.sm.statDetails[SlotKindsConstants.strChars_i].lengthTotal + len);
            }
            boolean bl = this.only1CommonString = commonStrings.length == 1;
            if (BinaryCasSerDes4.this.doMeasurements) {
                // empty if block
            }
        }

        private void writeFs(TOP fs) throws IOException {
            TypeImpl type = fs._getTypeImpl();
            int typeCode = type.getCode();
            this.writeVnumber(this.typeCode_dos, typeCode);
            this.prevFs = this.prevFsByType[typeCode];
            if (type.isArray()) {
                this.serializeArray(fs);
            } else {
                for (FeatureImpl feat : type.getFeatureImpls()) {
                    this.serializeByKind(fs, feat);
                }
            }
            this.prevFsByType[typeCode] = fs;
        }

        private void serializeIndexedFeatureStructures(CommonSerDesSequential csds) throws IOException {
            int fi;
            int[] fsIndexes;
            int[] nArray = fsIndexes = this.isDelta ? this.bcsd.getDeltaIndexedFSs(this.mark, csds.fs2addr) : this.bcsd.getIndexedFSs(csds.fs2addr);
            if (this.doMeasurement) {
                this.sm.statDetails[SlotKindsConstants.fsIndexes_i].original = fsIndexes.length * 4 + 1;
            }
            int nbrViews = fsIndexes[0];
            int nbrSofas = fsIndexes[1];
            this.writeVnumber(SlotKindsConstants.control_i, nbrViews);
            this.writeVnumber(SlotKindsConstants.control_i, nbrSofas);
            if (this.doMeasurement) {
                this.sm.statDetails[SlotKindsConstants.fsIndexes_i].incr(1);
                this.sm.statDetails[SlotKindsConstants.fsIndexes_i].incr(1);
            }
            int end1 = nbrSofas + 2;
            for (fi = 2; fi < end1; ++fi) {
                this.writeVnumber(SlotKindsConstants.control_i, fsIndexes[fi]);
                if (!this.doMeasurement) continue;
                this.sm.statDetails[SlotKindsConstants.fsIndexes_i].incr(DataIO.lengthVnumber(fsIndexes[fi]));
            }
            for (int vi = 0; vi < nbrViews; ++vi) {
                fi = this.compressFsxPart(fsIndexes, fi, csds);
                if (!this.isDelta) continue;
                fi = this.compressFsxPart(fsIndexes, fi, csds);
                fi = this.compressFsxPart(fsIndexes, fi, csds);
            }
        }

        private int compressFsxPart(int[] fsIndexes, int fsNdxStart, CommonSerDesSequential csds) throws IOException {
            int ix = fsNdxStart;
            int nbrEntries = fsIndexes[ix++];
            int end = ix + nbrEntries;
            this.writeVnumber(this.fsIndexes_dos, nbrEntries);
            if (this.doMeasurement) {
                this.sm.statDetails[SlotKindsConstants.typeCode_i].incr(DataIO.lengthVnumber(nbrEntries));
            }
            int[] ia = new int[nbrEntries];
            int i = ix;
            int t = 0;
            while (i < end) {
                ia[t] = this.fs2seq(csds.addr2fs.get(fsIndexes[i]));
                ++i;
                ++t;
            }
            Arrays.sort(ia);
            int prev = 0;
            for (int i2 = 0; i2 < ia.length; ++i2) {
                int v = ia[i2];
                this.writeVnumber(this.fsIndexes_dos, v - prev);
                if (this.doMeasurement) {
                    this.sm.statDetails[SlotKindsConstants.fsIndexes_i].incr(DataIO.lengthVnumber(v - prev));
                }
                prev = v;
            }
            return end;
        }

        /*
         * WARNING - void declaration
         */
        private void serializeArray(TOP fs) throws IOException {
            int length = this.serializeArrayLength(fs);
            if (length == 0) {
                return;
            }
            TypeImpl type = fs._getTypeImpl();
            SlotKinds.SlotKind arrayElementKind = type.getComponentSlotKind();
            switch (arrayElementKind) {
                case Slot_HeapRef: {
                    int prev = this.getPrevArray0HeapRef();
                    for (TOP tOP : ((FSArray)fs)._getTheArray()) {
                        int v = this.fs2seq(tOP);
                        this.writeDiff(arrayElementKind.ordinal(), v, prev);
                        prev = v;
                    }
                    break;
                }
                case Slot_Int: {
                    int prev = this.getPrevArray0Int();
                    for (int n : ((IntegerArray)fs)._getTheArray()) {
                        this.writeDiff(arrayElementKind.ordinal(), n, prev);
                        prev = n;
                    }
                    break;
                }
                case Slot_ShortRef: {
                    int prev = 0;
                    for (int n : ((ShortArray)fs)._getTheArray()) {
                        this.writeDiff(SlotKindsConstants.short_i, n, prev);
                        prev = n;
                    }
                    break;
                }
                case Slot_Float: {
                    for (float item : ((FloatArray)fs)._getTheArray()) {
                        this.writeFloat(CASImpl.float2int(item));
                    }
                    break;
                }
                case Slot_StrRef: {
                    for (String item : ((StringArray)fs)._getTheArray()) {
                        this.writeString(item);
                    }
                    break;
                }
                case Slot_BooleanRef: {
                    for (boolean item : ((BooleanArray)fs)._getTheArray()) {
                        this.byte_dos.write(item ? 1 : 0);
                    }
                    break;
                }
                case Slot_ByteRef: {
                    this.byte_dos.write(((ByteArray)fs)._getTheArray());
                    break;
                }
                case Slot_LongRef: {
                    void var9_40;
                    long prev = 0L;
                    long[] lArray = ((LongArray)fs)._getTheArray();
                    int item = lArray.length;
                    boolean bl = false;
                    while (var9_40 < item) {
                        long item2 = lArray[var9_40];
                        this.writeLong(item2, prev);
                        prev = item2;
                        ++var9_40;
                    }
                    break;
                }
                case Slot_DoubleRef: {
                    for (double item : ((DoubleArray)fs)._getTheArray()) {
                        this.writeDouble(CASImpl.double2long(item));
                    }
                    break;
                }
                default: {
                    Misc.internalError();
                }
            }
        }

        private int getPrevArray0HeapRef() {
            if (this.isNoPrevArrayValue((CommonArrayFS)((Object)this.prevFs))) {
                return 0;
            }
            return this.fs2seq((TOP)((FSArray)this.prevFs).get(0));
        }

        private int getPrevArray0Int() {
            if (this.isNoPrevArrayValue((CommonArrayFS)((Object)this.prevFs))) {
                return 0;
            }
            return ((IntegerArray)this.prevFs).get(0);
        }

        private boolean isNoPrevArrayValue(CommonArrayFS prevCommonArray) {
            return prevCommonArray == null || prevCommonArray.size() == 0;
        }

        private void serializeByKind(TOP fs, FeatureImpl feat) throws IOException {
            SlotKinds.SlotKind kind = feat.getSlotKind();
            switch (kind) {
                case Slot_Int: {
                    int prev = this.prevFs == null ? 0 : this.prevFs._getIntValueNc(feat);
                    int v = fs._getIntValueNc(feat);
                    this.writeDiff(kind.ordinal(), v, prev);
                    break;
                }
                case Slot_Short: {
                    this.writeDiff(kind.ordinal(), fs._getShortValueNc(feat), this.prevFs == null ? 0 : (int)this.prevFs._getShortValueNc(feat));
                    break;
                }
                case Slot_HeapRef: {
                    TOP ref = fs._getFeatureValueNc(feat);
                    this.writeDiff(kind.ordinal(), this.fs2seq(ref), this.prevFs == null ? 0 : this.fs2seq(this.prevFs._getFeatureValueNc(feat)));
                    break;
                }
                case Slot_Float: {
                    this.writeFloat(CASImpl.float2int(fs._getFloatValueNc(feat)));
                    break;
                }
                case Slot_Boolean: {
                    this.byte_dos.write(fs._getBooleanValueNc(feat) ? 1 : 0);
                    break;
                }
                case Slot_Byte: {
                    this.byte_dos.write(fs._getByteValueNc(feat));
                    break;
                }
                case Slot_StrRef: {
                    this.writeString(fs._getStringValueNc(feat));
                    break;
                }
                case Slot_LongRef: {
                    this.writeLong(fs._getLongValueNc(feat), this.prevFs == null ? 0L : this.prevFs._getLongValueNc(feat));
                    break;
                }
                case Slot_DoubleRef: {
                    this.writeDouble(CASImpl.double2long(fs._getDoubleValueNc(feat)));
                    break;
                }
                default: {
                    Misc.internalError();
                }
            }
        }

        private int serializeArrayLength(TOP fs) throws IOException {
            int length = ((CommonArrayFS)((Object)fs)).size();
            this.writeVnumber(SlotKindsConstants.arrayLength_i, length);
            return length;
        }

        private void collectAndZip() throws IOException {
            int i;
            ByteArrayOutputStream baosZipped = new ByteArrayOutputStream(4096);
            Deflater deflater = new Deflater(this.compressLevel.lvl, true);
            deflater.setStrategy(this.compressStrategy.strat);
            int nbrEntries = 0;
            ArrayList<Integer> idxAndLen = new ArrayList<Integer>();
            for (i = 0; i < this.baosZipSources.length; ++i) {
                ByteArrayOutputStream baos = this.baosZipSources[i];
                if (baos == null) continue;
                ++nbrEntries;
                this.dosZipSources[i].close();
                long startTime = System.currentTimeMillis();
                int zipBufSize = Math.max(1024, baos.size() / 100);
                deflater.reset();
                DeflaterOutputStream cds = new DeflaterOutputStream((OutputStream)baosZipped, deflater, zipBufSize);
                baos.writeTo(cds);
                cds.close();
                idxAndLen.add(i);
                if (this.doMeasurement) {
                    this.sm.statDetails[i].afterZip = deflater.getBytesWritten();
                    idxAndLen.add((int)this.sm.statDetails[i].afterZip);
                    this.sm.statDetails[i].beforeZip = deflater.getBytesRead();
                    idxAndLen.add((int)this.sm.statDetails[i].beforeZip);
                    this.sm.statDetails[i].zipTime = System.currentTimeMillis() - startTime;
                    continue;
                }
                idxAndLen.add((int)deflater.getBytesWritten());
                idxAndLen.add((int)deflater.getBytesRead());
            }
            this.serializedOut.writeInt(nbrEntries);
            i = 0;
            while (i < idxAndLen.size()) {
                this.serializedOut.write((Integer)idxAndLen.get(i++));
                this.serializedOut.writeInt((Integer)idxAndLen.get(i++));
                this.serializedOut.writeInt((Integer)idxAndLen.get(i++));
            }
            baosZipped.writeTo(this.serializedOut);
        }

        private void writeLong(long v, long prev) throws IOException {
            this.writeDiff(SlotKindsConstants.long_High_i, (int)(v >>> 32), (int)(prev >>> 32));
            this.writeDiff(SlotKindsConstants.long_Low_i, (int)v, (int)prev);
        }

        private void writeString(String s) throws IOException {
            if (null == s) {
                this.writeVnumber(this.strLength_dos, 0);
                if (this.doMeasurement) {
                    this.sm.statDetails[SlotKindsConstants.strLength_i].incr(1);
                }
                return;
            }
            int indexOrSeq = this.os.getIndexOrSeqIndex(s);
            if (indexOrSeq < 0) {
                int v = this.encodeIntSign(indexOrSeq);
                this.writeVnumber(this.strLength_dos, v);
                if (this.doMeasurement) {
                    this.sm.statDetails[SlotKindsConstants.strLength_i].incr(DataIO.lengthVnumber(v));
                }
                return;
            }
            if (s.length() == 0) {
                this.writeVnumber(this.strLength_dos, this.encodeIntSign(1));
                if (this.doMeasurement) {
                    this.sm.statDetails[SlotKindsConstants.strLength_i].incr(1);
                }
                return;
            }
            if (s.length() == Integer.MAX_VALUE) {
                throw new RuntimeException("Cannot serialize string of Integer.MAX_VALUE length - too large.");
            }
            int offset = this.os.getOffset(indexOrSeq);
            int length = this.encodeIntSign(s.length() + 1);
            this.writeVnumber(this.strOffset_dos, offset);
            this.writeVnumber(this.strLength_dos, length);
            if (this.doMeasurement) {
                this.sm.statDetails[SlotKindsConstants.strOffset_i].incr(DataIO.lengthVnumber(offset));
                this.sm.statDetails[SlotKindsConstants.strLength_i].incr(DataIO.lengthVnumber(length));
            }
            if (!this.only1CommonString) {
                int csi = this.os.getCommonStringIndex(indexOrSeq);
                this.writeVnumber(this.strSeg_dos, csi);
                if (this.doMeasurement) {
                    this.sm.statDetails[SlotKindsConstants.strSeg_i].incr(DataIO.lengthVnumber(csi));
                }
            }
        }

        private void writeFloat(int raw) throws IOException {
            if (raw == 0) {
                this.writeUnsignedByte(this.float_Exponent_dos, 0);
                if (this.doMeasurement) {
                    this.sm.statDetails[SlotKindsConstants.float_Exponent_i].incr(1);
                }
                return;
            }
            int exponent = (raw >>> 23 & 0xFF) + 1;
            int revMants = Integer.reverse((raw & 0x7FFFFF) << 9);
            int mants = (revMants << 1) + (raw < 0 ? 1 : 0);
            this.writeVnumber(this.float_Exponent_dos, exponent);
            this.writeVnumber(this.float_Mantissa_Sign_dos, mants);
            if (this.doMeasurement) {
                this.sm.statDetails[SlotKindsConstants.float_Exponent_i].incr(DataIO.lengthVnumber(exponent));
                this.sm.statDetails[SlotKindsConstants.float_Mantissa_Sign_i].incr(DataIO.lengthVnumber(mants));
            }
        }

        private void writeVnumber(int kind, int v) throws IOException {
            DataIO.writeVnumber((DataOutput)this.dosZipSources[kind], v);
            if (this.doMeasurement) {
                this.sm.statDetails[kind].incr(DataIO.lengthVnumber(v));
            }
        }

        private void writeVnumber(int kind, long v) throws IOException {
            DataIO.writeVnumber((DataOutput)this.dosZipSources[kind], v);
            if (this.doMeasurement) {
                this.sm.statDetails[kind].incr(DataIO.lengthVnumber(v));
            }
        }

        private void writeVnumber(DataOutputStream s, int v) throws IOException {
            DataIO.writeVnumber((DataOutput)s, v);
        }

        private void writeVnumber(DataOutputStream s, long v) throws IOException {
            DataIO.writeVnumber((DataOutput)s, v);
        }

        private void writeUnsignedByte(DataOutputStream s, int v) throws IOException {
            s.write(v);
        }

        private void writeDouble(long raw) throws IOException {
            if (raw == 0L) {
                this.writeVnumber(this.double_Exponent_dos, 0);
                if (this.doMeasurement) {
                    this.sm.statDetails[SlotKindsConstants.double_Exponent_i].incr(1);
                }
                return;
            }
            int exponent = (int)(raw >>> 52 & 0x7FFL);
            if ((exponent -= 1023) >= 0) {
                ++exponent;
            }
            exponent = this.encodeIntSign(exponent);
            long revMants = Long.reverse((raw & 0xFFFFFFFFFFFFFL) << 12);
            long mants = (revMants << 1) + (long)(raw < 0L ? 1 : 0);
            this.writeVnumber(this.double_Exponent_dos, exponent);
            this.writeVnumber(this.double_Mantissa_Sign_dos, mants);
            if (this.doMeasurement) {
                this.sm.statDetails[SlotKindsConstants.double_Exponent_i].incr(DataIO.lengthVnumber(exponent));
                this.sm.statDetails[SlotKindsConstants.double_Mantissa_Sign_i].incr(DataIO.lengthVnumber(mants));
            }
        }

        private int encodeIntSign(int v) {
            if (v < 0) {
                return -v << 1 | 1;
            }
            return v << 1;
        }

        private void writeDiff(int kind, int v, int prev) throws IOException {
            if (v == 0) {
                this.writeVnumber(kind, 0);
                if (this.doMeasurement) {
                    ++this.sm.statDetails[kind].diffEncoded;
                    ++this.sm.statDetails[kind].valueLeDiff;
                }
                return;
            }
            if (v == Integer.MIN_VALUE) {
                this.writeVnumber(kind, 2);
                if (this.doMeasurement) {
                    ++this.sm.statDetails[kind].diffEncoded;
                    ++this.sm.statDetails[kind].valueLeDiff;
                }
                return;
            }
            int absV = Math.abs(v);
            if (v > 0 && prev > 0 || v < 0 && prev < 0) {
                int absDiff;
                int diff = v - prev;
                int n = absDiff = diff < 0 ? -diff : diff;
                this.writeVnumber(kind, absV <= absDiff ? ((long)absV << 2) + (v < 0 ? 2L : 0L) : ((long)absDiff << 2) + (diff < 0 ? 3L : 1L));
                if (this.doMeasurement) {
                    ++this.sm.statDetails[kind].diffEncoded;
                    this.sm.statDetails[kind].valueLeDiff = this.sm.statDetails[kind].valueLeDiff + (absV <= absDiff ? 1L : 0L);
                }
                return;
            }
            this.writeVnumber(kind, ((long)absV << 2) + (long)(v < 0 ? 2 : 0));
            if (this.doMeasurement) {
                ++this.sm.statDetails[kind].diffEncoded;
                ++this.sm.statDetails[kind].valueLeDiff;
            }
        }

        private void extractStrings(TOP fs) {
            block4: {
                TypeImpl type;
                block3: {
                    if (this.isDelta && !this.mark.isNew(fs)) {
                        return;
                    }
                    type = fs._getTypeImpl();
                    if (!type.isArray()) break block3;
                    if (type.getComponentSlotKind() != SlotKinds.SlotKind.Slot_StrRef) break block4;
                    for (String s : ((StringArray)fs)._getTheArray()) {
                        this.os.add(s);
                    }
                    break block4;
                }
                for (FeatureImpl feat : type.getFeatureImpls()) {
                    if (feat.getSlotKind() != SlotKinds.SlotKind.Slot_StrRef) continue;
                    this.os.add(fs._getStringValueNc(feat));
                }
            }
        }

        private void extractStringsFromModifications(CASImpl.FsChange fsChange) {
            TOP fs = fsChange.fs;
            TypeImpl type = fs._getTypeImpl();
            if (fsChange.arrayUpdates != null) {
                if (type.getComponentSlotKind() == SlotKinds.SlotKind.Slot_StrRef) {
                    String[] sa = ((StringArray)fs)._getTheArray();
                    fsChange.arrayUpdates.forAllInts(index -> this.os.add(sa[index]));
                }
            } else {
                BitSet fm = fsChange.featuresModified;
                int offset = fm.nextSetBit(0);
                while (offset >= 0) {
                    FeatureImpl feat = type.getFeatureImpls()[offset];
                    if (feat.getSlotKind() == SlotKinds.SlotKind.Slot_StrRef) {
                        this.os.add(fs._getStringValueNc(feat));
                    }
                    offset = fm.nextSetBit(offset + 1);
                }
            }
        }

        private int fs2seq(TOP fs) {
            return fs == null ? 0 : this.fs2seq.get(fs);
        }

        public class SerializeModifiedFSs {
            int vPrevModInt = 0;
            int vPrevModHeapRef = 0;
            short vPrevModShort = 0;
            long vPrevModLong = 0L;
            final CommonSerDesSequential csds;

            public SerializeModifiedFSs(CommonSerDesSequential csds) {
                this.csds = csds;
            }

            private void serializeModifiedFSs() throws IOException {
                int iPrevAddr = 0;
                CASImpl.FsChange[] fsChanges = Serializer.this.baseCas.getModifiedFSList();
                Serializer.this.writeVnumber(Serializer.this.control_dos, fsChanges.length);
                for (CASImpl.FsChange fsChange : fsChanges) {
                    TOP fs = fsChange.fs;
                    TypeImpl ti = fs._getTypeImpl();
                    int addr = this.csds.fs2addr.get(fs);
                    if (addr == 0) {
                        Serializer.this.writeVnumber(Serializer.this.fsIndexes_dos, 0);
                        continue;
                    }
                    Serializer.this.writeVnumber(Serializer.this.fsIndexes_dos, addr - iPrevAddr);
                    if (ti.isArray() && !ti.isHeapStoredArray()) {
                        this.writeAuxHeapMods(fsChange);
                    } else {
                        this.writeMainHeapMods(fsChange);
                    }
                    iPrevAddr = addr;
                }
            }

            private void writeMainHeapMods(CASImpl.FsChange fsChange) throws IOException {
                int nbrOfMods = fsChange.arrayUpdates == null ? fsChange.featuresModified.cardinality() : fsChange.arrayUpdates.size();
                Serializer.this.writeVnumber(Serializer.this.fsIndexes_dos, nbrOfMods);
                TOP fs = fsChange.fs;
                if (fsChange.arrayUpdates == null) {
                    FeatureImpl[] features = fs._getTypeImpl().getFeatureImpls();
                    int iPrevOffsetInFs = 0;
                    BitSet bs = fsChange.featuresModified;
                    int i = bs.nextSetBit(0);
                    while (i >= 0) {
                        FeatureImpl feat = features[i];
                        Serializer.this.writeVnumber(Serializer.this.fsIndexes_dos, i + 1 - iPrevOffsetInFs);
                        iPrevOffsetInFs = i + 1;
                        SlotKinds.SlotKind kind = feat.getSlotKind();
                        int kindi = kind.ordinal();
                        switch (kind) {
                            case Slot_Boolean: {
                                Serializer.this.byte_dos.write(fs._getBooleanValueNc(feat) ? 1 : 0);
                                break;
                            }
                            case Slot_Byte: {
                                Serializer.this.byte_dos.write(fs._getByteValueNc(feat));
                                break;
                            }
                            case Slot_Short: {
                                short v = fs._getShortValueNc(feat);
                                Serializer.this.writeDiff(kindi, v, this.vPrevModShort);
                                this.vPrevModShort = v;
                                break;
                            }
                            case Slot_Int: {
                                int v = fs._getIntValueNc(feat);
                                Serializer.this.writeDiff(kindi, v, this.vPrevModInt);
                                this.vPrevModInt = v;
                                break;
                            }
                            case Slot_Float: {
                                Serializer.this.writeFloat(CASImpl.float2int(fs._getFloatValueNc(feat)));
                                break;
                            }
                            case Slot_LongRef: {
                                long v = fs._getLongValueNc(feat);
                                Serializer.this.writeLong(v, this.vPrevModLong);
                                this.vPrevModLong = v;
                                break;
                            }
                            case Slot_DoubleRef: {
                                Serializer.this.writeDouble(CASImpl.double2long(fs._getDoubleValueNc(feat)));
                                break;
                            }
                            case Slot_HeapRef: {
                                int v = Serializer.this.fs2seq(fs._getFeatureValueNc(feat));
                                Serializer.this.writeDiff(kindi, v, this.vPrevModHeapRef);
                                this.vPrevModHeapRef = v;
                                break;
                            }
                            case Slot_StrRef: {
                                Serializer.this.writeString(fs._getStringValueNc(feat));
                                break;
                            }
                            default: {
                                Misc.internalError();
                            }
                        }
                        i = bs.nextSetBit(i + 1);
                    }
                } else {
                    TypeImpl type = fs._getTypeImpl();
                    SlotKinds.SlotKind kind = type.getComponentSlotKind();
                    int kindi = kind.ordinal();
                    IntListIterator it = fsChange.arrayUpdates.iterator();
                    block18: while (it.hasNext()) {
                        int i = it.nextNvc();
                        Serializer.this.writeVnumber(Serializer.this.fsIndexes_dos, i + 2);
                        switch (kind) {
                            case Slot_Int: {
                                int v = ((IntegerArray)fs).get(i);
                                Serializer.this.writeDiff(kindi, v, this.vPrevModInt);
                                this.vPrevModInt = v;
                                continue block18;
                            }
                            case Slot_Float: {
                                Serializer.this.writeFloat(CASImpl.float2int(((FloatArray)fs).get(i)));
                                continue block18;
                            }
                            case Slot_StrRef: {
                                Serializer.this.writeString(((StringArray)fs).get(i));
                                continue block18;
                            }
                            case Slot_HeapRef: {
                                int v = Serializer.this.fs2seq((TOP)((FSArray)fs).get(i));
                                Serializer.this.writeDiff(kindi, v, this.vPrevModHeapRef);
                                this.vPrevModHeapRef = v;
                                continue block18;
                            }
                        }
                        Misc.internalError();
                    }
                }
            }

            private void writeAuxHeapMods(CASImpl.FsChange fsChange) throws IOException {
                TOP fs = fsChange.fs;
                TypeImpl type = fs._getTypeImpl();
                int iPrevOffset = 0;
                SlotKinds.SlotKind kind = type.getComponentSlotKind();
                Serializer.this.writeVnumber(Serializer.this.fsIndexes_dos, fsChange.arrayUpdates.size());
                IntListIterator it = fsChange.arrayUpdates.iterator();
                block7: while (it.hasNext()) {
                    int i = it.nextNvc();
                    Serializer.this.writeVnumber(Serializer.this.fsIndexes_dos, i - iPrevOffset);
                    iPrevOffset = i;
                    switch (kind) {
                        case Slot_BooleanRef: {
                            Serializer.this.byte_dos.write(((BooleanArray)fs).get(i) ? 1 : 0);
                            continue block7;
                        }
                        case Slot_ByteRef: {
                            Serializer.this.byte_dos.write(((ByteArray)fs).get(i));
                            continue block7;
                        }
                        case Slot_ShortRef: {
                            short v = ((ShortArray)fs).get(i);
                            Serializer.this.writeDiff(SlotKindsConstants.int_i, v, this.vPrevModShort);
                            this.vPrevModShort = v;
                            continue block7;
                        }
                        case Slot_LongRef: {
                            long v = ((LongArray)fs).get(i);
                            Serializer.this.writeLong(v, this.vPrevModLong);
                            this.vPrevModLong = v;
                            continue block7;
                        }
                        case Slot_DoubleRef: {
                            double v = ((DoubleArray)fs).get(i);
                            Serializer.this.writeDouble(CASImpl.double2long(v));
                            continue block7;
                        }
                    }
                    Misc.internalError();
                }
            }
        }
    }

    public static enum CompressStrat {
        Default(0),
        Filtered(1),
        HuffmanOnly(2);

        public final int strat;

        private CompressStrat(int strat) {
            this.strat = strat;
        }
    }

    public static enum CompressLevel {
        None(0),
        Fast(1),
        Default(-1),
        Best(9);

        public final int lvl;

        private CompressLevel(int lvl) {
            this.lvl = lvl;
        }
    }

    public static enum Compression {
        None,
        Compress;

    }
}

