/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

public class DataIO {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private static final int SIGNED_INT_VALUE_0x80 = 128;
    private static final int MASK_LOW_7 = 127;
    private static final long MASK_LOW_7_LONG = 127L;
    private static ThreadLocal<CharsetDecoder> DECODER = new ThreadLocal();

    public static String decodeUTF8(ByteBuffer in, int length) {
        CharBuffer cb;
        CharsetDecoder decoder;
        block7: {
            if (in.hasArray()) {
                byte[] backingArray = in.array();
                int offset = in.arrayOffset() + in.position();
                if (offset + length <= backingArray.length) {
                    StringBuilder sb = new StringBuilder(length);
                    sb.setLength(length);
                    for (int i = 0; i < length; ++i) {
                        byte b = backingArray[offset + i];
                        if (b >= 0) {
                            sb.setCharAt(i, (char)b);
                            continue;
                        }
                        break block7;
                    }
                    ((Buffer)in).position(in.position() + length);
                    return sb.toString();
                }
            }
        }
        if (null == (decoder = DECODER.get())) {
            decoder = UTF8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            DECODER.set(decoder);
        }
        ByteBuffer partToDecode = in.slice();
        ((Buffer)partToDecode).limit(length);
        try {
            cb = decoder.decode(partToDecode);
            ((Buffer)in).position(in.position() + length);
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
        return cb.toString();
    }

    public static void writeUTFv(String string, DataOutput out) throws IOException {
        if (null == string) {
            out.write(0);
            return;
        }
        byte[] bb = string.getBytes(StandardCharsets.UTF_8);
        if (bb.length > 0x7FFFFFFE) {
            throw new RuntimeException(String.format("String UTF-8 representation too long, was %,d", bb.length));
        }
        DataIO.writeVnumber(out, bb.length + 1);
        out.write(bb);
    }

    public static String readUTFv(DataInput in) throws IOException {
        int length = DataIO.readVnumber(in) - 1;
        if (-1 == length) {
            return null;
        }
        byte[] bb = new byte[length];
        in.readFully(bb);
        return DataIO.decodeUTF8(ByteBuffer.wrap(bb), length);
    }

    public static long lengthUTFv(String string) throws UnsupportedEncodingException {
        if (null == string) {
            return 1L;
        }
        byte[] bb = string.getBytes(StandardCharsets.UTF_8);
        if (bb.length > 0x7FFFFFFE) {
            throw new RuntimeException(String.format("String UTF-8 representation too long, was %,d", bb.length));
        }
        int r = DataIO.lengthVnumber(bb.length + 1);
        return r + bb.length;
    }

    public static void writeShort(DataOutput out, int v) throws IOException {
        if (v > Short.MAX_VALUE || v < Short.MIN_VALUE) {
            throw new RuntimeException(String.format("Trying to write int %,d as a short but it doesn't fit", v));
        }
        out.writeShort(v);
    }

    public static void writeByte(DataOutput out, int v) throws IOException {
        if (v > 127 || v < -128) {
            throw new RuntimeException(String.format("Trying to write int %,d as a byte but it doesn't fit", v));
        }
        out.write(v);
    }

    public static void writeUnsignedByte(DataOutput out, int v) throws IOException {
        out.write(v);
    }

    public static void writeVPNnumber(DataOutput out, int v) throws IOException {
        if (v == Integer.MIN_VALUE) {
            DataIO.writeVnumber(out, 1);
        } else if (v < 0) {
            DataIO.writeVnumber(out, (long)Math.abs(v) << 1 | 1L);
        } else {
            DataIO.writeVnumber(out, v << 1);
        }
    }

    public static void writeVPNnumber(DataOutput out, long v) throws IOException {
        if (v == Long.MIN_VALUE) {
            DataIO.writeVnumber(out, 1);
        } else if (v < 0L) {
            DataIO.writeVnumber(out, Math.abs(v) << 1 | 1L);
        } else {
            DataIO.writeVnumber(out, v << 1);
        }
    }

    public static int lengthVPNnumber(int v) {
        if (v == Integer.MIN_VALUE) {
            return 1;
        }
        if (v < 0) {
            return DataIO.lengthVnumber((long)Math.abs(v) << 1);
        }
        return DataIO.lengthVnumber(v << 1);
    }

    public static int lengthVPNnumber(long v) {
        if (v == Long.MIN_VALUE) {
            return 1;
        }
        if (v < 0L) {
            return DataIO.lengthVnumber(Math.abs(v) << 1);
        }
        return DataIO.lengthVnumber(v << 1);
    }

    public static void writeVnumber(DataOutput out, int v) throws IOException {
        if (v >= 0 && v < 128) {
            out.write(v);
        } else {
            DataIO.writeVnumber1(out, v);
        }
    }

    private static void writeVnumber1(DataOutput out, int v) throws IOException {
        if (v < 0) {
            throw new RuntimeException("never happen");
        }
        for (int i = 0; i < 5; ++i) {
            int outByte = v & 0x7F;
            if (v < 128) {
                out.write(v);
                return;
            }
            out.write(outByte | 0x80);
            v >>>= 7;
        }
    }

    public static int lengthVnumber(int v) {
        int r = 1;
        for (int i = 0; i < 5; ++i) {
            if (v < 128) {
                return r;
            }
            v >>>= 7;
            ++r;
        }
        throw new RuntimeException("Never get here");
    }

    public static int readVnumber(DataInput in) throws IOException {
        int raw = in.readUnsignedByte();
        if (raw < 128) {
            return raw;
        }
        int result = raw & 0x7F;
        int shift = 7;
        for (int i = 1; i < 5; ++i) {
            raw = in.readUnsignedByte();
            result |= (raw & 0x7F) << shift;
            if (raw < 128) {
                return result;
            }
            shift += 7;
        }
        throw new IllegalStateException("Invalid input deserializing Vnumber");
    }

    public static void writeVnumber(DataOutput out, long v) throws IOException {
        if (v >= 0L && v < 128L) {
            out.write((int)v);
        } else {
            DataIO.writeVnumber1(out, v);
        }
    }

    private static void writeVnumber1(DataOutput out, long v) throws IOException {
        if (v < 0L) {
            throw new RuntimeException("never happen");
        }
        for (int i = 0; i < 9; ++i) {
            if (v < 128L) {
                out.write((int)v);
                return;
            }
            int outByte = (int)(v & 0x7FL);
            out.write(outByte | 0x80);
            v >>>= 7;
        }
    }

    public static int lengthVnumber(long v) {
        int r = 1;
        for (int i = 0; i < 9; ++i) {
            if (v < 128L) {
                return r;
            }
            v >>>= 7;
            ++r;
        }
        throw new RuntimeException("Never get here");
    }

    public static long readVlong(DataInput in) throws IOException {
        long raw = in.readUnsignedByte();
        if (raw < 128L) {
            return raw;
        }
        long result = raw & 0x7FL;
        int shift = 7;
        for (int i = 1; i < 9; ++i) {
            raw = in.readUnsignedByte();
            result |= (raw & 0x7FL) << shift;
            if (raw < 128L) {
                return result;
            }
            shift += 7;
        }
        throw new IllegalStateException("Invalid input deserializing Vlong");
    }

    public static long readRestOfVlong(DataInput in, int firstByte) throws IOException {
        if (firstByte < 128) {
            return firstByte;
        }
        long result = firstByte ^ 0x80;
        int shift = 7;
        for (int i = 1; i < 9; ++i) {
            long raw = in.readUnsignedByte();
            result |= (raw & 0x7FL) << shift;
            if (raw < 128L) {
                return result;
            }
            shift += 7;
        }
        throw new IllegalStateException("Invalid input deserializing Vlong");
    }

    public static void writeByteArray(DataOutput out, byte[] v) throws IOException {
        DataIO.writeVnumber(out, v.length);
        out.write(v);
    }

    public static byte[] readByteArray(DataInput in) throws IOException {
        int size = DataIO.readVnumber(in);
        byte[] result = new byte[size];
        in.readFully(result);
        return result;
    }

    public static void writeIntArray(DataOutput out, int[] v) throws IOException {
        DataIO.writeVnumber(out, v.length);
        for (int vi : v) {
            out.writeInt(vi);
        }
    }

    public static int[] readIntArray(DataInput in) throws IOException {
        int size = DataIO.readVnumber(in);
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = in.readInt();
        }
        return result;
    }

    public static void writeIntArrayDelta(DataOutput out, int[] v) throws IOException {
        DataIO.writeVnumber(out, v.length);
        int prev = 0;
        for (int vi : v) {
            DataIO.writeVnumber(out, vi - prev);
            prev = vi;
        }
    }

    public static int[] readIntArrayDelta(DataInput in) throws IOException {
        int size = DataIO.readVnumber(in);
        int prev = 0;
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = prev + DataIO.readVnumber(in);
            prev = result[i];
        }
        return result;
    }

    public static void writeLongArray(DataOutput out, long[] v) throws IOException {
        DataIO.writeVnumber(out, v.length);
        for (long vi : v) {
            out.writeLong(vi);
        }
    }

    public static long[] readLongArray(DataInput in) throws IOException {
        int size = DataIO.readVnumber(in);
        long[] v = new long[size];
        for (int i = 0; i < size; ++i) {
            v[i] = in.readLong();
        }
        return v;
    }

    public static void writeLongArrayDelta(DataOutput out, long[] v) throws IOException {
        DataIO.writeVnumber(out, v.length);
        long prev = 0L;
        for (long vi : v) {
            DataIO.writeVnumber(out, vi - prev);
            prev = vi;
        }
    }

    public static long[] readLongArrayDelta(DataInput in) throws IOException {
        int size = DataIO.readVnumber(in);
        long[] v = new long[size];
        long prev = 0L;
        for (int i = 0; i < size; ++i) {
            v[i] = prev + DataIO.readVlong(in);
            prev = v[i];
        }
        return v;
    }

    public static int readUnsignedByte(DataInput in) throws IOException {
        int r = in.readUnsignedByte();
        if (r < 0) {
            throw new IOException("Premature EOF");
        }
        return r;
    }
}

