/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.CopyOnWriteIndexPart;
import org.apache.uima.cas.impl.FsIndex_bag;
import org.apache.uima.cas.impl.FsIterator_singletype;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.internal.util.CopyOnWriteObjHashSet;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.jcas.cas.TOP;

class FsIterator_bag<T extends FeatureStructure>
extends FsIterator_singletype<T> {
    private static final AtomicInteger moveToCount = new AtomicInteger(0);
    protected CopyOnWriteObjHashSet<T> bag;
    protected final FsIndex_bag<T> fsBagIndex;
    private int position = -1;
    private boolean isGoingForward = true;

    FsIterator_bag(FsIndex_bag<T> fsBagIndex, TypeImpl ti, CopyOnWriteIndexPart<T> cow_wrapper) {
        super(ti);
        this.fsBagIndex = fsBagIndex;
        this.bag = (CopyOnWriteObjHashSet)cow_wrapper;
        this.moveToFirst();
    }

    @Override
    public boolean maybeReinitIterator() {
        if (!this.bag.isOriginal()) {
            this.bag = (CopyOnWriteObjHashSet)this.fsBagIndex.getNonNullCow();
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.position >= 0 && this.position < this.bag.getCapacity();
    }

    @Override
    public T getNvc() {
        return this.bag.get(this.position);
    }

    @Override
    public void moveToFirstNoReinit() {
        this.isGoingForward = true;
        this.position = this.bag.size() == 0 ? -1 : this.bag.moveToNextFilled(0);
    }

    @Override
    public void moveToLastNoReinit() {
        this.isGoingForward = false;
        this.position = this.bag.size() == 0 ? -1 : this.bag.moveToPreviousFilled(this.bag.getCapacity() - 1);
    }

    @Override
    public void moveToNextNvc() {
        this.isGoingForward = true;
        this.position = this.bag.moveToNextFilled(++this.position);
    }

    @Override
    public void moveToPreviousNvc() {
        this.isGoingForward = false;
        this.position = this.bag.moveToPreviousFilled(--this.position);
    }

    @Override
    public void moveToNoReinit(FeatureStructure fs) {
        Misc.decreasingWithTrace(moveToCount, "MoveTo operations on iterators over Bag indexes are likely mistakes.", UIMAFramework.getLogger());
        this.position = this.bag.moveTo(fs);
        if (this.position >= 0 && this.getNvc() == null) {
            this.position = -1;
        }
    }

    @Override
    public FsIterator_bag<T> copy() {
        FsIterator_bag<T> copy = new FsIterator_bag<T>(this.fsBagIndex, this.ti, this.bag);
        this.copyCommonSetup(copy);
        return copy;
    }

    protected void copyCommonSetup(FsIterator_bag<T> copy) {
        copy.position = this.position;
        copy.isGoingForward = this.isGoingForward;
    }

    @Override
    public int ll_indexSizeMaybeNotCurrent() {
        return this.bag.size();
    }

    @Override
    public int ll_maxAnnotSpan() {
        return Integer.MAX_VALUE;
    }

    @Override
    public LowLevelIndex<T> ll_getIndex() {
        return this.fsBagIndex;
    }

    @Override
    public boolean isIndexesHaveBeenUpdated() {
        return this.bag != this.fsBagIndex.getCopyOnWriteIndexPart();
    }

    @Override
    public Comparator<TOP> getComparator() {
        return null;
    }

    @Override
    public int size() {
        return this.bag.size();
    }
}

