/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Predicate;
import org.apache.uima.cas.FSComparators;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.admin.LinearTypeOrder;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationPredicates;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.impl.JCasImpl;
import org.apache.uima.jcas.tcas.Annotation;

public class Subiterator<T extends AnnotationFS>
implements LowLevelIterator<T> {
    private ArrayList<Annotation> list = null;
    private int pos = 0;
    private final LowLevelIterator<Annotation> it;
    private final Annotation boundingAnnot;
    private final int boundBegin;
    private final int boundEnd;
    private final Annotation originalBoundingAnnotation;
    private final int originalBoundBegin;
    private final int originalBoundEnd;
    private final TypeImpl boundType;
    private final Annotation coveringStartPos;
    private final boolean isUnambiguous;
    private final boolean isStrict;
    private final boolean isBounded;
    private final boolean isUseTypePriority;
    private final boolean isSkipSameBeginEndType;
    private final boolean isDoEqualsTest;
    private final BoundsUse boundsUse;
    private final boolean isIncludesAnnotationsStartingAtEndPosition;
    private final boolean isIncludeZeroWidthAtBegin;
    private final boolean isIncludeZeroWidthAtEnd;
    private boolean isEmpty;
    private int prevBegin = -1;
    private int prevEnd = -1;
    private boolean isListForm = false;
    private int startId;
    private final LinearTypeOrder lto;
    private final Comparator<TOP> comparatorMaybeNoTypeWithoutId;
    private final Comparator<TOP> annotationComparator_withId;
    private final JCasImpl jcas;

    Subiterator(FSIterator<T> it, AnnotationFS boundingAnnot, AnnotationFS originalBoundingAnnotation, boolean ambiguous, boolean strict, BoundsUse boundsUse, boolean isUseTypePriority, boolean isSkipSameBeginEndType, boolean isNonStrictIncludesAnnotationsStartingAtEndPosition, boolean isIncludeZeroWidthAtBegin, boolean isIncludeZeroWidthAtEnd) {
        this.it = (LowLevelIterator)it;
        this.boundingAnnot = (Annotation)boundingAnnot;
        this.originalBoundingAnnotation = (Annotation)(originalBoundingAnnotation != null ? originalBoundingAnnotation : boundingAnnot);
        this.isBounded = boundsUse != null && boundsUse != BoundsUse.notBounded;
        BoundsUse boundsUse2 = this.boundsUse = boundsUse == null ? BoundsUse.notBounded : boundsUse;
        if (this.isBounded && (null == boundingAnnot || !(boundingAnnot instanceof Annotation))) {
            Misc.internalError(new IllegalArgumentException("Bounded Subiterators require a bounding annotation"));
        }
        this.boundBegin = this.isBounded ? this.boundingAnnot.getBegin() : -1;
        this.boundEnd = this.isBounded ? this.boundingAnnot.getEnd() : -1;
        this.boundType = this.isBounded ? (TypeImpl)this.originalBoundingAnnotation.getType() : null;
        this.originalBoundBegin = this.isBounded ? this.originalBoundingAnnotation.getBegin() : -1;
        this.originalBoundEnd = this.isBounded ? this.originalBoundingAnnotation.getEnd() : -1;
        this.isIncludesAnnotationsStartingAtEndPosition = isNonStrictIncludesAnnotationsStartingAtEndPosition;
        this.isIncludeZeroWidthAtBegin = isIncludeZeroWidthAtBegin;
        this.isIncludeZeroWidthAtEnd = isIncludeZeroWidthAtEnd;
        boolean bl = this.isUnambiguous = !ambiguous;
        if (this.isUnambiguous) {
            switch (this.boundsUse) {
                case notBounded: 
                case coveredBy: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unambiguous (NonOverlapping) specification only allowed for notBounded or coveredBy subiterator specifications");
                }
            }
        }
        if (strict && BoundsUse.coveredBy != boundsUse && BoundsUse.sameBeginEnd != boundsUse) {
            throw new IllegalArgumentException("Strict (includeAnnotationsWithEndBeyondBounds = false) is only allowed for coveredBy subiterator specification");
        }
        this.isStrict = strict;
        this.isSkipSameBeginEndType = isSkipSameBeginEndType;
        FSIndexRepositoryImpl ir = this.it.ll_getIndex().getCasImpl().indexRepository;
        if (boundsUse == BoundsUse.covering && isUseTypePriority) {
            throw new IllegalArgumentException("Cannot specify isUseTypePriority with BoundsUse.covering");
        }
        this.isUseTypePriority = isUseTypePriority;
        this.lto = isUseTypePriority ? ir.getDefaultTypeOrder() : null;
        this.comparatorMaybeNoTypeWithoutId = ir.getAnnotationFsComparator(FSComparators.WITHOUT_ID, isUseTypePriority ? FSComparators.WITH_TYPE_ORDER : FSComparators.WITHOUT_TYPE_ORDER);
        this.annotationComparator_withId = ir.getAnnotationFsComparatorWithId();
        this.jcas = (JCasImpl)this.ll_getIndex().getCasImpl().getJCas();
        boolean bl2 = this.isDoEqualsTest = (boundsUse == BoundsUse.coveredBy || boundsUse == BoundsUse.sameBeginEnd || boundsUse == BoundsUse.covering) && this.originalBoundingAnnotation._inSetSortedIndex();
        if (boundsUse == BoundsUse.covering) {
            int span = ((LowLevelIterator)it).ll_maxAnnotSpan();
            int begin = this.boundEnd - span;
            if (begin > this.boundBegin) {
                this.makeInvalid();
                this.coveringStartPos = null;
                this.isEmpty = true;
                this.startId = 0;
                return;
            }
            if (begin < 0) {
                begin = 0;
            }
            this.coveringStartPos = Annotation._createMarkerAnnotation(this.jcas, begin, Integer.MAX_VALUE);
        } else {
            this.coveringStartPos = null;
        }
        this.moveToStartSetEmptyAndId();
    }

    private void moveToStartSetEmptyAndId() {
        this.moveToStart();
        this.isEmpty = !this.isValid();
        this.startId = this.isValid() ? this.getNvc()._id() : 0;
    }

    Subiterator(FSIterator<Annotation> it, Annotation boundingAnnot, Annotation originalBoundingAnnotation, boolean ambiguous, boolean strict, BoundsUse boundsUse, boolean isUseTypePriority, boolean isSkipSameBeginEndType, int startId, boolean isEmpty, Annotation coveringStartPos, boolean isDoEqualsTest, boolean isStrictIncludesAnnotationsStartingAtEndPosition, boolean isIncludeZeroWidthAtBegin, boolean isIncludeZeroWidthAtEnd) {
        this.it = (LowLevelIterator)it;
        this.isIncludesAnnotationsStartingAtEndPosition = isStrictIncludesAnnotationsStartingAtEndPosition;
        this.isIncludeZeroWidthAtBegin = isIncludeZeroWidthAtBegin;
        this.isIncludeZeroWidthAtEnd = isIncludeZeroWidthAtEnd;
        this.boundingAnnot = boundingAnnot;
        this.originalBoundingAnnotation = originalBoundingAnnotation;
        this.isBounded = boundsUse != null && boundsUse != BoundsUse.notBounded;
        this.boundsUse = boundsUse == null ? BoundsUse.notBounded : boundsUse;
        boolean bl = this.isUnambiguous = !ambiguous;
        if (strict && BoundsUse.coveredBy != boundsUse && BoundsUse.sameBeginEnd != boundsUse) {
            throw new IllegalArgumentException("Strict requires BoundsUse.coveredBy or BoundsUse.sameBeginEnd");
        }
        this.isStrict = strict;
        this.isSkipSameBeginEndType = isSkipSameBeginEndType;
        this.boundBegin = this.isBounded ? boundingAnnot.getBegin() : -1;
        this.boundEnd = this.isBounded ? boundingAnnot.getEnd() : -1;
        this.boundType = this.isBounded ? (TypeImpl)originalBoundingAnnotation.getType() : null;
        this.originalBoundBegin = this.isBounded ? this.originalBoundingAnnotation.getBegin() : -1;
        this.originalBoundEnd = this.isBounded ? this.originalBoundingAnnotation.getEnd() : -1;
        FSIndexRepositoryImpl ir = this.it.ll_getIndex().getCasImpl().indexRepository;
        this.isUseTypePriority = isUseTypePriority;
        this.lto = isUseTypePriority ? ir.getDefaultTypeOrder() : null;
        this.comparatorMaybeNoTypeWithoutId = ir.getAnnotationFsComparator(FSComparators.WITHOUT_ID, isUseTypePriority ? FSComparators.WITH_TYPE_ORDER : FSComparators.WITHOUT_TYPE_ORDER);
        this.annotationComparator_withId = ir.getAnnotationFsComparatorWithId();
        this.jcas = (JCasImpl)this.ll_getIndex().getCasImpl().getJCas();
        this.coveringStartPos = coveringStartPos;
        this.startId = startId;
        this.isEmpty = isEmpty;
        if (isEmpty) {
            this.makeInvalid();
        }
        this.isDoEqualsTest = isDoEqualsTest;
    }

    private void convertToListForm() {
        this.moveToStart();
        this.list = new ArrayList();
        while (this.isValid()) {
            this.list.add((Annotation)this.it.getNvc());
            this.moveToNextNvc();
        }
        this.pos = 0;
        this.isListForm = true;
    }

    private void moveToStart() {
        assert (!this.isListForm) : "Must not be in list form at this point!";
        this.prevBegin = -1;
        this.prevEnd = -1;
        switch (this.boundsUse) {
            case notBounded: {
                this.it.moveToFirstNoReinit();
                this.maybeSetPrevBounds();
                break;
            }
            case sameBeginEnd: {
                this.moveTo_iterators(this.boundingAnnot, true);
                break;
            }
            case coveredBy: {
                this.moveTo_iterators(this.boundingAnnot, true);
                break;
            }
            case covering: {
                this.moveTo_iterators(this.coveringStartPos, true);
            }
        }
    }

    @Override
    public boolean isValid() {
        if (this.isListForm) {
            return this.pos >= 0 && this.pos < this.list.size();
        }
        return this.it.isValid();
    }

    @Override
    public T getNvc() {
        if (this.isListForm) {
            return (T)this.list.get(this.pos);
        }
        return (T)((AnnotationFS)this.it.getNvc());
    }

    @Override
    public void moveToNextNvc() {
        if (this.isListForm) {
            ++this.pos;
            return;
        }
        this.it.moveToNextNvc();
        if (this.isUnambiguous) {
            while (this.it.isValid() && AnnotationPredicates.overlapping((AnnotationFS)this.it.getNvc(), this.prevBegin, this.prevEnd)) {
                this.it.moveToNext();
            }
        }
        switch (this.boundsUse) {
            case coveredBy: {
                if (this.it.isValid() && this.adjustForStrictNvc_forward()) {
                    boolean moved = false;
                    while (this.equalToBounds((Annotation)this.it.getNvc())) {
                        this.it.moveToNextNvc();
                        moved = true;
                        if (this.it.isValid()) continue;
                    }
                    if (moved && this.it.isValid()) {
                        this.adjustForStrictNvc_forward();
                    }
                    if (this.it.isValid()) {
                        this.is_beyond_bounds_chk_coveredByNvc();
                    }
                    this.maybeSetPrevBounds();
                    return;
                }
                return;
            }
            case covering: {
                this.adjustForCovering_forward();
                if (this.it.isValid() && this.equalToBounds((Annotation)this.it.getNvc())) {
                    this.makeInvalid();
                } else {
                    this.is_beyond_bounds_chk_covering();
                }
                this.maybeSetPrevBounds();
                return;
            }
            case sameBeginEnd: {
                if (this.it.isValid()) {
                    while (this.equalToBounds((Annotation)this.it.getNvc())) {
                        this.it.moveToNextNvc();
                        if (this.it.isValid()) continue;
                    }
                }
                this.is_beyond_bounds_chk_sameBeginEnd();
                this.maybeSetPrevBounds();
                return;
            }
        }
        this.maybeSetPrevBounds();
    }

    @Override
    public void moveToPreviousNvc() {
        if (this.isListForm) {
            --this.pos;
            return;
        }
        if (this.isUnambiguous) {
            Annotation currentAnnotation = (Annotation)this.it.getNvc();
            this.convertToListForm();
            this.pos = Collections.binarySearch(this.list, currentAnnotation, this.annotationComparator_withId);
            --this.pos;
            return;
        }
        this.maybeMoveToPrevBounded();
        this.adjustForStrictOrCoveringAndBoundSkip(true);
    }

    @Override
    public void moveToFirstNoReinit() {
        if (this.isEmpty) {
            return;
        }
        if (this.isListForm) {
            this.pos = 0;
        } else {
            this.moveToStart();
        }
    }

    private void resetList() {
        if (this.isListForm) {
            this.isListForm = false;
            if (this.list != null) {
                this.list.clear();
            }
        }
    }

    @Override
    public void moveToLastNoReinit() {
        if (this.isEmpty) {
            return;
        }
        if (this.isUnambiguous && !this.isListForm) {
            this.convertToListForm();
        }
        if (this.isListForm) {
            this.pos = this.list.size() - 1;
        } else {
            switch (this.boundsUse) {
                case coveredBy: {
                    this.moveToJustPastBoundsAndBackup(this.boundEnd + 1, Integer.MAX_VALUE, a -> a.getBegin() > this.boundEnd || !this.isIncludesAnnotationsStartingAtEndPosition && a.getBegin() < a.getEnd() && a.getBegin() == this.boundEnd || a.getBegin() == this.boundEnd && a.getEnd() == this.boundEnd && this.lto != null && this.lto.lessThan(this.boundType, a._getTypeImpl()));
                    if (this.isStrict) {
                        while (this.it.isValid() && ((Annotation)this.it.getNvc()).getEnd() > this.boundEnd) {
                            this.maybeMoveToPrevBounded();
                        }
                    }
                    while (this.it.isValid() && this.equalToBounds((Annotation)this.it.getNvc())) {
                        this.maybeMoveToPrevBounded();
                    }
                    break;
                }
                case covering: {
                    this.moveToJustPastBoundsAndBackup(this.boundBegin + 1, Integer.MAX_VALUE, a -> a.getBegin() > this.boundBegin || a.getBegin() == this.boundBegin && a.getEnd() < this.boundEnd || a.getBegin() == this.boundBegin && a.getEnd() == this.boundEnd && this.lto != null && this.lto.lessThan(this.boundType, a._getTypeImpl()));
                    while (this.it.isValid() && this.equalToBounds((Annotation)this.it.getNvc())) {
                        this.maybeMoveToPrevBounded();
                    }
                    while (this.it.isValid() && ((Annotation)this.it.getNvc()).getEnd() < this.boundEnd) {
                        this.maybeMoveToPrevBounded();
                    }
                    break;
                }
                case sameBeginEnd: {
                    this.moveToJustPastBoundsAndBackup(this.boundBegin + 1, Integer.MAX_VALUE, a -> a.getBegin() > this.boundBegin || a.getBegin() == this.boundBegin && (a.getEnd() < this.boundEnd || a.getEnd() == this.boundEnd && this.lto != null && this.lto.lessThan(this.boundType, a._getTypeImpl())));
                    while (this.it.isValid() && this.equalToBounds((Annotation)this.it.getNvc())) {
                        this.maybeMoveToPrevBounded();
                    }
                    break;
                }
                default: {
                    Misc.internalError();
                }
            }
        }
    }

    private void moveToJustPastBoundsAndBackup(int begin, int end, Predicate<Annotation> continue_going_backwards) {
        this.it.moveToNoReinit(Annotation._createMarkerAnnotation(this.jcas, begin, end));
        if (!this.it.isValid()) {
            this.it.moveToLastNoReinit();
        }
        Annotation a = (Annotation)this.it.getNvc();
        while (continue_going_backwards.test(a)) {
            if (a._id == this.startId) {
                Misc.internalError();
            }
            this.it.moveToPreviousNvc();
            if (!this.it.isValid()) {
                Misc.internalError();
            }
            a = (Annotation)this.it.getNvc();
        }
    }

    static Comparator<AnnotationFS> getAnnotationBeginEndComparator(final int boundingBegin, final int boundingEnd) {
        return new Comparator<AnnotationFS>(){

            @Override
            public int compare(AnnotationFS o1, AnnotationFS o2) {
                AnnotationFS a = o1 == null ? o2 : o1;
                boolean isReverse = o1 == null;
                int b = a.getBegin();
                if (b < boundingBegin) {
                    return isReverse ? 1 : -1;
                }
                if (b > boundingBegin) {
                    return isReverse ? -1 : 1;
                }
                int e = a.getEnd();
                if (e < boundingEnd) {
                    return isReverse ? -1 : 1;
                }
                if (e > boundingEnd) {
                    return isReverse ? 1 : -1;
                }
                return 0;
            }
        };
    }

    @Override
    public void moveToNoReinit(FeatureStructure fs) {
        if (this.isEmpty) {
            return;
        }
        if (this.isUnambiguous && !this.isListForm) {
            this.convertToListForm();
        }
        if (this.isListForm) {
            this.moveTo_listForm(fs);
            return;
        }
        this.moveTo_iterators(fs, false);
    }

    private void moveTo_listForm(FeatureStructure fs) {
        Annotation fsa = (Annotation)fs;
        this.pos = Collections.binarySearch(this.list, fsa, this.comparatorMaybeNoTypeWithoutId);
        if (this.pos >= 0) {
            this.moveToPrevious();
        } else {
            this.pos = -this.pos - 1;
            if (!this.isValid()) {
                return;
            }
        }
        while (this.isValid() && 0 == this.comparatorMaybeNoTypeWithoutId.compare((Annotation)this.getNvc(), fsa)) {
            this.moveToPreviousNvc();
        }
        if (this.isValid()) {
            this.moveToNextNvc();
        } else {
            this.moveToFirstNoReinit();
        }
    }

    private void moveTo_iterators(FeatureStructure fs, boolean initialPositioning) {
        this.it.moveToNoReinit(fs);
        if (this.it.isValid()) {
            if (!initialPositioning) {
                switch (this.boundsUse) {
                    case covering: {
                        if (!this.is_beyond_bounds_chk_coveringNvc()) break;
                        return;
                    }
                    case coveredBy: {
                        if (!this.is_beyond_bounds_chk_coveredByNvc()) break;
                        return;
                    }
                    case sameBeginEnd: {
                        if (!this.is_beyond_bounds_chk_sameBeginEnd()) break;
                        return;
                    }
                }
            }
            if (this.equalToBounds((Annotation)this.it.getNvc())) {
                this.it.moveToNext();
                if (!this.it.isValid()) {
                    this.it.moveToLastNoReinit();
                }
            }
        }
        switch (this.boundsUse) {
            case sameBeginEnd: {
                this.maybeAdjustForAmbiguityAndIgnoringTypePriorities_forward(!initialPositioning);
                if (this.it.isValid()) {
                    if (this.is_beyond_bounds_chk_sameBeginEnd()) {
                        this.isEmpty = true;
                        return;
                    }
                    while (this.equalToBounds((Annotation)this.it.getNvc())) {
                        this.it.moveToNextNvc();
                        if (!this.is_beyond_bounds_chk_sameBeginEnd()) continue;
                        return;
                    }
                }
                return;
            }
            case coveredBy: {
                this.maybeAdjustForAmbiguityAndIgnoringTypePriorities_forward(!initialPositioning);
                if (!this.it.isValid()) break;
                while (this.equalToBounds((Annotation)this.it.getNvc())) {
                    this.it.moveToNextNvc();
                    if (this.it.isValid()) continue;
                    return;
                }
                if (!this.adjustForStrictNvc_forward() || !this.is_beyond_bounds_chk_coveredByNvc()) break;
                return;
            }
            case covering: {
                if (this.it.isValid()) {
                    this.adjustForCovering_forward();
                }
                this.is_beyond_bounds_chk_covering();
                return;
            }
            default: {
                if (this.it.isValid()) break;
                return;
            }
        }
        this.maybeSetPrevBounds();
    }

    private boolean is_beyond_bounds_chk_sameBeginEnd() {
        if (this.it.isValid()) {
            return this.is_beyond_bounds_chk_sameBeginEndNvc();
        }
        return true;
    }

    private boolean is_beyond_bounds_chk_sameBeginEndNvc() {
        Annotation a = (Annotation)this.it.getNvc();
        if (a.getBegin() != this.boundBegin || a.getEnd() != this.boundEnd || this.isUseTypePriority && a._getTypeImpl() != this.boundType) {
            this.makeInvalid();
            return true;
        }
        return false;
    }

    private boolean is_beyond_bounds_chk_coveredByNvc() {
        if (((Annotation)this.it.getNvc()).getBegin() > this.boundEnd) {
            this.makeInvalid();
            return true;
        }
        return false;
    }

    private boolean is_beyond_bounds_chk_covering() {
        if (!this.it.isValid()) {
            return true;
        }
        return this.is_beyond_bounds_chk_coveringNvc();
    }

    private boolean is_beyond_bounds_chk_coveringNvc() {
        Annotation a = (Annotation)this.it.getNvc();
        int begin = a.getBegin();
        int end = a.getEnd();
        if (begin > this.boundBegin || begin == this.boundBegin && (end < this.boundEnd || end == this.boundEnd && this.lto != null && this.lto.lessThan(a._getTypeImpl(), this.boundType))) {
            this.makeInvalid();
            return true;
        }
        return false;
    }

    private void maybeAdjustForAmbiguityAndIgnoringTypePriorities_forward(boolean oneStepOnly) {
        boolean wentBack;
        if (this.isUseTypePriority) {
            return;
        }
        boolean wasValid = this.it.isValid();
        if (!wasValid) {
            this.it.moveToLastNoReinit();
        }
        if (!(wentBack = this.adjustForStrictOrCoveringAndBoundSkip(oneStepOnly)) && !wasValid) {
            this.makeInvalid();
        }
    }

    private boolean coveredByBounds(Annotation ann) {
        if (this.isStrict) {
            return AnnotationPredicates.coveredBy(ann, this.boundBegin, this.boundEnd) || this.isIncludesAnnotationsStartingAtEndPosition && ann.getBegin() == this.boundEnd;
        }
        return AnnotationPredicates.coveredBy(ann, this.boundBegin, this.boundEnd) || AnnotationPredicates.overlappingAtEnd(ann, this.boundBegin, this.boundEnd) || this.isIncludesAnnotationsStartingAtEndPosition && ann.getBegin() == this.boundEnd;
    }

    private boolean adjustForStrictOrCoveringAndBoundSkip(boolean oneStepOnly) {
        boolean wentBack = false;
        boolean lastSeenWasEqualToBounds = false;
        switch (this.boundsUse) {
            case coveredBy: {
                while (this.it.isValid() && (this.equalToBounds((Annotation)this.it.getNvc()) || (oneStepOnly ? !this.coveredByBounds((Annotation)this.it.getNvc()) : ((Annotation)this.it.getNvc()).getBegin() >= this.boundBegin))) {
                    this.it.moveToPreviousNvc();
                    wentBack = true;
                }
                break;
            }
            case covering: {
                while (this.it.isValid() && (this.equalToBounds((Annotation)this.it.getNvc()) || (oneStepOnly ? ((Annotation)this.it.getNvc()).getBegin() <= this.boundBegin && (((Annotation)this.it.getNvc()).getEnd() < this.boundEnd || ((Annotation)this.it.getNvc()).getEnd() == this.boundEnd && this.lto != null && this.lto.lessThan(((Annotation)this.it.getNvc())._getTypeImpl(), this.boundType)) : ((Annotation)this.it.getNvc()).getEnd() < this.boundEnd))) {
                    this.maybeMoveToPrevBounded();
                    wentBack = true;
                }
                break;
            }
            case sameBeginEnd: {
                while (this.it.isValid() && ((lastSeenWasEqualToBounds = this.equalToBounds((Annotation)this.it.getNvc())) || !oneStepOnly && (((Annotation)this.it.getNvc()).getBegin() > this.boundBegin || ((Annotation)this.it.getNvc()).getBegin() == this.boundBegin && ((Annotation)this.it.getNvc()).getEnd() <= this.boundEnd))) {
                    this.it.moveToPreviousNvc();
                    wentBack = true;
                }
                break;
            }
        }
        if (wentBack) {
            if (!this.it.isValid()) {
                if (!oneStepOnly || lastSeenWasEqualToBounds) {
                    this.it.moveToFirstNoReinit();
                }
            } else if (!oneStepOnly && ((Annotation)this.it.getNvc()).getBegin() < this.boundingAnnot.getBegin()) {
                this.it.moveToNextNvc();
            } else if (this.boundsUse == BoundsUse.sameBeginEnd && (oneStepOnly ? ((Annotation)this.it.getNvc()).getBegin() != this.boundingAnnot.getBegin() : ((Annotation)this.it.getNvc()).getBegin() == this.boundingAnnot.getBegin()) && ((Annotation)this.it.getNvc()).getEnd() != this.boundingAnnot.getEnd()) {
                this.it.moveToNextNvc();
            }
        }
        return wentBack;
    }

    private boolean equalToBounds(Annotation fs) {
        return this.isDoEqualsTest && fs._id == this.originalBoundingAnnotation._id || this.isSkipSameBeginEndType && fs.getBegin() == this.boundBegin && fs.getEnd() == this.boundEnd && fs.getType() == this.boundType;
    }

    private void maybeSetPrevBounds() {
        if (this.isUnambiguous && this.it.isValid()) {
            Annotation a = (Annotation)this.it.getNvc();
            this.prevBegin = a.getBegin();
            this.prevEnd = a.getEnd();
        }
    }

    private boolean adjustForStrictNvc_forward() {
        boolean originalBoundZeroWidth;
        Annotation item = (Annotation)this.it.getNvc();
        boolean bl = originalBoundZeroWidth = this.originalBoundBegin == this.originalBoundEnd;
        while (this.boundsUse == BoundsUse.notBounded && item.getBegin() == item.getEnd() && item.getBegin() == this.originalBoundBegin || !this.isIncludeZeroWidthAtBegin && originalBoundZeroWidth && item.getBegin() == this.originalBoundBegin || !this.isIncludeZeroWidthAtEnd && this.originalBoundEnd == item.getBegin() && item.getBegin() == item.getEnd()) {
            this.it.moveToNextNvc();
            if (!this.isValid()) {
                return false;
            }
            item = (Annotation)this.it.getNvc();
        }
        if (!this.isStrict) {
            if (this.isIncludesAnnotationsStartingAtEndPosition) {
                return true;
            }
            while (item.getBegin() == this.boundEnd && item.getBegin() < item.getEnd() || this.equalToBounds(item) || this.isUnambiguous && AnnotationPredicates.overlapping(item, this.prevBegin, this.prevEnd)) {
                this.it.moveToNextNvc();
                if (!this.isValid()) {
                    return false;
                }
                item = (Annotation)this.it.getNvc();
                if (item.getBegin() <= this.boundEnd) continue;
                this.makeInvalid();
                return false;
            }
            return true;
        }
        while (item.getEnd() > this.boundEnd || this.equalToBounds(item) || this.isUnambiguous && AnnotationPredicates.overlapping(item, this.prevBegin, this.prevEnd) || !this.isIncludeZeroWidthAtEnd && this.boundEnd == item.getBegin() && item.getBegin() == item.getEnd() || !this.isIncludeZeroWidthAtEnd && originalBoundZeroWidth && item.getEnd() == this.originalBoundBegin) {
            this.it.moveToNextNvc();
            if (!this.isValid()) {
                return false;
            }
            item = (Annotation)this.it.getNvc();
            if (item.getBegin() <= this.boundEnd) continue;
            this.makeInvalid();
            return false;
        }
        return true;
    }

    private void adjustForCovering_forward() {
        if (!this.it.isValid()) {
            return;
        }
        Annotation a = (Annotation)this.it.getNvc();
        int begin = a.getBegin();
        int end = a.getEnd();
        if (begin > this.boundBegin) {
            this.makeInvalid();
            return;
        }
        while (this.it.isValid() && (this.equalToBounds(a = (Annotation)this.it.getNvc()) || a.getBegin() <= this.boundBegin && ((end = a.getEnd()) < this.boundEnd || end == this.boundEnd && this.lto != null && this.lto.lessThan(a._getTypeImpl(), this.boundType)))) {
            this.it.moveToNextNvc();
        }
    }

    private void maybeMoveToPrevBounded() {
        if (((Annotation)this.it.getNvc())._id == this.startId) {
            this.it.moveToFirstNoReinit();
        }
        this.it.moveToPreviousNvc();
    }

    @Override
    public FSIterator<T> copy() {
        Subiterator<T> copy = new Subiterator<T>(this.it.copy(), this.boundingAnnot, this.originalBoundingAnnotation, !this.isUnambiguous, this.isStrict, this.boundsUse, this.isUseTypePriority, this.isSkipSameBeginEndType, this.startId, this.isEmpty, this.coveringStartPos, this.isDoEqualsTest, this.isIncludesAnnotationsStartingAtEndPosition, this.isIncludeZeroWidthAtBegin, this.isIncludeZeroWidthAtEnd);
        copy.list = this.list;
        copy.pos = this.pos;
        copy.isListForm = this.isListForm;
        return copy;
    }

    @Override
    public int ll_indexSizeMaybeNotCurrent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int ll_maxAnnotSpan() {
        if (this.isEmpty) {
            return 0;
        }
        return this.it.ll_maxAnnotSpan();
    }

    @Override
    public LowLevelIndex<T> ll_getIndex() {
        return this.it.ll_getIndex();
    }

    private void makeInvalid() {
        this.it.moveToFirstNoReinit();
        this.it.moveToPrevious();
    }

    @Override
    public boolean isIndexesHaveBeenUpdated() {
        return this.it.isIndexesHaveBeenUpdated();
    }

    @Override
    public boolean maybeReinitIterator() {
        if (this.it.maybeReinitIterator()) {
            this.resetList();
            this.moveToStartSetEmptyAndId();
            return true;
        }
        return false;
    }

    @Override
    public Comparator<TOP> getComparator() {
        return this.comparatorMaybeNoTypeWithoutId;
    }

    public static enum BoundsUse {
        coveredBy,
        covering,
        sameBeginEnd,
        notBounded;

    }
}

