/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.ws.wsaddressing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.spi.Provider;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.w3c.dom.Element;

public final class W3CEndpointReferenceBuilder {
    private String address;
    private QName serviceName;
    private QName endpointName;
    private QName interfaceName;
    private String wsdlDocumentLocation;
    private List<Element> referenceParameters;
    private List<Element> metadataElements;
    private List<Element> elements;
    private Map<QName, String> attributes;

    public W3CEndpointReferenceBuilder address(String address) {
        this.address = address;
        return this;
    }

    public W3CEndpointReferenceBuilder serviceName(QName serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public W3CEndpointReferenceBuilder endpointName(QName endpointName) {
        if (this.serviceName == null) {
            throw new IllegalStateException("The endpoint qname cannot be set before the service qname.");
        }
        this.endpointName = endpointName;
        return this;
    }

    public W3CEndpointReferenceBuilder wsdlDocumentLocation(String wsdlDocumentLocation) {
        this.wsdlDocumentLocation = wsdlDocumentLocation;
        return this;
    }

    public W3CEndpointReferenceBuilder referenceParameter(Element referenceParameter) {
        if (referenceParameter == null) {
            throw new IllegalArgumentException("A reference parameter cannot be null.");
        }
        if (this.referenceParameters == null) {
            this.referenceParameters = new ArrayList<Element>();
        }
        this.referenceParameters.add(referenceParameter);
        return this;
    }

    public W3CEndpointReferenceBuilder metadata(Element metadataElement) {
        if (metadataElement == null) {
            throw new IllegalArgumentException("A metadata element cannot be null.");
        }
        if (this.metadataElements == null) {
            this.metadataElements = new ArrayList<Element>();
        }
        this.metadataElements.add(metadataElement);
        return this;
    }

    public W3CEndpointReferenceBuilder attribute(QName name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("An attribute name or value cannot be null.");
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<QName, String>();
        }
        this.attributes.put(name, value);
        return this;
    }

    public W3CEndpointReferenceBuilder element(Element el) {
        if (el == null) {
            throw new IllegalArgumentException("An element cannot be null.");
        }
        if (this.elements == null) {
            this.elements = new ArrayList<Element>();
        }
        this.elements.add(el);
        return this;
    }

    public W3CEndpointReferenceBuilder interfaceName(QName iname) {
        this.interfaceName = iname;
        return this;
    }

    public W3CEndpointReference build() {
        try {
            return Provider.provider().createW3CEndpointReference(this.address, this.interfaceName, this.serviceName, this.endpointName, this.metadataElements, this.wsdlDocumentLocation, this.referenceParameters, this.elements, this.attributes);
        }
        catch (UnsupportedOperationException ex) {
            return Provider.provider().createW3CEndpointReference(this.address, this.serviceName, this.endpointName, this.metadataElements, this.wsdlDocumentLocation, this.referenceParameters);
        }
    }
}

