/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.migration.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.karaf.shell.api.console.Session;
import org.apache.unomi.shell.migration.Migration;
import org.apache.unomi.shell.migration.utils.ConsoleUtils;
import org.apache.unomi.shell.migration.utils.MigrationUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Component;

@Component
public class MigrationTo121
implements Migration {
    private CloseableHttpClient httpClient;
    private Session session;
    private String esAddress;
    private LinkedHashMap<String, List<String>> tagsStructurePriorTo130;
    private List propsTaggedAsPersonalIdentifier = Arrays.asList("firstName", "lastName", "email", "phoneNumber", "address", "facebookId", "googleId", "linkedInId", "twitterId");

    @Override
    public Version getFromVersion() {
        return null;
    }

    @Override
    public Version getToVersion() {
        return new Version("1.2.1");
    }

    @Override
    public String getDescription() {
        return "Migrate tags";
    }

    @Override
    public void execute(Session session, CloseableHttpClient httpClient, String esAddress, BundleContext bundleContext) throws IOException {
        this.httpClient = httpClient;
        this.session = session;
        this.esAddress = esAddress;
        this.migrateTags();
    }

    private void migrateTags() throws IOException {
        this.initTagsStructurePriorTo130();
        String tagsOperation = ConsoleUtils.askUserWithAuthorizedAnswer(this.session, "How to manage tags?\n1. copy: will duplicate tags in systemTags property\n2. move: will move tags in systemTags property\n[1 - 2]: ", Arrays.asList("1", "2"));
        String removeNamespaceOnSystemTags = ConsoleUtils.askUserWithAuthorizedAnswer(this.session, "As we will copy/move the tags, do you wish to remove existing namespace on tags before copy/move in systemTags? (e.g: hidden.) (yes/no): ", Arrays.asList("yes", "no"));
        List<String> typeToMigrate = Arrays.asList("actionType", "conditionType", "campaign", "goal", "rule", "scoring", "segment", "userList");
        for (String type : typeToMigrate) {
            this.migrateTagsInResult(this.esAddress, type, 10, true, tagsOperation, removeNamespaceOnSystemTags.equals("yes"), null);
        }
        this.migrateTagsInResult(this.esAddress, "propertyType", 10, false, tagsOperation, removeNamespaceOnSystemTags.equals("yes"), null);
    }

    private void migrateTagsInResult(String hostAddress, String type, int currentOffset, boolean tagsInMetadata, String tagsOperation, boolean removeNamespaceOnSystemTags, String scrollId) throws IOException {
        JSONObject hitsObject;
        JSONObject responseJSON = StringUtils.isNotBlank((CharSequence)scrollId) ? MigrationUtils.continueQueryWithScroll(this.httpClient, hostAddress, scrollId) : MigrationUtils.queryWithScroll(this.httpClient, hostAddress + "/context/" + type + "/_search");
        if (responseJSON.has("hits") && (hitsObject = responseJSON.getJSONObject("hits")).has("hits")) {
            JSONArray hits = hitsObject.getJSONArray("hits");
            StringBuilder updatedHits = new StringBuilder();
            for (JSONObject hit : hits) {
                if (!hit.has("_source")) continue;
                JSONObject hitSource = hit.getJSONObject("_source");
                if (tagsInMetadata && hitSource.has("metadata")) {
                    JSONObject hitMetadata = hitSource.getJSONObject("metadata");
                    this.updateTagsForHit(updatedHits, hit.optString("_id"), hitMetadata, tagsInMetadata, tagsOperation, removeNamespaceOnSystemTags);
                    continue;
                }
                if (tagsInMetadata) continue;
                this.updateTagsForHit(updatedHits, hit.optString("_id"), hitSource, tagsInMetadata, tagsOperation, removeNamespaceOnSystemTags);
            }
            String jsonData = updatedHits.toString();
            if (StringUtils.isNotBlank((CharSequence)jsonData)) {
                MigrationUtils.bulkUpdate(this.httpClient, hostAddress + "/context/" + type + "/_bulk", jsonData);
            }
            if (hitsObject.getInt("total") > currentOffset) {
                this.migrateTagsInResult(hostAddress, type, currentOffset + 10, tagsInMetadata, tagsOperation, removeNamespaceOnSystemTags, responseJSON.optString("_scroll_id"));
            }
        }
    }

    private void updateTagsForHit(StringBuilder updatedHits, String hitId, JSONObject jsonObject, boolean tagsInMetadata, String tagsOperation, boolean removeNamespaceOnSystemTags) {
        if (jsonObject.has("tags")) {
            JSONArray hitTags = jsonObject.getJSONArray("tags");
            Iterator tagsIterator = hitTags.iterator();
            HashSet<String> tagsBeforeMigration = new HashSet<String>();
            HashSet<String> tagsAfterMigration = new HashSet<String>();
            if (tagsIterator.hasNext()) {
                Set<String> tags;
                while (tagsIterator.hasNext()) {
                    tagsBeforeMigration.add((String)tagsIterator.next());
                }
                for (String tag : tagsBeforeMigration) {
                    if (this.tagsStructurePriorTo130.containsKey(tag)) {
                        tagsAfterMigration.addAll((Collection)this.tagsStructurePriorTo130.get(tag));
                    }
                    tagsAfterMigration.add(tag);
                }
                updatedHits.append("{\"update\":{\"_id\":\"").append(hitId).append("\"}}\n");
                if (tagsOperation.equals("1")) {
                    tags = this.removeNamespaceOnTags(removeNamespaceOnSystemTags, tagsAfterMigration);
                    if (this.propsTaggedAsPersonalIdentifier.contains(hitId)) {
                        tags.add("personalIdentifierProperties");
                    }
                    updatedHits.append("{\"doc\":{\"metadata\":{\"tags\":").append(new JSONArray(tagsAfterMigration)).append(",\"systemTags\":").append(new JSONArray(tags)).append("}}}\n");
                }
                if (tagsOperation.equals("2")) {
                    tags = this.removeNamespaceOnTags(removeNamespaceOnSystemTags, tagsAfterMigration);
                    if (this.propsTaggedAsPersonalIdentifier.contains(hitId)) {
                        tags.add("personalIdentifierProperties");
                    }
                    updatedHits.append("{\"doc\":{\"metadata\":{\"systemTags\":").append(new JSONArray(tags)).append("}}}\n");
                    if (tagsInMetadata) {
                        updatedHits.append("{\"update\":{\"_id\":\"").append(hitId).append("\"}}\n");
                        updatedHits.append("{\"script\":\"ctx._source.metadata.remove(\\\"tags\\\")\"}\n");
                    }
                }
                if (!tagsInMetadata) {
                    updatedHits.append("{\"update\":{\"_id\":\"").append(hitId).append("\"}}\n");
                    updatedHits.append("{\"script\":\"ctx._source.remove(\\\"tags\\\")\"}\n");
                }
            }
        }
    }

    private Set<String> removeNamespaceOnTags(boolean removeNamespaceOnSystemTags, Set<String> tagsAfterMigration) {
        if (!removeNamespaceOnSystemTags) {
            return tagsAfterMigration;
        }
        HashSet<String> tags = new HashSet<String>();
        for (String tag : tagsAfterMigration) {
            if (StringUtils.startsWith((CharSequence)tag, (CharSequence)"hidden.")) {
                tags.add(StringUtils.substringAfter((String)tag, (String)"hidden."));
                continue;
            }
            tags.add(tag);
        }
        return tags;
    }

    private void initTagsStructurePriorTo130() {
        this.tagsStructurePriorTo130 = new LinkedHashMap();
        this.tagsStructurePriorTo130.put("landing", Collections.singletonList("campaign"));
        this.tagsStructurePriorTo130.put("parameter", Collections.singletonList("campaign"));
        this.tagsStructurePriorTo130.put("referrer", Collections.singletonList("campaign"));
        this.tagsStructurePriorTo130.put("eventCondition", Collections.singletonList("condition"));
        this.tagsStructurePriorTo130.put("profileCondition", Collections.singletonList("condition"));
        this.tagsStructurePriorTo130.put("sessionCondition", Collections.singletonList("condition"));
        this.tagsStructurePriorTo130.put("sourceEventCondition", Collections.singletonList("condition"));
        this.tagsStructurePriorTo130.put("trackedCondition", Collections.singletonList("condition"));
        this.tagsStructurePriorTo130.put("usableInPastEventCondition", Collections.singletonList("condition"));
        this.tagsStructurePriorTo130.put("formMappingRule", Collections.emptyList());
        this.tagsStructurePriorTo130.put("downloadGoal", Collections.singletonList("goal"));
        this.tagsStructurePriorTo130.put("formGoal", Collections.singletonList("goal"));
        this.tagsStructurePriorTo130.put("funnelGoal", Collections.singletonList("goal"));
        this.tagsStructurePriorTo130.put("landingPageGoal", Collections.singletonList("goal"));
        this.tagsStructurePriorTo130.put("pageVisitGoal", Collections.singletonList("goal"));
        this.tagsStructurePriorTo130.put("videoGoal", Collections.singletonList("goal"));
        this.tagsStructurePriorTo130.put("aggregated", Collections.singletonList("profileTags"));
        this.tagsStructurePriorTo130.put("autocompleted", Collections.singletonList("profileTags"));
        this.tagsStructurePriorTo130.put("demographic", Collections.singletonList("profileTags"));
        this.tagsStructurePriorTo130.put("event", Collections.singletonList("profileTags"));
        this.tagsStructurePriorTo130.put("geographic", Collections.singletonList("profileTags"));
        this.tagsStructurePriorTo130.put("logical", Collections.singletonList("profileTags"));
        this.tagsStructurePriorTo130.put("profileProperties", Collections.singletonList("properties"));
        this.tagsStructurePriorTo130.put("systemProfileProperties", Arrays.asList("properties", "profileProperties"));
        this.tagsStructurePriorTo130.put("basicProfileProperties", Arrays.asList("properties", "profileProperties"));
        this.tagsStructurePriorTo130.put("leadProfileProperties", Arrays.asList("properties", "profileProperties"));
        this.tagsStructurePriorTo130.put("contactProfileProperties", Arrays.asList("properties", "profileProperties"));
        this.tagsStructurePriorTo130.put("socialProfileProperties", Arrays.asList("properties", "profileProperties"));
        this.tagsStructurePriorTo130.put("personalProfileProperties", Arrays.asList("properties", "profileProperties"));
        this.tagsStructurePriorTo130.put("workProfileProperties", Arrays.asList("properties", "profileProperties"));
        this.tagsStructurePriorTo130.put("sessionProperties", Collections.singletonList("properties"));
        this.tagsStructurePriorTo130.put("geographicSessionProperties", Arrays.asList("properties", "sessionProperties"));
        this.tagsStructurePriorTo130.put("technicalSessionProperties", Arrays.asList("properties", "sessionProperties"));
    }
}

