/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.karaf.commands;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.karaf.commands.completers.BusCompleter;
import org.apache.cxf.karaf.commands.internal.CXFController;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.support.table.ShellTable;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="cxf", name="list-endpoints", description="Lists all CXF Endpoints on a Bus.")
@Service
public class ListEndpointsCommand
extends CXFController
implements Action {
    protected static final String HEADER_FORMAT = "%-25s %-10s %-60s %-40s";
    protected static final String OUTPUT_FORMAT = "[%-23s] [%-8s] [%-58s] [%-38s]";
    @Argument(index=0, name="bus", description="The CXF bus name where to look for the Endpoints", required=false, multiValued=false)
    @Completion(value=BusCompleter.class)
    String name;
    @Option(name="-f", aliases={"--fulladdress"}, description="Display full address of an endpoint ", required=false, multiValued=false)
    boolean fullAddress;
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;
    @Reference(optional=true)
    Terminal terminal;

    public Object execute() throws Exception {
        Bus b;
        List<Object> busses = this.name == null ? this.getBusses() : ((b = this.getBus(this.name)) != null ? Collections.singletonList(this.getBus(this.name)) : Collections.emptyList());
        ShellTable table = new ShellTable();
        if (this.terminal != null && this.terminal.getWidth() > 0) {
            table.size(this.terminal.getWidth());
        }
        table.column("Name");
        table.column("State");
        table.column("Address");
        table.column("BusID");
        for (Bus bus : busses) {
            ServerRegistry reg = (ServerRegistry)bus.getExtension(ServerRegistry.class);
            List servers = reg.getServers();
            for (Server serv : servers) {
                String qname = serv.getEndpoint().getEndpointInfo().getName().getLocalPart();
                String started = serv.isStarted() ? "Started" : "Stopped";
                String address = serv.getEndpoint().getEndpointInfo().getAddress();
                if (this.fullAddress) {
                    address = this.toFullAddress(address);
                }
                String busId = bus.getId();
                table.addRow().addContent(new Object[]{qname, started, address, busId});
            }
        }
        table.print(System.out, !this.noFormat);
        return null;
    }

    private String toFullAddress(String address) throws IOException, InvalidSyntaxException {
        ConfigurationAdmin configAdmin = this.getConfigAdmin();
        if (address.startsWith("/") && configAdmin != null) {
            String httpPort = null;
            String cxfContext = null;
            httpPort = this.extractConfigProperty(configAdmin, "org.ops4j.pax.web", "org.osgi.service.http.port");
            cxfContext = this.extractConfigProperty(configAdmin, "org.apache.cxf.osgi", "org.apache.cxf.servlet.context");
            if (StringUtils.isEmpty((String)cxfContext)) {
                cxfContext = this.getCXFOSGiServletContext();
            }
            if (StringUtils.isEmpty((String)httpPort)) {
                httpPort = this.getHttpOSGiServicePort();
            }
            if (!StringUtils.isEmpty((String)httpPort) && !StringUtils.isEmpty((String)cxfContext)) {
                address = "http://localhost:" + httpPort + cxfContext + address;
            }
        }
        return address;
    }

    private String extractConfigProperty(ConfigurationAdmin configAdmin, String pid, String propertyName) throws IOException, InvalidSyntaxException {
        Configuration configuration;
        String ret = null;
        Configuration[] configs = configAdmin.listConfigurations("(service.pid=" + pid + ")");
        if (configs != null && configs.length > 0 && (configuration = configs[0]) != null) {
            ret = (String)configuration.getProperties().get(propertyName);
        }
        return ret;
    }

    private String getCXFOSGiServletContext() throws InvalidSyntaxException {
        String ret = null;
        String filter = "(&(objectclass=javax.servlet.Servlet)(servlet-name=cxf-osgi-transport-servlet))";
        ServiceReference ref = this.getBundleContext().getServiceReferences((String)null, filter)[0];
        if (ref != null) {
            ret = (String)ref.getProperty("alias");
        }
        return ret;
    }

    private String getHttpOSGiServicePort() throws InvalidSyntaxException {
        String ret = null;
        String filter = "(&(objectclass=org.osgi.service.http.HttpService))";
        ServiceReference ref = this.getBundleContext().getServiceReferences((String)null, filter)[0];
        if (ref != null) {
            ret = (String)ref.getProperty("org.osgi.service.http.port");
        }
        return ret;
    }
}

