/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.boot.principal;

import java.io.Serializable;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Objects;
import org.apache.karaf.jaas.boot.principal.Group;

public class GroupPrincipal
implements Group,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Hashtable<String, Principal> members = new Hashtable();

    public GroupPrincipal(String name) {
        assert (name != null);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupPrincipal that = (GroupPrincipal)o;
        return Objects.equals(this.name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public String toString() {
        return "GroupPrincipal[" + this.name + "]";
    }

    @Override
    public boolean addMember(Principal user) {
        this.members.put(user.getName(), user);
        return true;
    }

    @Override
    public boolean removeMember(Principal user) {
        this.members.remove(user.getName());
        return true;
    }

    @Override
    public boolean isMember(Principal member) {
        return this.members.containsKey(member.getName());
    }

    @Override
    public Enumeration<? extends Principal> members() {
        return this.members.elements();
    }
}

