/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.services;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.unomi.api.Item;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.apache.unomi.router.api.ImportConfiguration;
import org.apache.unomi.router.api.RouterConstants;
import org.apache.unomi.router.api.services.ImportExportConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportConfigurationServiceImpl
implements ImportExportConfigurationService<ImportConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger((String)ImportConfigurationServiceImpl.class.getName());
    private PersistenceService persistenceService;
    private final Map<String, RouterConstants.CONFIG_CAMEL_REFRESH> camelConfigsToRefresh = new ConcurrentHashMap<String, RouterConstants.CONFIG_CAMEL_REFRESH>();

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public ImportConfigurationServiceImpl() {
        logger.info("Initializing import configuration service...");
    }

    public List<ImportConfiguration> getAll() {
        return this.persistenceService.getAllItems(ImportConfiguration.class);
    }

    public ImportConfiguration load(String configId) {
        return (ImportConfiguration)this.persistenceService.load(configId, ImportConfiguration.class);
    }

    public ImportConfiguration save(ImportConfiguration importConfiguration, boolean updateRunningRoute) {
        if (importConfiguration.getItemId() == null) {
            importConfiguration.setItemId(UUID.randomUUID().toString());
        }
        if (updateRunningRoute) {
            this.camelConfigsToRefresh.put(importConfiguration.getItemId(), RouterConstants.CONFIG_CAMEL_REFRESH.UPDATED);
        }
        this.persistenceService.save((Item)importConfiguration);
        return (ImportConfiguration)this.persistenceService.load(importConfiguration.getItemId(), ImportConfiguration.class);
    }

    public void delete(String configId) {
        this.persistenceService.remove(configId, ImportConfiguration.class);
        this.camelConfigsToRefresh.put(configId, RouterConstants.CONFIG_CAMEL_REFRESH.REMOVED);
    }

    public Map<String, RouterConstants.CONFIG_CAMEL_REFRESH> consumeConfigsToBeRefresh() {
        HashMap<String, RouterConstants.CONFIG_CAMEL_REFRESH> result = new HashMap<String, RouterConstants.CONFIG_CAMEL_REFRESH>(this.camelConfigsToRefresh);
        this.camelConfigsToRefresh.clear();
        return result;
    }
}

