/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.remoteworkspace.client;

import aQute.bnd.service.remoteworkspace.RemoteWorkspace;
import aQute.bnd.service.remoteworkspace.RemoteWorkspaceClient;
import aQute.lib.aspects.Aspects;
import aQute.lib.exceptions.Exceptions;
import aQute.lib.exceptions.FunctionWithException;
import aQute.lib.io.IO;
import aQute.lib.link.Link;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteWorkspaceClientFactory {
    static final Logger logger = LoggerFactory.getLogger(RemoteWorkspaceClientFactory.class);
    static final ExecutorService executorService = Executors.newFixedThreadPool(6);

    public static RemoteWorkspace create(File dir, RemoteWorkspaceClient client) {
        return RemoteWorkspaceClientFactory.findRemoteWorkspace(dir, p -> RemoteWorkspaceClientFactory.create(p, client));
    }

    public static RemoteWorkspace create(int port, RemoteWorkspaceClient client) throws IOException {
        Socket socket = new Socket(InetAddress.getLoopbackAddress(), port);
        Link<RemoteWorkspaceClient, RemoteWorkspace> link = new Link<RemoteWorkspaceClient, RemoteWorkspace>(RemoteWorkspace.class, socket, executorService);
        link.open(client);
        RemoteWorkspace remote = link.getRemote();
        return Aspects.intercept(RemoteWorkspace.class, remote).intercept(() -> {
            logger.debug("Closing remote worksapace link on port {}", (Object)port);
            IO.close(link::close);
        }, "close").intercept(() -> "RemoteWorkspace[port=" + port + "]", "toString").build();
    }

    private static RemoteWorkspace findRemoteWorkspace(File dir, FunctionWithException<Integer, RemoteWorkspace> attach) {
        File remotews = RemoteWorkspaceClientFactory.getPortDirectory(dir, dir);
        if (remotews.isDirectory()) {
            File[] portFiles = remotews.listFiles();
            if (portFiles.length > 0) {
                Arrays.sort(portFiles, (a, b) -> Long.compare(b.lastModified(), a.lastModified()));
                for (File portFile : portFiles) {
                    try {
                        if (!portFile.getName().matches("[0-9]+")) {
                            throw new IllegalArgumentException("Port number not a number: " + portFile.getName());
                        }
                        int port = Integer.parseInt(portFile.getName());
                        if (port <= 0 || port >= 65535) {
                            throw new IllegalArgumentException("Port number not in range 1-0xFFFF");
                        }
                        RemoteWorkspace rws = attach.apply(port);
                        logger.info("Found remote workspace {}", (Object)rws);
                        return rws;
                    }
                    catch (Exception e) {
                        logger.warn("Found stale or wrong workspace port reference in {}", (Object)portFile);
                        if (portFile.lastModified() + TimeUnit.HOURS.toMillis(4L) >= System.currentTimeMillis()) continue;
                        IO.delete(portFile);
                        logger.warn("Purged portFile due to not working and likely stale. Can happen when a process quits unexpectedly. File was {}", (Object)portFile);
                    }
                    catch (Throwable t) {
                        throw Exceptions.duck(t);
                    }
                }
            } else {
                throw new IllegalArgumentException("No remote workspaces registered in   " + remotews);
            }
        }
        throw new IllegalArgumentException("Cannot find remote workspace from directory  " + dir);
    }

    public static File getPortDirectory(File dir, File org) {
        if (dir != null && dir.exists()) {
            boolean isWorkspace = IO.getFile(dir, "cnf/build.bnd").isFile();
            if (isWorkspace) {
                return IO.getFile(dir, "cnf/cache/remotews");
            }
            return RemoteWorkspaceClientFactory.getPortDirectory(dir.getParentFile(), org);
        }
        throw new IllegalArgumentException("No cnf/cache/remotews reachable from " + org);
    }
}

