/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.component;

import aQute.bnd.component.ComponentDef;
import aQute.bnd.component.DSAnnotationReader;
import aQute.bnd.component.MergedRequirement;
import aQute.bnd.component.ReferenceDef;
import aQute.bnd.component.TagResource;
import aQute.bnd.component.annotations.ReferenceCardinality;
import aQute.bnd.component.error.DeclarativeServicesAnnotationError;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Processor;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.bnd.stream.MapStream;
import aQute.bnd.version.Version;
import aQute.bnd.xmlattribute.XMLAttributeFinder;
import aQute.lib.collections.MultiMap;
import aQute.lib.strings.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class DSAnnotations
implements AnalyzerPlugin {
    @Override
    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        Clazz componentAnnotation;
        VersionSettings settings = new VersionSettings();
        Parameters header = OSGiHeader.parseHeader(analyzer.getProperty("-dsannotations", "*"));
        if (header.isEmpty()) {
            return false;
        }
        Parameters optionsHeader = OSGiHeader.parseHeader(analyzer.mergeProperties("-dsannotations-options"));
        EnumSet<Options> options = EnumSet.noneOf(Options.class);
        for (Map.Entry<String, Attrs> entry : optionsHeader.entrySet()) {
            try {
                Options.parseOption(entry, options, settings);
            }
            catch (IllegalArgumentException e) {
                analyzer.error("Unrecognized %s value %s with attributes %s, expected values are %s", "-dsannotations-options", entry.getKey(), entry.getValue(), EnumSet.allOf(Options.class));
            }
        }
        if (analyzer.is("-dsannotations-inherit")) {
            options.add(Options.inherit);
        }
        if (analyzer.is("-ds-felix-extensions")) {
            options.add(Options.felixExtensions);
        }
        Instructions instructions = new Instructions(header);
        Collection<Clazz> list = analyzer.getClassspace().values();
        String sc = analyzer.getProperty("Service-Component");
        List<String> componentPaths = new ArrayList<String>();
        if (sc != null && sc.trim().length() > 0) {
            componentPaths.add(sc);
        }
        boolean nouses = analyzer.is("-nouses");
        MultiMap<String, ComponentDef> definitionsByName = new MultiMap<String, ComponentDef>();
        TreeSet<String> provides = new TreeSet<String>();
        TreeSet<String> requires = new TreeSet<String>();
        Version maxVersionUsedByAnyComponent = DSAnnotationReader.V1_0;
        XMLAttributeFinder finder = new XMLAttributeFinder(analyzer);
        boolean componentProcessed = false;
        block3: for (Clazz c : list) {
            for (Instruction instruction : instructions.keySet()) {
                ComponentDef definition;
                if (!instruction.matches(c.getFQN())) continue;
                if (instruction.isNegated() || (definition = DSAnnotationReader.getDefinition(c, analyzer, options, finder, settings.minVersion)) == null) continue block3;
                componentProcessed = true;
                definition.sortReferences();
                definition.prepare(analyzer);
                this.checkVersionConflicts(analyzer, definition, settings);
                this.makeUnique(definitionsByName, definition);
                String path = "OSGI-INF/" + analyzer.validResourcePath(definition.name, "Invalid component name") + ".xml";
                componentPaths.add(path);
                analyzer.getJar().putResource(path, new TagResource(definition.getTag()));
                if (!options.contains((Object)Options.nocapabilities)) {
                    this.addServiceCapability(definition, provides, nouses);
                }
                if (!options.contains((Object)Options.norequirements)) {
                    MergedRequirement serviceReqMerge = new MergedRequirement("osgi.service");
                    for (ReferenceDef ref : definition.references.values()) {
                        this.addServiceRequirement(ref, serviceReqMerge);
                    }
                    requires.addAll(serviceReqMerge.toStringList());
                }
                maxVersionUsedByAnyComponent = ComponentDef.max(maxVersionUsedByAnyComponent, definition.version);
                continue block3;
            }
        }
        if (!(!componentProcessed || !options.contains((Object)Options.extender) && maxVersionUsedByAnyComponent.compareTo(DSAnnotationReader.V1_3) < 0 || (componentAnnotation = analyzer.findClass(analyzer.getTypeRef("org/osgi/service/component/annotations/Component"))) != null && componentAnnotation.annotations().contains(analyzer.getTypeRef("org/osgi/service/component/annotations/RequireServiceComponentRuntime")))) {
            maxVersionUsedByAnyComponent = ComponentDef.max(maxVersionUsedByAnyComponent, DSAnnotationReader.V1_3);
            this.addExtenderRequirement(requires, maxVersionUsedByAnyComponent);
        }
        componentPaths = DSAnnotations.removeOverlapInServiceComponentHeader(componentPaths);
        sc = Processor.append(componentPaths.toArray(new String[0]));
        analyzer.setProperty("Service-Component", sc);
        this.updateHeader(analyzer, "Require-Capability", requires);
        this.updateHeader(analyzer, "Provide-Capability", provides);
        MapStream.of(definitionsByName).filterValue(l -> l.size() > 1).forEach((k, v) -> analyzer.error("Same component name %s used in multiple component implementations: %s", k, v.stream().map(def -> def.implementation).collect(Collectors.toList())));
        return false;
    }

    private void checkVersionConflicts(Analyzer analyzer, ComponentDef definition, VersionSettings settings) {
        if (definition.version.compareTo(settings.maxVersion) > 0) {
            DeclarativeServicesAnnotationError dse = new DeclarativeServicesAnnotationError(definition.implementation.getFQN(), null, DeclarativeServicesAnnotationError.ErrorType.VERSION_MISMATCH);
            analyzer.error("[%s] component %s version %s exceeds -dsannotations-options version;maximum version %s because %s", dse.location(), definition.name, definition.version, settings.maxVersion, definition.versionReason).details(dse);
        }
    }

    private void makeUnique(MultiMap<String, ComponentDef> definitionsByName, ComponentDef definition) {
        String uniqueName = definition.name;
        List<ComponentDef> l = definitionsByName.getOrDefault((Object)definition.name, Collections.emptyList());
        if (!l.isEmpty()) {
            uniqueName = uniqueName + "-" + l.size();
        }
        definitionsByName.add(definition.name, definition);
        definition.name = uniqueName;
    }

    public static List<String> removeOverlapInServiceComponentHeader(Collection<String> names) {
        ArrayList<String> wildcards = new ArrayList<String>(names);
        wildcards.removeIf(name -> !name.contains("*"));
        Instructions wildcardedPaths = new Instructions(wildcards);
        if (wildcardedPaths.isEmpty()) {
            return new ArrayList<String>(names);
        }
        ArrayList<String> actual = new ArrayList<String>();
        for (String name2 : names) {
            if (!name2.contains("*") && wildcardedPaths.matches(name2)) continue;
            actual.add(name2);
        }
        return actual;
    }

    private void addServiceCapability(ComponentDef definition, Set<String> provides, boolean nouses) {
        String uses;
        if (definition.factory != null) {
            Attrs a = new Attrs();
            a.put("objectClass:List<String>", "org.osgi.service.component.ComponentFactory");
            a.put("component.factory", definition.factory);
            Parameters p = new Parameters();
            p.put("osgi.service", a);
            String s = p.toString();
            provides.add(s);
            return;
        }
        Descriptors.TypeRef[] services = definition.service;
        if (services == null) {
            return;
        }
        String objectClass = Arrays.stream(services).map(Descriptors.TypeRef::getFQN).sorted().collect(Strings.joining());
        if (objectClass.isEmpty()) {
            return;
        }
        Attrs a = new Attrs();
        a.put("objectClass:List<String>", objectClass);
        if (!nouses && !(uses = Arrays.stream(services).map(Descriptors.TypeRef::getPackageRef).filter(pkg -> !pkg.isJava() && !pkg.isMetaData()).map(Descriptors.PackageRef::getFQN).sorted().collect(Strings.joining())).isEmpty()) {
            a.put("uses:", uses);
        }
        Parameters p = new Parameters();
        p.put("osgi.service", a);
        String s = p.toString();
        provides.add(s);
    }

    private void addServiceRequirement(ReferenceDef ref, MergedRequirement requires) {
        String objectClass = ref.service;
        ReferenceCardinality cardinality = ref.cardinality;
        boolean optional = cardinality == ReferenceCardinality.OPTIONAL || cardinality == ReferenceCardinality.MULTIPLE;
        boolean multiple = cardinality == ReferenceCardinality.MULTIPLE || cardinality == ReferenceCardinality.AT_LEAST_ONE;
        String filter = "(objectClass=" + objectClass + ")";
        if ("org.osgi.service.component.ComponentFactory".equals(objectClass)) {
            if (ref.target == null) {
                return;
            }
            filter = "(&" + filter + ref.target + ")";
        }
        requires.put(filter, "active", optional, multiple);
    }

    private void addExtenderRequirement(Set<String> requires, Version version) {
        Version next = version.bumpMajor();
        Parameters p = new Parameters();
        Attrs a = new Attrs();
        a.put("filter:", "\"(&(osgi.extender=osgi.component)(version>=" + version + ")(!(" + "version" + ">=" + next + ")))\"");
        p.put("osgi.extender", a);
        String s = p.toString();
        requires.add(s);
    }

    private void updateHeader(Analyzer analyzer, String name, TreeSet<String> set) {
        if (!set.isEmpty()) {
            String value = analyzer.getProperty(name);
            if (value != null) {
                Parameters p = OSGiHeader.parseHeader(value);
                for (Map.Entry<String, Attrs> entry : p.entrySet()) {
                    StringBuilder sb = new StringBuilder(entry.getKey());
                    if (entry.getValue() != null) {
                        sb.append(";");
                        entry.getValue().append(sb);
                    }
                    set.add(sb.toString());
                }
            }
            String header = Strings.join(set);
            analyzer.setProperty(name, header);
        }
    }

    public String toString() {
        return "DSAnnotations";
    }

    static class VersionSettings {
        Version minVersion = DSAnnotationReader.V1_3;
        Version maxVersion = DSAnnotationReader.VMAX;

        VersionSettings() {
        }
    }

    public static enum Options {
        inherit,
        felixExtensions,
        extender,
        nocapabilities,
        norequirements,
        version{

            @Override
            void process(VersionSettings settings, Attrs attrs) {
                String max;
                String min = attrs.get("minimum");
                if (min != null && min.length() > 0) {
                    settings.minVersion = Version.valueOf(min);
                }
                if ((max = attrs.get("maximum")) != null && max.length() > 0) {
                    settings.maxVersion = Version.valueOf(max);
                }
            }
        };


        void process(VersionSettings anno, Attrs attrs) {
        }

        void reset(VersionSettings anno) {
        }

        static void parseOption(Map.Entry<String, Attrs> entry, Set<Options> options, VersionSettings state) {
            String s = entry.getKey();
            boolean negation = false;
            if (s.startsWith("!")) {
                negation = true;
                s = s.substring(1);
            }
            Options option = Options.valueOf(s);
            if (negation) {
                options.remove((Object)option);
                option.reset(state);
            } else {
                options.add(option);
                Attrs attrs = entry.getValue();
                if (attrs != null) {
                    option.process(state, attrs);
                }
            }
        }
    }
}

