/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.internal.SearchContext;

public abstract class ValuesSourceAggregationBuilder<VS extends ValuesSource, AB extends ValuesSourceAggregationBuilder<VS, AB>>
extends AbstractAggregationBuilder<AB> {
    private final ValuesSourceType valuesSourceType;
    private final ValueType targetValueType;
    private String field = null;
    private Script script = null;
    private ValueType valueType = null;
    private String format = null;
    private Object missing = null;
    private ZoneId timeZone = null;
    protected ValuesSourceConfig<VS> config;

    protected ValuesSourceAggregationBuilder(String name, ValuesSourceType valuesSourceType, ValueType targetValueType) {
        super(name);
        if (valuesSourceType == null) {
            throw new IllegalArgumentException("[valuesSourceType] must not be null: [" + name + "]");
        }
        this.valuesSourceType = valuesSourceType;
        this.targetValueType = targetValueType;
    }

    protected ValuesSourceAggregationBuilder(ValuesSourceAggregationBuilder<VS, AB> clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.valuesSourceType = clone.valuesSourceType;
        this.targetValueType = clone.targetValueType;
        this.field = clone.field;
        this.valueType = clone.valueType;
        this.format = clone.format;
        this.missing = clone.missing;
        this.timeZone = clone.timeZone;
        this.config = clone.config;
        this.script = clone.script;
    }

    protected ValuesSourceAggregationBuilder(StreamInput in, ValuesSourceType valuesSourceType, ValueType targetValueType) throws IOException {
        super(in);
        this.valuesSourceType = valuesSourceType;
        this.targetValueType = this.serializeTargetValueType(in.getVersion()) ? in.readOptionalWriteable(ValueType::readFromStream) : targetValueType;
        this.read(in);
    }

    protected ValuesSourceAggregationBuilder(StreamInput in, ValuesSourceType valuesSourceType) throws IOException {
        super(in);
        assert (this.serializeTargetValueType(in.getVersion())) : "Wrong read constructor called for subclass that serializes its targetValueType";
        this.valuesSourceType = valuesSourceType;
        this.targetValueType = in.readOptionalWriteable(ValueType::readFromStream);
        this.read(in);
    }

    private void read(StreamInput in) throws IOException {
        this.field = in.readOptionalString();
        if (in.readBoolean()) {
            this.script = new Script(in);
        }
        if (in.readBoolean()) {
            this.valueType = ValueType.readFromStream(in);
        }
        this.format = in.readOptionalString();
        this.missing = in.readGenericValue();
        this.timeZone = in.getVersion().before(Version.V_7_0_0) ? DateUtils.dateTimeZoneToZoneId(in.readOptionalTimeZone()) : in.readOptionalZoneId();
    }

    @Override
    protected final void doWriteTo(StreamOutput out) throws IOException {
        if (this.serializeTargetValueType(out.getVersion())) {
            out.writeOptionalWriteable(this.targetValueType);
        }
        out.writeOptionalString(this.field);
        boolean hasScript = this.script != null;
        out.writeBoolean(hasScript);
        if (hasScript) {
            this.script.writeTo(out);
        }
        boolean hasValueType = this.valueType != null;
        out.writeBoolean(hasValueType);
        if (hasValueType) {
            this.valueType.writeTo(out);
        }
        out.writeOptionalString(this.format);
        out.writeGenericValue(this.missing);
        if (out.getVersion().before(Version.V_7_0_0)) {
            out.writeOptionalTimeZone(DateUtils.zoneIdToDateTimeZone(this.timeZone));
        } else {
            out.writeOptionalZoneId(this.timeZone);
        }
        this.innerWriteTo(out);
    }

    protected abstract void innerWriteTo(StreamOutput var1) throws IOException;

    protected boolean serializeTargetValueType(Version version) {
        return false;
    }

    public AB field(String field) {
        if (field == null) {
            throw new IllegalArgumentException("[field] must not be null: [" + this.name + "]");
        }
        this.field = field;
        return (AB)this;
    }

    public String field() {
        return this.field;
    }

    public AB script(Script script) {
        if (script == null) {
            throw new IllegalArgumentException("[script] must not be null: [" + this.name + "]");
        }
        this.script = script;
        return (AB)this;
    }

    public Script script() {
        return this.script;
    }

    public AB valueType(ValueType valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("[valueType] must not be null: [" + this.name + "]");
        }
        this.valueType = valueType;
        return (AB)this;
    }

    public ValueType valueType() {
        return this.valueType;
    }

    public AB format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return (AB)this;
    }

    public String format() {
        return this.format;
    }

    public AB missing(Object missing) {
        if (missing == null) {
            throw new IllegalArgumentException("[missing] must not be null: [" + this.name + "]");
        }
        this.missing = missing;
        return (AB)this;
    }

    public Object missing() {
        return this.missing;
    }

    public AB timeZone(ZoneId timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException("[timeZone] must not be null: [" + this.name + "]");
        }
        this.timeZone = timeZone;
        return (AB)this;
    }

    public ZoneId timeZone() {
        return this.timeZone;
    }

    @Override
    protected final ValuesSourceAggregatorFactory<VS> doBuild(SearchContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        ValuesSourceConfig<VS> config = this.resolveConfig(context);
        ValuesSourceAggregatorFactory<VS> factory = this.innerBuild(context, config, parent, subFactoriesBuilder);
        return factory;
    }

    protected ValuesSourceType resolveScriptAny(Script script) {
        return ValuesSourceType.BYTES;
    }

    protected ValueType defaultValueType(Script script) {
        return this.valueType;
    }

    protected ValuesSourceConfig<VS> resolveConfig(SearchContext context) {
        ValueType valueType = this.valueType != null ? this.valueType : this.targetValueType;
        return ValuesSourceConfig.resolve(context.getQueryShardContext(), valueType, this.field, this.script, this.missing, this.timeZone, this.format, this::resolveScriptAny);
    }

    protected abstract ValuesSourceAggregatorFactory<VS> innerBuild(SearchContext var1, ValuesSourceConfig<VS> var2, AggregatorFactory var3, AggregatorFactories.Builder var4) throws IOException;

    @Override
    public final XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.field != null) {
            builder.field("field", this.field);
        }
        if (this.script != null) {
            builder.field("script", this.script);
        }
        if (this.missing != null) {
            builder.field("missing", this.missing);
        }
        if (this.format != null) {
            builder.field("format", this.format);
        }
        if (this.timeZone != null) {
            builder.field("time_zone", this.timeZone.toString());
        }
        if (this.valueType != null) {
            builder.field("value_type", this.valueType.getPreferredName());
        }
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    protected abstract XContentBuilder doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.field, this.format, this.missing, this.script, this.targetValueType, this.timeZone, this.valueType, this.valuesSourceType);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ValuesSourceAggregationBuilder other = (ValuesSourceAggregationBuilder)obj;
        return Objects.equals(this.valuesSourceType, other.valuesSourceType) && Objects.equals(this.field, other.field) && Objects.equals(this.format, other.format) && Objects.equals(this.missing, other.missing) && Objects.equals(this.script, other.script) && Objects.equals(this.targetValueType, other.targetValueType) && Objects.equals(this.timeZone, other.timeZone) && Objects.equals(this.valueType, other.valueType);
    }

    public static abstract class LeafOnly<VS extends ValuesSource, AB extends ValuesSourceAggregationBuilder<VS, AB>>
    extends ValuesSourceAggregationBuilder<VS, AB> {
        protected LeafOnly(String name, ValuesSourceType valuesSourceType, ValueType targetValueType) {
            super(name, valuesSourceType, targetValueType);
        }

        protected LeafOnly(LeafOnly<VS, AB> clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
            super(clone, factoriesBuilder, metaData);
            if (factoriesBuilder.count() > 0) {
                throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.getType() + "] cannot accept sub-aggregations");
            }
        }

        protected LeafOnly(StreamInput in, ValuesSourceType valuesSourceType, ValueType targetValueType) throws IOException {
            super(in, valuesSourceType, targetValueType);
        }

        protected LeafOnly(StreamInput in, ValuesSourceType valuesSourceType) throws IOException {
            super(in, valuesSourceType);
        }

        @Override
        public final AB subAggregations(AggregatorFactories.Builder subFactories) {
            throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.getType() + "] cannot accept sub-aggregations");
        }
    }
}

