/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.LeaveGroupResponse;

public class LeaveGroupRequest
extends AbstractRequest {
    private static final String GROUP_ID_KEY_NAME = "group_id";
    private static final String MEMBER_ID_KEY_NAME = "member_id";
    private final String groupId;
    private final String memberId;

    private LeaveGroupRequest(String groupId, String memberId, short version) {
        super(version);
        this.groupId = groupId;
        this.memberId = memberId;
    }

    public LeaveGroupRequest(Struct struct, short version) {
        super(version);
        this.groupId = struct.getString(GROUP_ID_KEY_NAME);
        this.memberId = struct.getString(MEMBER_ID_KEY_NAME);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                return new LeaveGroupResponse(Errors.forException(e));
            }
            case 1: {
                return new LeaveGroupResponse(throttleTimeMs, Errors.forException(e));
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.LEAVE_GROUP.latestVersion()));
    }

    public String groupId() {
        return this.groupId;
    }

    public String memberId() {
        return this.memberId;
    }

    public static LeaveGroupRequest parse(ByteBuffer buffer, short version) {
        return new LeaveGroupRequest(ApiKeys.LEAVE_GROUP.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.LEAVE_GROUP.requestSchema(this.version()));
        struct.set(GROUP_ID_KEY_NAME, (Object)this.groupId);
        struct.set(MEMBER_ID_KEY_NAME, (Object)this.memberId);
        return struct;
    }

    public static class Builder
    extends AbstractRequest.Builder<LeaveGroupRequest> {
        private final String groupId;
        private final String memberId;

        public Builder(String groupId, String memberId) {
            super(ApiKeys.LEAVE_GROUP);
            this.groupId = groupId;
            this.memberId = memberId;
        }

        @Override
        public LeaveGroupRequest build(short version) {
            return new LeaveGroupRequest(this.groupId, this.memberId, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=LeaveGroupRequest").append(", groupId=").append(this.groupId).append(", memberId=").append(this.memberId).append(")");
            return bld.toString();
        }
    }
}

