/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.devutils.inspector;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.devutils.DevUtilsPage;
import org.apache.wicket.devutils.inspector.ApplicationView;
import org.apache.wicket.devutils.inspector.EnhancedPageView;
import org.apache.wicket.devutils.inspector.LiveSessionsPage;
import org.apache.wicket.devutils.inspector.SessionView;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.StringValueConversionException;

public final class InspectorPage
extends DevUtilsPage {
    private static final long serialVersionUID = 1L;

    public InspectorPage(PageParameters parameters) {
        this.add(new Component[]{new ApplicationView("application", Application.get())});
        this.add(new Component[]{new SessionView("session", Session.get())});
        IManageablePage page = null;
        try {
            int pageId = parameters.get("pageId").toInt();
            page = Session.get().getPageManager().getPage(pageId);
        }
        catch (StringValueConversionException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.add(new Component[]{new EnhancedPageView("page", (Page)page)});
        this.add(new Component[]{new Image("bug", (ResourceReference)new PackageResourceReference(InspectorPage.class, "bug.png"))});
        this.add(new Component[]{new BookmarkablePageLink("allsessions", LiveSessionsPage.class)});
        this.add(new Component[]{new Label("wicketVersion", this.getApplication().getFrameworkSettings().getVersion())});
    }

    public boolean isVersioned() {
        return false;
    }
}

