/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.factory;

import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.NodeFactory;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMDocType;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMEntityReference;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMInformationItem;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamedInformationItem;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.common.AxiomExceptionTranslator;
import org.apache.axiom.om.impl.common.AxiomSemantics;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.intf.AxiomAttribute;
import org.apache.axiom.om.impl.intf.AxiomCDATASection;
import org.apache.axiom.om.impl.intf.AxiomCharacterDataNode;
import org.apache.axiom.om.impl.intf.AxiomChildNode;
import org.apache.axiom.om.impl.intf.AxiomComment;
import org.apache.axiom.om.impl.intf.AxiomContainer;
import org.apache.axiom.om.impl.intf.AxiomDocType;
import org.apache.axiom.om.impl.intf.AxiomDocument;
import org.apache.axiom.om.impl.intf.AxiomElement;
import org.apache.axiom.om.impl.intf.AxiomEntityReference;
import org.apache.axiom.om.impl.intf.AxiomNamedInformationItem;
import org.apache.axiom.om.impl.intf.AxiomNamespaceDeclaration;
import org.apache.axiom.om.impl.intf.AxiomProcessingInstruction;
import org.apache.axiom.om.impl.intf.AxiomSourcedElement;
import org.apache.axiom.om.impl.intf.AxiomText;
import org.apache.axiom.om.impl.intf.TextContent;
import org.apache.axiom.om.impl.mixin.AxiomAttributeSupport;
import org.apache.axiom.om.impl.mixin.AxiomCommentSupport;
import org.apache.axiom.om.impl.mixin.AxiomContainerSupport;
import org.apache.axiom.om.impl.mixin.AxiomElementSupport;
import org.apache.axiom.om.impl.mixin.AxiomNamedInformationItemSupport;
import org.apache.axiom.om.impl.mixin.AxiomNamespaceDeclarationSupport;
import org.apache.axiom.om.impl.mixin.AxiomProcessingInstructionSupport;
import org.apache.axiom.om.impl.mixin.AxiomSourcedElementSupport;
import org.apache.axiom.util.xml.NSUtils;

public class OMFactoryImpl
implements OMFactory {
    private final OMMetaFactory metaFactory;
    private final NodeFactory nodeFactory;

    public OMFactoryImpl(OMMetaFactory metaFactory, NodeFactory nodeFactory) {
        this.metaFactory = metaFactory;
        this.nodeFactory = nodeFactory;
    }

    protected final <T extends CoreNode> T createNode(Class<T> type) {
        T node = this.nodeFactory.createNode(type);
        this.initNode((CoreNode)node);
        return node;
    }

    protected void initNode(CoreNode node) {
    }

    @Override
    public final OMMetaFactory getMetaFactory() {
        return this.metaFactory;
    }

    @Override
    public final OMNamespace createOMNamespace(String uri, String prefix) {
        return new OMNamespaceImpl(uri, prefix);
    }

    @Override
    public final OMDocument createOMDocument() {
        return this.createNode(AxiomDocument.class);
    }

    @Override
    public final OMDocType createOMDocType(OMContainer parent, String rootName, String publicId, String systemId, String internalSubset) {
        AxiomDocType node = this.createNode(AxiomDocType.class);
        node.coreSetRootName(rootName);
        node.coreSetPublicId(publicId);
        node.coreSetSystemId(systemId);
        node.coreSetInternalSubset(internalSubset);
        if (parent != null) {
            AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomContainerSupport$org_apache_axiom_om_impl_intf_AxiomContainer$addChild((AxiomContainer)parent, node);
        }
        return node;
    }

    private AxiomText createAxiomText(OMContainer parent, Object content, int type) {
        AxiomText node;
        switch (type) {
            case 4: {
                node = this.createNode(AxiomCharacterDataNode.class);
                break;
            }
            case 6: {
                AxiomCharacterDataNode cdata = this.createNode(AxiomCharacterDataNode.class);
                cdata.coreSetIgnorable(true);
                node = cdata;
                break;
            }
            case 12: {
                node = this.createNode(AxiomCDATASection.class);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid node type");
            }
        }
        if (parent != null) {
            AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomContainerSupport$org_apache_axiom_om_impl_intf_AxiomContainer$addChild((AxiomContainer)parent, node);
        }
        try {
            node.coreSetCharacterData(content, AxiomSemantics.INSTANCE);
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
        return node;
    }

    @Override
    public final OMText createOMText(String s, int type) {
        return this.createAxiomText(null, s, type);
    }

    @Override
    public final OMText createOMText(String s) {
        return this.createAxiomText(null, s, 4);
    }

    @Override
    public final OMText createOMText(OMContainer parent, String text, int type) {
        return this.createAxiomText(parent, text, type);
    }

    @Override
    public final OMText createOMText(OMContainer parent, String text) {
        return this.createAxiomText(parent, text, 4);
    }

    @Override
    public final OMText createOMText(OMContainer parent, char[] charArray, int type) {
        return this.createAxiomText(parent, new String(charArray), type);
    }

    @Override
    public final OMText createOMText(OMContainer parent, QName text, int type) {
        if (text == null) {
            throw new IllegalArgumentException("QName text arg cannot be null!");
        }
        OMNamespace ns = AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$handleNamespace((AxiomElement)parent, text.getNamespaceURI(), text.getPrefix());
        return this.createAxiomText(parent, ns == null ? text.getLocalPart() : String.valueOf(ns.getPrefix()) + ":" + text.getLocalPart(), type);
    }

    @Override
    public final OMText createOMText(OMContainer parent, QName text) {
        return this.createAxiomText(parent, text, 4);
    }

    @Override
    public final OMText createOMText(OMContainer parent, String s, String mimeType, boolean optimize) {
        return this.createAxiomText(parent, new TextContent(s, mimeType, optimize), 4);
    }

    @Override
    public final OMText createOMText(String s, String mimeType, boolean optimize) {
        return this.createOMText(null, s, mimeType, optimize);
    }

    @Override
    public final OMText createOMText(OMContainer parent, OMText source) {
        try {
            return (AxiomText)((AxiomText)source).coreClone(AxiomSemantics.CLONE_POLICY, null, (AxiomContainer)parent);
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final OMText createOMText(Object dataHandler, boolean optimize) {
        return this.createOMText((DataHandler)dataHandler, optimize);
    }

    @Override
    public final OMText createOMText(DataHandler dataHandler, boolean optimize) {
        return this.createAxiomText(null, new TextContent(null, dataHandler, optimize), 4);
    }

    @Override
    public final OMText createOMText(String contentID, DataHandlerProvider dataHandlerProvider, boolean optimize) {
        return this.createAxiomText(null, new TextContent(contentID, dataHandlerProvider, optimize), 4);
    }

    @Override
    public final OMProcessingInstruction createOMProcessingInstruction(OMContainer parent, String piTarget, String piData) {
        AxiomProcessingInstruction node = this.createNode(AxiomProcessingInstruction.class);
        node.coreSetTarget(piTarget);
        try {
            node.coreSetCharacterData(piData, AxiomSemantics.INSTANCE);
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
        if (parent != null) {
            AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomContainerSupport$org_apache_axiom_om_impl_intf_AxiomContainer$addChild((AxiomContainer)parent, node);
        }
        return node;
    }

    @Override
    public final OMEntityReference createOMEntityReference(OMContainer parent, String name) {
        AxiomEntityReference node = this.createNode(AxiomEntityReference.class);
        node.coreSetName(name);
        if (parent != null) {
            AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomContainerSupport$org_apache_axiom_om_impl_intf_AxiomContainer$addChild((AxiomContainer)parent, node);
        }
        return node;
    }

    @Override
    public final OMComment createOMComment(OMContainer parent, String content) {
        AxiomComment node = this.createNode(AxiomComment.class);
        try {
            node.coreSetCharacterData(content, AxiomSemantics.INSTANCE);
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
        if (parent != null) {
            AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomContainerSupport$org_apache_axiom_om_impl_intf_AxiomContainer$addChild((AxiomContainer)parent, node);
        }
        return node;
    }

    @Override
    public final OMElement createOMElement(String localName, OMNamespace ns) {
        return this.createOMElement(localName, ns, null);
    }

    protected final <T extends AxiomElement> T createAxiomElement(Class<T> type, OMContainer parent, String localName, OMNamespace ns) {
        AxiomElement element = (AxiomElement)this.createNode(type);
        if (parent != null) {
            AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomContainerSupport$org_apache_axiom_om_impl_intf_AxiomContainer$addChild((AxiomContainer)parent, element);
        }
        AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$initName(element, localName, ns, true);
        return (T)element;
    }

    @Override
    public final OMElement createOMElement(String localName, OMNamespace ns, OMContainer parent) {
        return this.createAxiomElement(AxiomElement.class, parent, localName, ns);
    }

    @Override
    public final OMElement createOMElement(QName qname, OMContainer parent) {
        AxiomElement element = this.createNode(AxiomElement.class);
        if (parent != null) {
            parent.addChild(element);
        }
        AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_intf_AxiomNamedInformationItem$internalSetLocalName(element, qname.getLocalPart());
        String prefix = qname.getPrefix();
        String namespaceURI = qname.getNamespaceURI();
        if (namespaceURI.length() > 0) {
            OMNamespace ns = AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$findNamespace(element, namespaceURI, prefix.length() == 0 ? null : prefix);
            if (ns == null) {
                if ("".equals(prefix)) {
                    prefix = NSUtils.generatePrefix(namespaceURI);
                }
                ns = AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$declareNamespace(element, namespaceURI, prefix);
            }
            AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_intf_AxiomNamedInformationItem$internalSetNamespace(element, ns);
        } else {
            if (prefix.length() > 0) {
                throw new IllegalArgumentException("Cannot create a prefixed element with an empty namespace name");
            }
            if (AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$getDefaultNamespace(element) != null) {
                AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$declareDefaultNamespace(element, "");
            }
            AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_intf_AxiomNamedInformationItem$internalSetNamespace(element, null);
        }
        return element;
    }

    @Override
    public final OMElement createOMElement(QName qname) {
        return this.createOMElement(qname, null);
    }

    @Override
    public final OMElement createOMElement(String localName, String namespaceURI, String prefix) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI must not be null");
        }
        if (namespaceURI.length() == 0) {
            if (prefix != null && prefix.length() > 0) {
                throw new IllegalArgumentException("Cannot create a prefixed element with an empty namespace name");
            }
            return this.createOMElement(localName, null);
        }
        return this.createOMElement(localName, this.createOMNamespace(namespaceURI, prefix));
    }

    @Override
    public final OMSourcedElement createOMElement(OMDataSource source) {
        AxiomSourcedElement element = this.createNode(AxiomSourcedElement.class);
        AxiomSourcedElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomSourcedElementSupport$org_apache_axiom_om_impl_intf_AxiomSourcedElement$init(element, source);
        return element;
    }

    @Override
    public final OMSourcedElement createOMElement(OMDataSource source, String localName, OMNamespace ns) {
        AxiomSourcedElement element = this.createNode(AxiomSourcedElement.class);
        AxiomSourcedElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomSourcedElementSupport$org_apache_axiom_om_impl_intf_AxiomSourcedElement$init(element, localName, ns, source);
        return element;
    }

    @Override
    public final OMSourcedElement createOMElement(OMDataSource source, QName qname) {
        AxiomSourcedElement element = this.createNode(AxiomSourcedElement.class);
        AxiomSourcedElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomSourcedElementSupport$org_apache_axiom_om_impl_intf_AxiomSourcedElement$init(element, qname, source);
        return element;
    }

    @Override
    public final OMAttribute createOMAttribute(String localName, OMNamespace ns, String value) {
        if (ns != null && ns.getPrefix() == null) {
            String namespaceURI = ns.getNamespaceURI();
            ns = namespaceURI.length() == 0 ? null : new OMNamespaceImpl(namespaceURI, NSUtils.generatePrefix(namespaceURI));
        }
        if (ns != null) {
            if (ns.getNamespaceURI().length() == 0) {
                if (ns.getPrefix().length() > 0) {
                    throw new IllegalArgumentException("Cannot create a prefixed attribute with an empty namespace name");
                }
                ns = null;
            } else if (ns.getPrefix().length() == 0) {
                throw new IllegalArgumentException("Cannot create an unprefixed attribute with a namespace");
            }
        }
        AxiomAttribute attr = this.createNode(AxiomAttribute.class);
        AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_intf_AxiomNamedInformationItem$internalSetLocalName(attr, localName);
        try {
            attr.coreSetCharacterData(value, AxiomSemantics.INSTANCE);
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
        AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_intf_AxiomNamedInformationItem$internalSetNamespace(attr, ns);
        attr.coreSetType("CDATA");
        return attr;
    }

    protected final <T extends AxiomElement> T importElement(OMElement element, Class<T> type) {
        AxiomElement importedElement = (AxiomElement)this.createNode(type);
        this.copyName(element, importedElement);
        Iterator<Object> it = element.getAllAttributes();
        while (it.hasNext()) {
            importedElement.coreAppendAttribute(this.importAttribute((OMAttribute)it.next()));
        }
        it = element.getAllDeclaredNamespaces();
        while (it.hasNext()) {
            OMNamespace ns = (OMNamespace)it.next();
            AxiomNamespaceDeclaration nsDecl = this.createNode(AxiomNamespaceDeclaration.class);
            AxiomNamespaceDeclarationSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomNamespaceDeclarationSupport$org_apache_axiom_om_impl_intf_AxiomNamespaceDeclaration$coreSetDeclaredNamespace(nsDecl, ns.getPrefix(), ns.getNamespaceURI());
            importedElement.coreAppendAttribute(nsDecl);
        }
        this.importChildren(element, importedElement);
        return (T)importedElement;
    }

    private AxiomChildNode importChildNode(OMNode child) {
        int type = child.getType();
        switch (type) {
            case 1: {
                return this.importElement((OMElement)child, AxiomElement.class);
            }
            case 4: 
            case 6: 
            case 12: {
                OMText text = (OMText)child;
                Object content = text.isBinary() ? new TextContent(text.getContentID(), text.getDataHandler(), text.isOptimized()) : text.getText();
                return this.createAxiomText(null, content, type);
            }
            case 3: {
                OMProcessingInstruction pi = (OMProcessingInstruction)child;
                AxiomProcessingInstruction importedPI = this.createNode(AxiomProcessingInstruction.class);
                AxiomProcessingInstructionSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomProcessingInstructionSupport$org_apache_axiom_om_impl_intf_AxiomProcessingInstruction$setTarget(importedPI, pi.getTarget());
                AxiomProcessingInstructionSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomProcessingInstructionSupport$org_apache_axiom_om_impl_intf_AxiomProcessingInstruction$setValue(importedPI, pi.getValue());
                return importedPI;
            }
            case 5: {
                OMComment comment = (OMComment)child;
                AxiomComment importedComment = this.createNode(AxiomComment.class);
                AxiomCommentSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomCommentSupport$org_apache_axiom_om_impl_intf_AxiomComment$setValue(importedComment, comment.getValue());
                return importedComment;
            }
            case 11: {
                OMDocType docType = (OMDocType)child;
                AxiomDocType importedDocType = this.createNode(AxiomDocType.class);
                importedDocType.coreSetRootName(docType.getRootName());
                importedDocType.coreSetPublicId(docType.getPublicId());
                importedDocType.coreSetSystemId(docType.getSystemId());
                importedDocType.coreSetInternalSubset(docType.getInternalSubset());
                return importedDocType;
            }
            case 9: {
                AxiomEntityReference importedEntityRef = this.createNode(AxiomEntityReference.class);
                importedEntityRef.coreSetName(((OMEntityReference)child).getName());
                return importedEntityRef;
            }
        }
        throw new IllegalArgumentException("Unsupported node type");
    }

    private void copyName(OMNamedInformationItem node, AxiomNamedInformationItem importedNode) {
        AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_intf_AxiomNamedInformationItem$internalSetNamespace(importedNode, node.getNamespace());
        AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_intf_AxiomNamedInformationItem$internalSetLocalName(importedNode, node.getLocalName());
    }

    private void importChildren(OMContainer node, AxiomContainer importedNode) {
        OMNode child = node.getFirstOMChild();
        while (child != null) {
            try {
                importedNode.coreAppendChild(this.importChildNode(child));
            }
            catch (CoreModelException ex) {
                throw AxiomExceptionTranslator.translate(ex);
            }
            child = child.getNextOMSibling();
        }
    }

    private AxiomAttribute importAttribute(OMAttribute attribute) {
        AxiomAttribute importedAttribute = this.createNode(AxiomAttribute.class);
        this.copyName(attribute, importedAttribute);
        AxiomAttributeSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_mixin_AxiomAttributeSupport$org_apache_axiom_om_impl_intf_AxiomAttribute$setAttributeValue(importedAttribute, attribute.getAttributeValue());
        return importedAttribute;
    }

    @Override
    public final OMInformationItem importInformationItem(OMInformationItem node) {
        if (node instanceof OMNode) {
            return this.importChildNode((OMNode)node);
        }
        if (node instanceof OMDocument) {
            OMDocument document = (OMDocument)node;
            AxiomDocument importedDocument = this.createNode(AxiomDocument.class);
            this.importChildren(document, importedDocument);
            return importedDocument;
        }
        if (node instanceof OMAttribute) {
            return this.importAttribute((OMAttribute)node);
        }
        throw new IllegalArgumentException("Unsupported node type");
    }
}

