/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.EnumSet;
import org.w3c.tidy.HtmlVersion;
import org.w3c.tidy.Parser;
import org.w3c.tidy.TagCheck;

public class Dict {
    public static final int CM_UNKNOWN = 0;
    public static final int CM_EMPTY = 1;
    public static final int CM_HTML = 2;
    public static final int CM_HEAD = 4;
    public static final int CM_BLOCK = 8;
    public static final int CM_INLINE = 16;
    public static final int CM_LIST = 32;
    public static final int CM_DEFLIST = 64;
    public static final int CM_TABLE = 128;
    public static final int CM_ROWGRP = 256;
    public static final int CM_ROW = 512;
    public static final int CM_FIELD = 1024;
    public static final int CM_OBJECT = 2048;
    public static final int CM_PARAM = 4096;
    public static final int CM_FRAMES = 8192;
    public static final int CM_HEADING = 16384;
    public static final int CM_OPT = 32768;
    public static final int CM_IMG = 65536;
    public static final int CM_MIXED = 131072;
    public static final int CM_NO_INDENT = 262144;
    public static final int CM_OBSOLETE = 524288;
    public static final int CM_NEW = 0x100000;
    public static final int CM_OMITST = 0x200000;
    public static final EnumSet<HtmlVersion> VERS_UNKNOWN = EnumSet.of(HtmlVersion.UNKNOWN);
    public static final EnumSet<HtmlVersion> VERS_HTML20 = EnumSet.of(HtmlVersion.HTML20);
    public static final EnumSet<HtmlVersion> NOT_HTML20 = Dict.allExcept(VERS_HTML20);
    public static final EnumSet<HtmlVersion> VERS_HTML32 = EnumSet.of(HtmlVersion.HTML32);
    public static final EnumSet<HtmlVersion> VERS_HTML40_STRICT = EnumSet.of(HtmlVersion.HTML40_STRICT);
    public static final EnumSet<HtmlVersion> NOT_HTML40_STRICT = Dict.without(EnumSet.allOf(HtmlVersion.class), VERS_HTML40_STRICT);
    public static final EnumSet<HtmlVersion> VERS_HTML40_LOOSE = EnumSet.of(HtmlVersion.HTML40_LOOSE);
    public static final EnumSet<HtmlVersion> VERS_FRAMESET = EnumSet.of(HtmlVersion.FRAMESET);
    public static final EnumSet<HtmlVersion> NOT_FRAMESET = Dict.allExcept(VERS_FRAMESET);
    public static final EnumSet<HtmlVersion> VERS_XML = EnumSet.of(HtmlVersion.XML);
    public static final EnumSet<HtmlVersion> VERS_NETSCAPE = EnumSet.of(HtmlVersion.NETSCAPE);
    public static final EnumSet<HtmlVersion> VERS_MICROSOFT = EnumSet.of(HtmlVersion.MICROSOFT);
    public static final EnumSet<HtmlVersion> VERS_SUN = EnumSet.of(HtmlVersion.SUN);
    public static final EnumSet<HtmlVersion> VERS_MALFORMED = EnumSet.of(HtmlVersion.MALFORMED);
    public static final EnumSet<HtmlVersion> VERS_XHTML11 = EnumSet.of(HtmlVersion.XHTML11);
    public static final EnumSet<HtmlVersion> NOT_XHTML11 = Dict.allExcept(VERS_XHTML11);
    public static final EnumSet<HtmlVersion> VERS_BASIC = EnumSet.of(HtmlVersion.BASIC);
    public static final EnumSet<HtmlVersion> VERS_HTML5 = EnumSet.of(HtmlVersion.HTML5);
    public static final EnumSet<HtmlVersion> VERS_PROPRIETARY = EnumSet.of(HtmlVersion.NETSCAPE, HtmlVersion.MICROSOFT, HtmlVersion.SUN);
    public static final EnumSet<HtmlVersion> VERS_HTML40 = EnumSet.of(HtmlVersion.HTML5, HtmlVersion.HTML40_STRICT, HtmlVersion.HTML40_LOOSE, HtmlVersion.FRAMESET);
    public static final EnumSet<HtmlVersion> VERS_LOOSE = EnumSet.of(HtmlVersion.HTML32, HtmlVersion.HTML40_LOOSE, HtmlVersion.FRAMESET);
    public static final EnumSet<HtmlVersion> VERS_IFRAME = EnumSet.of(HtmlVersion.HTML40_LOOSE, HtmlVersion.FRAMESET);
    public static final EnumSet<HtmlVersion> VERS_FROM32 = Dict.combine(VERS_LOOSE, (Enum[])new HtmlVersion[]{HtmlVersion.HTML5, HtmlVersion.HTML40_STRICT});
    public static final EnumSet<HtmlVersion> VERS_EVENTS = Dict.combine(VERS_HTML40, (Enum[])new HtmlVersion[]{HtmlVersion.XHTML11});
    public static final EnumSet<HtmlVersion> VERS_ALL = Dict.combine(VERS_HTML40, (Enum[])new HtmlVersion[]{HtmlVersion.HTML20, HtmlVersion.HTML32, HtmlVersion.XHTML11, HtmlVersion.BASIC});
    public static final short TAGTYPE_EMPTY = 1;
    public static final short TAGTYPE_INLINE = 2;
    public static final short TAGTYPE_BLOCK = 4;
    public static final short TAGTYPE_PRE = 8;
    protected String name;
    protected EnumSet<HtmlVersion> versions;
    protected int model;
    private Parser parser;
    private TagCheck chkattrs;

    public Dict(String name, EnumSet<HtmlVersion> versions, int model, Parser parser, TagCheck chkattrs) {
        this.name = name;
        this.versions = versions;
        this.model = model;
        this.parser = parser;
        this.chkattrs = chkattrs;
    }

    public static EnumSet<HtmlVersion> allExcept(EnumSet<HtmlVersion> except) {
        EnumSet<HtmlVersion> result = EnumSet.allOf(HtmlVersion.class);
        result.removeAll(except);
        return result;
    }

    @SafeVarargs
    public static <T extends Enum<T>> EnumSet<T> combine(EnumSet<T> set, T ... others) {
        Object result = set.clone();
        ((AbstractCollection)result).addAll(Arrays.asList(others));
        return result;
    }

    public static <T extends Enum<T>> EnumSet<T> combine(EnumSet<T> set1, EnumSet<T> set2) {
        Object result = set1.clone();
        ((AbstractCollection)result).addAll(set2);
        return result;
    }

    @SafeVarargs
    public static <T extends Enum<T>> EnumSet<T> combine(EnumSet<T> ... sets) {
        Object result = sets[0].clone();
        int cnt = sets.length;
        for (int n = 1; n < cnt; ++n) {
            ((AbstractCollection)result).addAll(sets[n]);
        }
        return result;
    }

    public TagCheck getChkattrs() {
        return this.chkattrs;
    }

    public int getModel() {
        return this.model;
    }

    public String getName() {
        return this.name;
    }

    public Parser getParser() {
        return this.parser;
    }

    public void setChkattrs(TagCheck chkattrs) {
        this.chkattrs = chkattrs;
    }

    public EnumSet<HtmlVersion> getVersions() {
        return this.versions;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    public static EnumSet<HtmlVersion> without(EnumSet<HtmlVersion> set, EnumSet<HtmlVersion> excluded) {
        Object result = set.clone();
        ((AbstractSet)result).removeAll(excluded);
        return result;
    }
}

