// SPDX-License-Identifier: BSD-3-Clause
/*
 * Copyright (c) 2023, Linaro Ltd.
 * Copyright (c) 2025, Luca Weiss
 */

#include <sys/mman.h>
#include <err.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "debugcc.h"

static struct gcc_mux gcc = {
	.mux = {
		.phys =	0xfc400000,
		.size = 0x10000,

		.measure = measure_gcc,

		.enable_reg = 0x1880,
		.enable_mask = BIT(16),

		.mux_reg = 0x1880,
		.mux_mask = 0x1ff,

		.div_reg = 0x1880,
		.div_mask = 0xf000,
		.div_val = 1,
	},

	.xo_div4_reg = 0x10c8,
	.debug_ctl_reg = 0x1884,
	.debug_status_reg = 0x1888,
};

static struct debug_mux mmss = {
	.phys = 0xfd8c0000,
	.size = 0x40000,
	.block_name = "mmss",

	.measure = measure_leaf,
	.parent = &gcc.mux,
	.parent_mux_val = 0x2c,

	.enable_reg = 0x0900,
	.enable_mask = BIT(16),

	.mux_reg = 0x0900,
	.mux_mask = 0xfff,
};

static struct debug_mux lpass = {
	.phys = 0xfe000000,
	.size = 0x36000,
	.block_name = "lpass",

	.measure = measure_leaf,
	.parent = &gcc.mux,
	.parent_mux_val = 0x161,

	.enable_reg = 0x29000,
	.enable_mask = BIT(20),

	.mux_reg = 0x29000,
	.mux_mask = 0xffff,
};

static struct measure_clk msm8974_clocks[] = {
	/* GCC entries */
	{ "gcc_pdm_ahb_clk", &gcc.mux, 0x00d0 },
	{ "gcc_blsp2_qup1_i2c_apps_clk", &gcc.mux, 0x00ab },
	{ "gcc_blsp2_qup3_spi_apps_clk", &gcc.mux, 0x00b3 },
	{ "gcc_blsp2_uart5_apps_clk", &gcc.mux, 0x00be },
	{ "gcc_usb30_master_clk", &gcc.mux, 0x0050 },
	{ "gcc_blsp2_qup3_i2c_apps_clk", &gcc.mux, 0x00b4 },
	{ "gcc_usb_hsic_system_clk", &gcc.mux, 0x0059 },
	{ "gcc_sdcc1_cdccal_sleep_clk", &gcc.mux, 0x006a },
	{ "gcc_sdcc1_cdccal_ff_clk", &gcc.mux, 0x006b },
	{ "gcc_blsp2_uart3_apps_clk", &gcc.mux, 0x00b5 },
	{ "gcc_usb_hsic_io_cal_clk", &gcc.mux, 0x005b },
	{ "gcc_ce2_axi_clk", &gcc.mux, 0x0141 },
	{ "gcc_sdcc3_ahb_clk", &gcc.mux, 0x0079 },
	{ "gcc_blsp1_qup5_i2c_apps_clk", &gcc.mux, 0x009d },
	{ "gcc_blsp1_qup1_spi_apps_clk", &gcc.mux, 0x008a },
	{ "gcc_blsp2_uart4_apps_clk", &gcc.mux, 0x00ba },
	{ "gcc_ce2_clk", &gcc.mux, 0x0140 },
	{ "gcc_blsp1_uart2_apps_clk", &gcc.mux, 0x0091 },
	{ "gcc_sdcc1_ahb_clk", &gcc.mux, 0x0069 },
	{ "gcc_mss_cfg_ahb_clk", &gcc.mux, 0x0030 },
	{ "gcc_tsif_ahb_clk", &gcc.mux, 0x00e8 },
	{ "gcc_sdcc4_ahb_clk", &gcc.mux, 0x0081 },
	{ "gcc_blsp1_qup4_spi_apps_clk", &gcc.mux, 0x0098 },
	{ "gcc_blsp2_qup4_spi_apps_clk", &gcc.mux, 0x00b8 },
	{ "gcc_blsp1_qup3_spi_apps_clk", &gcc.mux, 0x0093 },
	{ "gcc_blsp1_qup6_i2c_apps_clk", &gcc.mux, 0x00a2 },
	{ "gcc_blsp2_qup6_i2c_apps_clk", &gcc.mux, 0x00c2 },
	{ "gcc_bam_dma_ahb_clk", &gcc.mux, 0x00e0 },
	{ "gcc_sdcc3_apps_clk", &gcc.mux, 0x0078 },
	{ "gcc_usb_hs_system_clk", &gcc.mux, 0x0060 },
	{ "gcc_blsp1_ahb_clk", &gcc.mux, 0x0088 },
	{ "gcc_sdcc1_apps_clk", &gcc.mux, 0x0068 },
	{ "gcc_blsp2_qup5_i2c_apps_clk", &gcc.mux, 0x00bd },
	{ "gcc_blsp1_uart4_apps_clk", &gcc.mux, 0x009a },
	{ "gcc_blsp2_qup2_spi_apps_clk", &gcc.mux, 0x00ae },
	{ "gcc_blsp2_qup6_spi_apps_clk", &gcc.mux, 0x00c1 },
	{ "gcc_blsp2_uart2_apps_clk", &gcc.mux, 0x00b1 },
	{ "gcc_blsp1_qup2_spi_apps_clk", &gcc.mux, 0x008e },
	{ "gcc_usb_hsic_ahb_clk", &gcc.mux, 0x0058 },
	{ "gcc_blsp1_uart3_apps_clk", &gcc.mux, 0x0095 },
	{ "gcc_usb30_mock_utmi_clk", &gcc.mux, 0x0052 },
	{ "gcc_ce1_axi_clk", &gcc.mux, 0x0139 },
	{ "gcc_sdcc4_apps_clk", &gcc.mux, 0x0080 },
	{ "gcc_blsp1_qup5_spi_apps_clk", &gcc.mux, 0x009c },
	{ "gcc_usb_hs_ahb_clk", &gcc.mux, 0x0061 },
	{ "gcc_blsp1_qup6_spi_apps_clk", &gcc.mux, 0x00a1 },
	{ "gcc_blsp2_qup2_i2c_apps_clk", &gcc.mux, 0x00b0 },
	{ "gcc_prng_ahb_clk", &gcc.mux, 0x00d8 },
	{ "gcc_blsp1_qup3_i2c_apps_clk", &gcc.mux, 0x0094 },
	{ "gcc_usb_hsic_clk", &gcc.mux, 0x005a },
	{ "gcc_blsp1_uart6_apps_clk", &gcc.mux, 0x00a3 },
	{ "gcc_sdcc2_apps_clk", &gcc.mux, 0x0070 },
	{ "gcc_tsif_ref_clk", &gcc.mux, 0x00e9 },
	{ "gcc_blsp1_uart1_apps_clk", &gcc.mux, 0x008c },
	{ "gcc_blsp2_qup5_spi_apps_clk", &gcc.mux, 0x00bc },
	{ "gcc_blsp1_qup4_i2c_apps_clk", &gcc.mux, 0x0099 },
	{ "gcc_mmss_noc_cfg_ahb_clk", &gcc.mux, 0x002a },
	{ "gcc_blsp2_ahb_clk", &gcc.mux, 0x00a8 },
	{ "gcc_boot_rom_ahb_clk", &gcc.mux, 0x00f8 },
	{ "gcc_ce1_ahb_clk", &gcc.mux, 0x013a },
	{ "gcc_pdm2_clk", &gcc.mux, 0x00d2 },
	{ "gcc_blsp2_qup4_i2c_apps_clk", &gcc.mux, 0x00b9 },
	{ "gcc_ce2_ahb_clk", &gcc.mux, 0x0142 },
	{ "gcc_blsp1_uart5_apps_clk", &gcc.mux, 0x009e },
	{ "gcc_blsp2_qup1_spi_apps_clk", &gcc.mux, 0x00aa },
	{ "gcc_blsp1_qup2_i2c_apps_clk", &gcc.mux, 0x0090 },
	{ "gcc_blsp2_uart1_apps_clk", &gcc.mux, 0x00ac },
	{ "gcc_blsp1_qup1_i2c_apps_clk", &gcc.mux, 0x008b },
	{ "gcc_blsp2_uart6_apps_clk", &gcc.mux, 0x00c3 },
	{ "gcc_sdcc2_ahb_clk", &gcc.mux, 0x0071 },
	{ "gcc_usb30_sleep_clk", &gcc.mux, 0x0051 },
	{ "gcc_usb2a_phy_sleep_clk", &gcc.mux, 0x0063 },
	{ "gcc_usb2b_phy_sleep_clk", &gcc.mux, 0x0064 },
	{ "gcc_sys_noc_usb3_axi_clk", &gcc.mux, 0x0001 },
	{ "gcc_ocmem_noc_cfg_ahb_clk", &gcc.mux, 0x0029 },
	{ "gcc_ce1_clk", &gcc.mux, 0x0138 },
	{ "gcc_lpass_q6_axi_clk", &gcc.mux, 0x0160 },
	{ "gcc_mss_q6_bimc_axi_clk", &gcc.mux, 0x0031 },
	{ "cnoc_clk", &gcc.mux, 0x0008 },
	{ "pnoc_clk", &gcc.mux, 0x0010 },
	{ "snoc_clk", &gcc.mux, 0x0000 },
	{ "bimc_clk", &gcc.mux, 0x0155 },
	{ "wcnss_m_clk", &gcc.mux, 0x0198 },
	/* MMSS entries */
	{ "mmss_mmssnoc_axi_clk", &mmss, 0x0004 },
	{ "ocmemnoc_clk", &mmss, 0x0007 },
	{ "ocmemcx_ocmemnoc_clk", &mmss, 0x0009 },
	{ "camss_cci_cci_ahb_clk", &mmss, 0x002e },
	{ "camss_cci_cci_clk", &mmss, 0x002d },
	{ "camss_csi0_ahb_clk", &mmss, 0x0042 },
	{ "camss_csi0_clk", &mmss, 0x0041 },
	{ "camss_csi0phy_clk", &mmss, 0x0043 },
	{ "camss_csi0pix_clk", &mmss, 0x0045 },
	{ "camss_csi0rdi_clk", &mmss, 0x0044 },
	{ "camss_csi1_ahb_clk", &mmss, 0x0047 },
	{ "camss_csi1_clk", &mmss, 0x0046 },
	{ "camss_csi1phy_clk", &mmss, 0x0048 },
	{ "camss_csi1pix_clk", &mmss, 0x004a },
	{ "camss_csi1rdi_clk", &mmss, 0x0049 },
	{ "camss_csi2_ahb_clk", &mmss, 0x004c },
	{ "camss_csi2_clk", &mmss, 0x004b },
	{ "camss_csi2phy_clk", &mmss, 0x004d },
	{ "camss_csi2pix_clk", &mmss, 0x004f },
	{ "camss_csi2rdi_clk", &mmss, 0x004e },
	{ "camss_csi3_ahb_clk", &mmss, 0x0051 },
	{ "camss_csi3_clk", &mmss, 0x0050 },
	{ "camss_csi3phy_clk", &mmss, 0x0052 },
	{ "camss_csi3pix_clk", &mmss, 0x0054 },
	{ "camss_csi3rdi_clk", &mmss, 0x0053 },
	{ "camss_csi_vfe0_clk", &mmss, 0x003f },
	{ "camss_csi_vfe1_clk", &mmss, 0x0040 },
	{ "camss_gp0_clk", &mmss, 0x0027 },
	{ "camss_gp1_clk", &mmss, 0x0028 },
	{ "camss_ispif_ahb_clk", &mmss, 0x0055 },
	{ "camss_jpeg_jpeg0_clk", &mmss, 0x0032 },
	{ "camss_jpeg_jpeg1_clk", &mmss, 0x0033 },
	{ "camss_jpeg_jpeg2_clk", &mmss, 0x0034 },
	{ "camss_jpeg_jpeg_ahb_clk", &mmss, 0x0035 },
	{ "camss_jpeg_jpeg_axi_clk", &mmss, 0x0036 },
	{ "camss_jpeg_jpeg_ocmemnoc_clk", &mmss, 0x0037 },
	{ "camss_mclk0_clk", &mmss, 0x0029 },
	{ "camss_mclk1_clk", &mmss, 0x002a },
	{ "camss_mclk2_clk", &mmss, 0x002b },
	{ "camss_mclk3_clk", &mmss, 0x002c },
	{ "camss_micro_ahb_clk", &mmss, 0x0026 },
	{ "camss_phy0_csi0phytimer_clk", &mmss, 0x002f },
	{ "camss_phy1_csi1phytimer_clk", &mmss, 0x0030 },
	{ "camss_phy2_csi2phytimer_clk", &mmss, 0x0031 },
	{ "camss_top_ahb_clk", &mmss, 0x0025 },
	{ "camss_vfe_cpp_ahb_clk", &mmss, 0x003b },
	{ "camss_vfe_cpp_clk", &mmss, 0x003a },
	{ "camss_vfe_vfe0_clk", &mmss, 0x0038 },
	{ "camss_vfe_vfe1_clk", &mmss, 0x0039 },
	{ "camss_vfe_vfe_ahb_clk", &mmss, 0x003c },
	{ "camss_vfe_vfe_axi_clk", &mmss, 0x003d },
	{ "camss_vfe_vfe_ocmemnoc_clk", &mmss, 0x003e },
	{ "oxilicx_axi_clk", &mmss, 0x000b },
	{ "oxilicx_ahb_clk", &mmss, 0x000c },
	{ "oxili_gfx3d_clk", &mmss, 0x000d },
	{ "venus0_axi_clk", &mmss, 0x000f },
	{ "venus0_ocmemnoc_clk", &mmss, 0x0010 },
	{ "venus0_ahb_clk", &mmss, 0x0011 },
	{ "venus0_vcodec0_clk", &mmss, 0x000e },
	{ "mmss_s0_axi_clk", &mmss, 0x0005 },
	{ "mmssnoc_ahb_clk", &mmss, 0x0001 },
	{ "mdss_ahb_clk", &mmss, 0x0022 },
	{ "mdss_hdmi_clk", &mmss, 0x001d },
	{ "mdss_mdp_clk", &mmss, 0x0014 },
	{ "mdss_mdp_lut_clk", &mmss, 0x0015 },
	{ "mdss_axi_clk", &mmss, 0x0024 },
	{ "mdss_vsync_clk", &mmss, 0x001c },
	{ "mdss_esc0_clk", &mmss, 0x0020 },
	{ "mdss_esc1_clk", &mmss, 0x0021 },
	{ "mdss_edpaux_clk", &mmss, 0x001b },
	{ "mdss_byte0_clk", &mmss, 0x001e },
	{ "mdss_byte1_clk", &mmss, 0x001f },
	{ "mdss_edplink_clk", &mmss, 0x001a },
	{ "mdss_edppixel_clk", &mmss, 0x0019 },
	{ "mdss_extpclk_clk", &mmss, 0x0018 },
	{ "mdss_hdmi_ahb_clk", &mmss, 0x0023 },
	{ "mdss_pclk0_clk", &mmss, 0x0016 },
	{ "mdss_pclk1_clk", &mmss, 0x0017 },
	/* LPASS entries */
	{ "q6ss_xo_clk", &lpass, 0x002b },
	{ "q6ss_ahb_lfabif_clk", &lpass, 0x001e },
	{ "q6ss_ahbm_clk", &lpass, 0x001d },
	{}
};

struct debugcc_platform msm8974_debugcc = {
	"msm8974",
	msm8974_clocks,
};
