//start of MethodUtil.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * MethodUtil.java
 * 
 * Copyright (C) 2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.lang.reflect;

//import classes and interfaces
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

//import exceptions
import java.lang.ClassNotFoundException;
import java.lang.NoSuchMethodException;
import java.lang.reflect.InvocationTargetException;

/**
 * \bhɊւ郆[eBeBNXB
 * 
 * <pre>
 * -- revision history --
 * $Log: MethodUtil.java,v $
 * Revision 1.0  2002/10/01 00:00:00  dangan
 * first edition
 * add to version control
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.0 $
 */
public class MethodUtil{


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  private MethodUtil()
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gpsB
     */
    private MethodUtil(){  }


    //------------------------------------------------------------------
	//	shared method
    //------------------------------------------------------------------
    //  invoke static method
    //------------------------------------------------------------------
    //  public static Object invoke( Object obj, String name, Object[] args )
    //------------------------------------------------------------------
    /**
     * CX^Xobj nameƂO
     * \bhargsƂĎsB
     * 
     * @param obj  CX^X
     * @param name \bh
     * @param args ̔z
     * 
     * @return ߂l
     * 
     * @exception InvocationTargetException
     *                 RXgN^ŗOꍇ
     * 
     * @exception NoSuchMethodException
     *                 args Ɏ name ƂO
     *                 CX^X\bhȂꍇB
     */
    public static Object invoke( Object obj, String name, Object[] args ) 
                                              throws InvocationTargetException,
                                                     NoSuchMethodException {
        Class  type   = obj.getClass();
        Method method = MethodUtil.getMatchFullInstanceMethod( type, name, args );

        if( method == null ){
            method    = MethodUtil.getInstanceMethod( type, name, args );

            if( method != null )
                args      = Type.parseAll( method.getParameterTypes(), args );
        }

        if( method != null ){
            try{
                return method.invoke( obj, args );
            }catch( IllegalAccessException exception ){
                throw new IllegalAccessError( exception.toString() );
            }
        }else{
            throw new NoSuchMethodException();
        }
    }


    //------------------------------------------------------------------
	//	shared method
    //------------------------------------------------------------------
    //  invoke static method
    //------------------------------------------------------------------
    //  public static Object invokeStatic( String classname, String name, Object[] args )
    //  public static Object invokeStatic( Class type, String name, Object[] args )
    //------------------------------------------------------------------
    /**
     * classname ŎNX nameƂO
     * static \bhargsƂĎsB
     * 
     * @param classname NX
     * @param name      \bh
     * @param args      ̔z
     * 
     * @return ߂l
     * 
     * @exception ClassNotFoundException
     *                 classname ̃NXȂꍇ
     * 
     * @exception InvocationTargetException
     *                 RXgN^ŗOꍇ
     * 
     * @exception NoSuchMethodException
     *                 args Ɏ name ƂO
     *                 CX^X\bhȂꍇB
     */
    public static Object invokeStatic( String   classname, 
                                       String   name, 
                                       Object[] args ) 
                                              throws ClassNotFoundException,
                                                     InvocationTargetException,
                                                     NoSuchMethodException {
        return MethodUtil.invokeStatic( Class.forName( classname ),             //throw ClassNotFoundException
                                        name, 
                                        args );                                 //throw InvocationTargetException, NoSuchMethodException
    }

    /**
     * type ŎNX nameƂO
     * static \bhargsƂĎsB
     * 
     * @param type ^
     * @param name \bh
     * @param args ̔z
     * 
     * @return ߂l
     * 
     * @exception InvocationTargetException
     *                 RXgN^ŗOꍇ
     * 
     * @exception NoSuchMethodException
     *                 args Ɏ name ƂO
     *                 CX^X\bhȂꍇB
     */
    public static Object invokeStatic( Class type, String name, Object[] args ) 
                                              throws InvocationTargetException,
                                                     NoSuchMethodException {
        Method method = MethodUtil.getMatchFullStaticMethod( type, name, args );

        if( method == null ){
            method    = MethodUtil.getStaticMethod( type, name, args );

            if( method != null )
                args      = Type.parseAll( method.getParameterTypes(), args );
        }

        if( method != null ){
            try{
                return method.invoke( null, args );
            }catch( IllegalAccessException exception ){
                throw new IllegalAccessError( exception.toString() );
            }
        }else{
            throw new NoSuchMethodException();
        }
    }


    //------------------------------------------------------------------
	//	shared method
    //------------------------------------------------------------------
    //  get instance method
    //------------------------------------------------------------------
    //  public static Method getInstanceMethod( String classname, 
    //                                          String name, Object[] args )
    //  public static Method getInstanceMethod( Class  type,
    //                                          String name, Object[] args )
    //  public static Method getInstanceMethod( String classname, String  name, 
    //                                          Object[] args,    boolean all )
    //  public static Method getInstanceMethod( Class  type,      String name, 
    //                                          Object[] args,    boolean all )
    //------------------------------------------------------------------
    /**
     * classname ŎNX public ȃCX^X\bĥA
     * name ƂO args  Type.parse 
     * 󂯓邱Ƃł̂𓾂B
     * 
     * @param classname NXB
     * @param name      郁\bhB
     * @param args      zB
     *                  null ܂߂ĂǂAnull gpꍇ
     *                  Object ̃TuNXłΑSă}b`Ă܂߁A
     *                  ړĨ\bhȊÔ̂\B
     * 
     * @return args Ɏ邱Ƃł nameƂO \bhB
     *         Ȃ nullB
     * 
     * @exception ClassNotFoundException
     *                 classname ŎNX݂Ȃꍇ
     */
    public static Method getInstanceMethod( String   classname,
                                            String   name,
                                            Object[] args ) 
                                                throws  ClassNotFoundException {
        return MethodUtil.getInstanceMethod( Class.forName( classname ),
                                             name,
                                             args,
                                             false );
    }

    /**
     * type  public ȃCX^X\bĥA
     * name ƂO args  Type.parse 
     * 󂯓邱Ƃł̂𓾂B
     * 
     * @param type ^B
     * @param name 郁\bhB
     * @param args zB
     *             null ܂߂ĂǂAnull gpꍇ
     *             Object ̃TuNXłΑSă}b`Ă܂߁A
     *             ړĨ\bhȊÔ̂\B
     * 
     * @return args Ɏ邱Ƃł nameƂO \bhB
     *         Ȃ nullB
     */
    public static Method getInstanceMethod( Class    type,
                                            String   name,
                                            Object[] args ){
        return MethodUtil.getInstanceMethod( type, name, args, false );
    }

    /**
     * classname ŎNX CX^X\bĥA
     * name ƂO args  Type.parse 
     * 󂯓邱Ƃł̂𓾂B
     * 
     * @param classname NXB
     * @param name      郁\bhB
     * @param args      zB
     *                  null ܂߂ĂǂAnull gpꍇ
     *                  Object ̃TuNXłΑSă}b`Ă܂߁A
     *                  ړĨ\bhȊÔ̂\B
     * @param all       public ̃\bĥ݂Ȃ falseB
     *                  public, protected, private, pbP[WvCx[g
     *                  SẴ\bhȂ trueB
     * 
     * @return args Ɏ邱Ƃł nameƂO \bhB
     *         Ȃ nullB
     * 
     * @exception ClassNotFoundException
     *                 classname ŎNX݂Ȃꍇ
     */
    public static Method getInstanceMethod( String   classname,
                                            String   name,
                                            Object[] args,
                                            boolean  all ) 
                                                throws  ClassNotFoundException {
        return MethodUtil.getInstanceMethod( Class.forName( classname ),
                                             name,
                                             args,
                                             all );
    }

    /**
     * type  CX^X\bĥAname ƂO args 
     * Type.parse  󂯓邱Ƃł̂𓾂B
     * 
     * @param type ^B 
     * @param name 郁\bhB
     * @param args zB
     *             null ܂߂ĂǂAnull gpꍇ
     *             Object ̃TuNXłΑSă}b`Ă܂߁A
     *             ړĨ\bhȊÔ̂\B
     * @param all  public ̃\bĥ݂Ȃ falseB
     *             public, protected, private, pbP[WvCx[g
     *             SẴ\bhȂ trueB
     * 
     * @return args Ɏ邱Ƃł nameƂO \bhB
     *         Ȃ nullB
     */
    public static Method getInstanceMethod( Class    type,
                                            String   name,
                                            Object[] args,
                                            boolean  all ){
        Method[] methods = all 
                         ? type.getDeclaredMethods()
                         : type.getMethods();

        for( int i = 0 ; i < methods.length ; i++ )
            if( methods[i].getName().equals( name )
             && !Modifier.isStatic( methods[i].getModifiers() )
             && Type.matchFullAll( methods[i].getParameterTypes(), args ) )
                return methods[i];

        for( int i = 0 ; i < methods.length ; i++ )
            if( methods[i].getName().equals( name )
             && !Modifier.isStatic( methods[i].getModifiers() )
             && Type.matchRestrictAll( methods[i].getParameterTypes(), args ) )
                return methods[i];

        for( int i = 0 ; i < methods.length ; i++ )
            if( methods[i].getName().equals( name )
             && !Modifier.isStatic( methods[i].getModifiers() )
             && Type.matchAll( methods[i].getParameterTypes(), args ) )
                return methods[i];
        
        return null;
    }


    //------------------------------------------------------------------
	//	shared method
    //------------------------------------------------------------------
    //  get match full instance method
    //------------------------------------------------------------------
    //  public static Method getMatchFullInstanceMethod( String classname, 
    //                                    String name, Object[] args )
    //  public static Method getMatchFullInstanceMethod( Class  type,
    //                                    String name, Object[] args )
    //  public static Method getMatchFullInstanceMethod( String classname, 
    //                String  name,  Object[] args,    boolean all )
    //  public static Method getMatchFullInstanceMethod( Class  type,
    //                String name,   Object[] args,    boolean all )
    //------------------------------------------------------------------
    /**
     * classname ŎNX public ȃCX^X\bĥA
     * name ƂO args  ڎ󂯓邱Ƃł̂𓾂B
     * 
     * @param classname NXB
     * @param name      郁\bhB
     * @param args      zB
     *                  null ܂߂ĂǂAnull gpꍇ
     *                  Object ̃TuNXłΑSă}b`Ă܂߁A
     *                  ړĨ\bhȊÔ̂\B
     * 
     * @return args Ɏ邱Ƃł nameƂO \bhB
     *         Ȃ nullB
     * 
     * @exception ClassNotFoundException
     *                 classname ŎNX݂Ȃꍇ
     */
    public static Method getMatchFullInstanceMethod( String   classname,
                                                     String   name,
                                                     Object[] args ) 
                                                throws  ClassNotFoundException {
        return MethodUtil.getMatchFullInstanceMethod( 
                                  Class.forName( classname ),
                                  name,
                                  args,
                                  false );
    }

    /**
     * type  public ȃCX^X\bĥA
     * name ƂO args 𒼐ڎ󂯓邱Ƃł̂𓾂B
     * 
     * @param type ^B
     * @param name 郁\bhB
     * @param args zB
     *             null ܂߂ĂǂAnull gpꍇ
     *             Object ̃TuNXłΑSă}b`Ă܂߁A
     *             ړĨ\bhȊÔ̂\B
     * 
     * @return args Ɏ邱Ƃł nameƂO \bhB
     *         Ȃ nullB
     */
    public static Method getMatchFullInstanceMethod( Class    type,
                                                     String   name,
                                                     Object[] args ){
        return MethodUtil.getMatchFullInstanceMethod( type, name, args, false );
    }

    /**
     * classname ŎNX CX^X\bĥA
     * name ƂO args 𒼐ڎ󂯓邱Ƃł̂𓾂B
     * 
     * @param classname NXB
     * @param name      郁\bhB
     * @param args      zB
     *                  null ܂߂ĂǂAnull gpꍇ
     *                  Object ̃TuNXłΑSă}b`Ă܂߁A
     *                  ړĨ\bhȊÔ̂\B
     * @param all       public ̃\bĥ݂Ȃ falseB
     *                  public, protected, private, pbP[WvCx[g
     *                  SẴ\bhȂ trueB
     * 
     * @return args Ɏ邱Ƃł nameƂO \bhB
     *         Ȃ nullB
     * 
     * @exception ClassNotFoundException
     *                 classname ŎNX݂Ȃꍇ
     */
    public static Method getMatchFullInstanceMethod( String   classname,
                                                     String   name,
                                                     Object[] args,
                                                     boolean  all ) 
                                                throws  ClassNotFoundException {
        return MethodUtil.getMatchFullInstanceMethod( 
                                  Class.forName( classname ),
                                  name,
                                  args,
                                  all );
    }


    /**
     * type  CX^X\bĥAname ƂO 
     * args 𒼐ڎ󂯓邱Ƃł̂𓾂B
     * 
     * @param type ^B 
     * @param name 郁\bhB
     * @param args zB
     *             null ܂߂ĂǂAnull gpꍇ
     *             Object ̃TuNXłΑSă}b`Ă܂߁A
     *             ړĨ\bhȊÔ̂\B
     * @param all  public ̃\bĥ݂Ȃ falseB
     *             public, protected, private, pbP[WvCx[g
     *             SẴ\bhȂ trueB
     * 
     * @return args Ɏ邱Ƃł nameƂO \bhB
     *         Ȃ nullB
     */
    public static Method getMatchFullInstanceMethod( Class    type,
                                                     String   name,
                                                     Object[] args,
                                                     boolean  all ){
        Method[] methods = all 
                         ? type.getDeclaredMethods()
                         : type.getMethods();

        for( int i = 0 ; i < methods.length ; i++ )
            if( methods[i].getName().equals( name )
             && !Modifier.isStatic( methods[i].getModifiers() )
             && Type.matchFullAll( methods[i].getParameterTypes(), args ) )
                return methods[i];
        
        return null;        
    }


    //------------------------------------------------------------------
	//	shared method
    //------------------------------------------------------------------
    //  get static method
    //------------------------------------------------------------------
    //  public static Method getStaticMethod( String classname, 
    //                                        String name, Object[] args )
    //  public static Method getStaticMethod( Class  type,
    //                                        String name, Object[] args )
    //  public static Method getStaticMethod( String classname, String  name, 
    //                                        Object[] args,    boolean all )
    //  public static Method getStaticMethod( Class  type,      String name, 
    //                                        Object[] args,    boolean all )
    //------------------------------------------------------------------
    /**
     * classname ŎNX public static \bĥA
     * name ƂO args  Type.parse 
     * 󂯓邱Ƃł̂𓾂B
     * 
     * @param classname NXB
     * @param name      郁\bhB
     * @param args      zB
     *                  null ܂߂ĂǂAnull gpꍇ
     *                  Object ̃TuNXłΑSă}b`Ă܂߁A
     *                  ړĨ\bhȊÔ̂\B
     * 
     * @return args Ɏ邱Ƃł nameƂO \bhB
     *         Ȃ nullB
     * 
     * @exception ClassNotFoundException
     *                 classname ŎNX݂Ȃꍇ
     */
    public static Method getStaticMethod( String   classname,
                                          String   name,
                                          Object[] args ) 
                                                throws  ClassNotFoundException {
        return MethodUtil.getStaticMethod( Class.forName( classname ),
                                           name,
                                           args,
                                           false );
    }

    /**
     * type  public staticȃ\bĥA
     * name ƂO args  Type.parse 
     * 󂯓邱Ƃł̂𓾂B
     * 
     * @param type ^B
     * @param name 郁\bhB
     * @param args zB
     *             null ܂߂ĂǂAnull gpꍇ
     *             Object ̃TuNXłΑSă}b`Ă܂߁A
     *             ړĨ\bhȊÔ̂\B
     * 
     * @return args Ɏ邱Ƃł nameƂO \bhB
     *         Ȃ nullB
     */
    public static Method getStaticMethod( Class    type,
                                          String   name,
                                          Object[] args ){
        return MethodUtil.getStaticMethod( type, name, args, false );
    }

    /**
     * classname ŎNX static \bĥA
     * name ƂO args  Type.parse 
     * 󂯓邱Ƃł̂𓾂B
     * 
     * @param classname NXB
     * @param name      郁\bhB
     * @param args      zB
     *                  null ܂߂ĂǂAnull gpꍇ
     *                  Object ̃TuNXłΑSă}b`Ă܂߁A
     *                  ړĨ\bhȊÔ̂\B
     * @param all       public ̃\bĥ݂Ȃ falseB
     *                  public, protected, private, pbP[WvCx[g
     *                  SẴ\bhȂ trueB
     * 
     * @return args Ɏ邱Ƃł nameƂO \bhB
     *         Ȃ nullB
     * 
     * @exception ClassNotFoundException
     *                 classname ŎNX݂Ȃꍇ
     */
    public static Method getStaticMethod( String   classname,
                                          String   name,
                                          Object[] args,
                                          boolean  all ) 
                                                throws  ClassNotFoundException {
        return MethodUtil.getStaticMethod( Class.forName( classname ),
                                           name,
                                           args,
                                           all );
    }

    /**
     * type  static \bĥAname ƂO args 
     * Type.parse  󂯓邱Ƃł̂𓾂B
     * 
     * @param type ^B 
     * @param name 郁\bhB
     * @param args zB
     *             null ܂߂ĂǂAnull gpꍇ
     *             Object ̃TuNXłΑSă}b`Ă܂߁A
     *             ړĨ\bhȊÔ̂\B
     * @param all  public ̃\bĥ݂Ȃ falseB
     *             public, protected, private, pbP[WvCx[g
     *             SẴ\bhȂ trueB
     * 
     * @return args Ɏ邱Ƃł nameƂO \bhB
     *         Ȃ nullB
     */
    public static Method getStaticMethod( Class    type,
                                          String   name,
                                          Object[] args,
                                          boolean  all ){
        Method[] methods = all 
                         ? type.getDeclaredMethods()
                         : type.getMethods();

        for( int i = 0 ; i < methods.length ; i++ )
            if( methods[i].getName().equals( name )
             && Modifier.isStatic( methods[i].getModifiers() )
             && Type.matchFullAll( methods[i].getParameterTypes(), args ) )
                return methods[i];

        for( int i = 0 ; i < methods.length ; i++ )
            if( methods[i].getName().equals( name )
             && Modifier.isStatic( methods[i].getModifiers() )
             && Type.matchRestrictAll( methods[i].getParameterTypes(), args ) )
                return methods[i];

        for( int i = 0 ; i < methods.length ; i++ )
            if( methods[i].getName().equals( name )
             && Modifier.isStatic( methods[i].getModifiers() )
             && Type.matchAll( methods[i].getParameterTypes(), args ) )
                return methods[i];
        
        return null;
    }


    //------------------------------------------------------------------
	//	shared method
    //------------------------------------------------------------------
    //  get match full static method
    //------------------------------------------------------------------
    //  public static Method getMatchFullStaticMethod( String classname, 
    //                                    String name, Object[] args )
    //  public static Method getMatchFullStaticMethod( Class  type,
    //                                    String name, Object[] args )
    //  public static Method getMatchFullStaticMethod( String classname, 
    //                String  name,  Object[] args,    boolean all )
    //  public static Method getMatchFullStaticMethod( Class  type,
    //                String name,   Object[] args,    boolean all )
    //------------------------------------------------------------------
    /**
     * classname ŎNX public static \bĥA
     * name ƂO args  ڎ󂯓邱Ƃł̂𓾂B
     * 
     * @param classname NXB
     * @param name      郁\bhB
     * @param args      zB
     *                  null ܂߂ĂǂAnull gpꍇ
     *                  Object ̃TuNXłΑSă}b`Ă܂߁A
     *                  ړĨ\bhȊÔ̂\B
     * 
     * @return args Ɏ邱Ƃł nameƂO \bhB
     *         Ȃ nullB
     * 
     * @exception ClassNotFoundException
     *                 classname ŎNX݂Ȃꍇ
     */
    public static Method getMatchFullStaticMethod( String   classname,
                                                   String   name,
                                                   Object[] args ) 
                                                throws  ClassNotFoundException {
        return MethodUtil.getMatchFullStaticMethod( Class.forName( classname ),
                                                    name,
                                                    args,
                                                    false );
    }

    /**
     * type  public staticȃ\bĥA
     * name ƂO args 𒼐ڎ󂯓邱Ƃł̂𓾂B
     * 
     * @param type ^B
     * @param name 郁\bhB
     * @param args zB
     *             null ܂߂ĂǂAnull gpꍇ
     *             Object ̃TuNXłΑSă}b`Ă܂߁A
     *             ړĨ\bhȊÔ̂\B
     * 
     * @return args Ɏ邱Ƃł nameƂO \bhB
     *         Ȃ nullB
     */
    public static Method getMatchFullStaticMethod( Class    type,
                                                   String   name,
                                                   Object[] args ){
        return MethodUtil.getMatchFullStaticMethod( type, name, args, false );
    }

    /**
     * classname ŎNX static \bĥA
     * name ƂO args 𒼐ڎ󂯓邱Ƃł̂𓾂B
     * 
     * @param classname NXB
     * @param name      郁\bhB
     * @param args      zB
     *                  null ܂߂ĂǂAnull gpꍇ
     *                  Object ̃TuNXłΑSă}b`Ă܂߁A
     *                  ړĨ\bhȊÔ̂\B
     * @param all       public ̃\bĥ݂Ȃ falseB
     *                  public, protected, private, pbP[WvCx[g
     *                  SẴ\bhȂ trueB
     * 
     * @return args Ɏ邱Ƃł nameƂO \bhB
     *         Ȃ nullB
     * 
     * @exception ClassNotFoundException
     *                 classname ŎNX݂Ȃꍇ
     */
    public static Method getMatchFullStaticMethod( String   classname,
                                                   String   name,
                                                   Object[] args,
                                                   boolean  all ) 
                                                throws  ClassNotFoundException {
        return MethodUtil.getMatchFullStaticMethod( Class.forName( classname ),
                                                    name,
                                                    args,
                                                    all );
    }


    /**
     * type  static \bĥAname ƂO 
     * args 𒼐ڎ󂯓邱Ƃł̂𓾂B
     * 
     * @param type ^B 
     * @param name 郁\bhB
     * @param args zB
     *             null ܂߂ĂǂAnull gpꍇ
     *             Object ̃TuNXłΑSă}b`Ă܂߁A
     *             ړĨ\bhȊÔ̂\B
     * @param all  public ̃\bĥ݂Ȃ falseB
     *             public, protected, private, pbP[WvCx[g
     *             SẴ\bhȂ trueB
     * 
     * @return args Ɏ邱Ƃł nameƂO \bhB
     *         Ȃ nullB
     */
    public static Method getMatchFullStaticMethod( Class    type,
                                                   String   name,
                                                   Object[] args,
                                                   boolean  all ){
        Method[] methods = all 
                         ? type.getDeclaredMethods()
                         : type.getMethods();

        for( int i = 0 ; i < methods.length ; i++ )
            if( methods[i].getName().equals( name )
             && Modifier.isStatic( methods[i].getModifiers() )
             && Type.matchFullAll( methods[i].getParameterTypes(), args ) )
                return methods[i];
        
        return null;        
    }

}
//end of Method.java
