/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.parallel.set;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.annotation.Beta;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.procedure.IfProcedure;
import org.eclipse.collections.impl.lazy.parallel.set.AbstractParallelUnsortedSetIterable;
import org.eclipse.collections.impl.lazy.parallel.set.UnsortedSetBatch;

@Beta
class ParallelSelectUnsortedSetIterable<T>
extends AbstractParallelUnsortedSetIterable<T, UnsortedSetBatch<T>> {
    private final AbstractParallelUnsortedSetIterable<T, ? extends UnsortedSetBatch<T>> delegate;
    private final Predicate<? super T> predicate;

    ParallelSelectUnsortedSetIterable(AbstractParallelUnsortedSetIterable<T, ? extends UnsortedSetBatch<T>> delegate, Predicate<? super T> predicate) {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.delegate.getExecutorService();
    }

    @Override
    public int getBatchSize() {
        return this.delegate.getBatchSize();
    }

    @Override
    public LazyIterable<UnsortedSetBatch<T>> split() {
        return this.delegate.split().collect((Function & Serializable)eachBatch -> eachBatch.select(this.predicate));
    }

    public void forEach(Procedure<? super T> procedure) {
        this.delegate.forEach(new IfProcedure<T>(this.predicate, procedure));
    }

    public boolean anySatisfy(Predicate<? super T> predicate) {
        return this.delegate.anySatisfy(Predicates.and(this.predicate, predicate));
    }

    public boolean allSatisfy(Predicate<? super T> predicate) {
        return this.delegate.allSatisfy(new SelectAllSatisfyPredicate<T>(this.predicate, predicate));
    }

    public T detect(Predicate<? super T> predicate) {
        return (T)this.delegate.detect(Predicates.and(this.predicate, predicate));
    }

    public Object[] toArray() {
        return this.delegate.toList().select(this.predicate).toArray();
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.delegate.toList().select(this.predicate).toArray((Object[])array);
    }

    private static final class SelectAllSatisfyPredicate<T>
    implements Predicate<T> {
        private final Predicate<? super T> left;
        private final Predicate<? super T> right;

        private SelectAllSatisfyPredicate(Predicate<? super T> left, Predicate<? super T> right) {
            this.left = left;
            this.right = right;
        }

        public boolean accept(T each) {
            boolean leftResult = this.left.accept(each);
            return !leftResult || this.right.accept(each);
        }
    }
}

