/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.connector.file;

import java.io.File;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.ArtifactTransfer;
import org.eclipse.aether.spi.connector.MetadataDownload;
import org.eclipse.aether.spi.connector.MetadataTransfer;
import org.eclipse.aether.spi.connector.Transfer;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.MetadataTransferException;
import org.eclipse.aether.util.repository.layout.MavenDefaultLayout;

class TransferWrapper {
    private Type type;
    private MetadataTransfer metadataTransfer;
    private ArtifactTransfer artifactTransfer;
    private Transfer transfer;
    private String checksumPolicy = null;
    private boolean existenceCheck = false;

    public Type getType() {
        return this.type;
    }

    public TransferWrapper(ArtifactTransfer transfer) {
        if (transfer == null) {
            throw new IllegalArgumentException("Transfer may not be null.");
        }
        this.artifactTransfer = transfer;
        this.transfer = transfer;
        this.type = Type.ARTIFACT;
        if (transfer instanceof ArtifactDownload) {
            this.checksumPolicy = ((ArtifactDownload)transfer).getChecksumPolicy();
            this.existenceCheck = ((ArtifactDownload)transfer).isExistenceCheck();
        }
    }

    public TransferWrapper(MetadataTransfer transfer) {
        if (transfer == null) {
            throw new IllegalArgumentException("Transfer may not be null.");
        }
        this.metadataTransfer = transfer;
        this.transfer = transfer;
        this.type = Type.METADATA;
        if (transfer instanceof MetadataDownload) {
            this.checksumPolicy = ((MetadataDownload)transfer).getChecksumPolicy();
        }
    }

    public void setState(Transfer.State new1) {
        this.transfer.setState(new1);
    }

    public File getFile() {
        File ret = null;
        if (this.metadataTransfer != null) {
            ret = this.metadataTransfer.getFile();
        } else if (this.artifactTransfer != null) {
            ret = this.artifactTransfer.getFile();
        }
        if (ret == null) {
            if (this.metadataTransfer != null) {
                ret = this.metadataTransfer.getMetadata().getFile();
            } else if (this.artifactTransfer != null) {
                ret = this.artifactTransfer.getArtifact().getFile();
            }
        }
        return ret;
    }

    public Artifact getArtifact() {
        if (this.artifactTransfer != null) {
            return this.artifactTransfer.getArtifact();
        }
        throw new IllegalStateException("TransferWrapper holds the wrong type");
    }

    public void setException(ArtifactTransferException exception) {
        if (this.artifactTransfer == null) {
            throw new IllegalStateException("TransferWrapper holds the wrong type");
        }
        this.artifactTransfer.setException(exception);
    }

    public void setException(MetadataTransferException exception) {
        if (this.metadataTransfer == null) {
            throw new IllegalStateException("TransferWrapper holds the wrong type");
        }
        this.metadataTransfer.setException(exception);
    }

    public Exception getException() {
        if (this.artifactTransfer != null) {
            return this.artifactTransfer.getException();
        }
        if (this.metadataTransfer != null) {
            return this.metadataTransfer.getException();
        }
        throw new IllegalStateException("TransferWrapper holds the wrong type");
    }

    public Metadata getMetadata() {
        return this.metadataTransfer.getMetadata();
    }

    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public boolean isExistenceCheck() {
        return this.existenceCheck;
    }

    public String getRelativePath() {
        if (this.artifactTransfer != null) {
            return new MavenDefaultLayout().getPath(this.getArtifact()).getRawPath();
        }
        if (this.metadataTransfer != null) {
            return new MavenDefaultLayout().getPath(this.getMetadata()).getRawPath();
        }
        return null;
    }

    public RequestTrace getTrace() {
        if (this.artifactTransfer != null) {
            return this.artifactTransfer.getTrace();
        }
        if (this.metadataTransfer != null) {
            return this.metadataTransfer.getTrace();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ARTIFACT,
        METADATA;

    }
}

