/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;
import org.apache.commons.math3.util.Pair;
import org.apache.commons.math3.util.Precision;

public class MathArrays {
    private static final int SPLIT_FACTOR = 0x8000001;

    private MathArrays() {
    }

    public static double[] scale(double val, double[] arr) {
        double[] newArr = new double[arr.length];
        int i = 0;
        while (i < arr.length) {
            newArr[i] = arr[i] * val;
            ++i;
        }
        return newArr;
    }

    public static void scaleInPlace(double val, double[] arr) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] * val;
        }
    }

    public static double[] ebeAdd(double[] a, double[] b) throws DimensionMismatchException {
        if (a.length != b.length) {
            throw new DimensionMismatchException(a.length, b.length);
        }
        double[] result = (double[])a.clone();
        int i = 0;
        while (i < a.length) {
            int n = i;
            result[n] = result[n] + b[i];
            ++i;
        }
        return result;
    }

    public static double[] ebeSubtract(double[] a, double[] b) throws DimensionMismatchException {
        if (a.length != b.length) {
            throw new DimensionMismatchException(a.length, b.length);
        }
        double[] result = (double[])a.clone();
        int i = 0;
        while (i < a.length) {
            int n = i;
            result[n] = result[n] - b[i];
            ++i;
        }
        return result;
    }

    public static double[] ebeMultiply(double[] a, double[] b) throws DimensionMismatchException {
        if (a.length != b.length) {
            throw new DimensionMismatchException(a.length, b.length);
        }
        double[] result = (double[])a.clone();
        int i = 0;
        while (i < a.length) {
            int n = i;
            result[n] = result[n] * b[i];
            ++i;
        }
        return result;
    }

    public static double[] ebeDivide(double[] a, double[] b) throws DimensionMismatchException {
        if (a.length != b.length) {
            throw new DimensionMismatchException(a.length, b.length);
        }
        double[] result = (double[])a.clone();
        int i = 0;
        while (i < a.length) {
            int n = i;
            result[n] = result[n] / b[i];
            ++i;
        }
        return result;
    }

    public static double distance1(double[] p1, double[] p2) {
        double sum = 0.0;
        int i = 0;
        while (i < p1.length) {
            sum += FastMath.abs(p1[i] - p2[i]);
            ++i;
        }
        return sum;
    }

    public static int distance1(int[] p1, int[] p2) {
        int sum = 0;
        int i = 0;
        while (i < p1.length) {
            sum += FastMath.abs(p1[i] - p2[i]);
            ++i;
        }
        return sum;
    }

    public static double distance(double[] p1, double[] p2) {
        double sum = 0.0;
        int i = 0;
        while (i < p1.length) {
            double dp = p1[i] - p2[i];
            sum += dp * dp;
            ++i;
        }
        return FastMath.sqrt(sum);
    }

    public static double distance(int[] p1, int[] p2) {
        double sum = 0.0;
        int i = 0;
        while (i < p1.length) {
            double dp = p1[i] - p2[i];
            sum += dp * dp;
            ++i;
        }
        return FastMath.sqrt(sum);
    }

    public static double distanceInf(double[] p1, double[] p2) {
        double max = 0.0;
        int i = 0;
        while (i < p1.length) {
            max = FastMath.max(max, FastMath.abs(p1[i] - p2[i]));
            ++i;
        }
        return max;
    }

    public static int distanceInf(int[] p1, int[] p2) {
        int max = 0;
        int i = 0;
        while (i < p1.length) {
            max = FastMath.max(max, FastMath.abs(p1[i] - p2[i]));
            ++i;
        }
        return max;
    }

    public static <T extends Comparable<? super T>> boolean isMonotonic(T[] val, OrderDirection dir, boolean strict) {
        T previous = val[0];
        int max = val.length;
        int i = 1;
        while (i < max) {
            switch (dir) {
                case INCREASING: {
                    int comp = previous.compareTo(val[i]);
                    if (!(strict ? comp >= 0 : comp > 0)) break;
                    return false;
                }
                case DECREASING: {
                    int comp = val[i].compareTo(previous);
                    if (!(strict ? comp >= 0 : comp > 0)) break;
                    return false;
                }
                default: {
                    throw new MathInternalError();
                }
            }
            previous = val[i];
            ++i;
        }
        return true;
    }

    public static boolean isMonotonic(double[] val, OrderDirection dir, boolean strict) {
        return MathArrays.checkOrder(val, dir, strict, false);
    }

    public static boolean checkOrder(double[] val, OrderDirection dir, boolean strict, boolean abort) throws NonMonotonicSequenceException {
        double previous = val[0];
        int max = val.length;
        int index = 1;
        block4: while (index < max) {
            switch (dir) {
                case INCREASING: {
                    if (!(strict ? val[index] <= previous : val[index] < previous)) break;
                    break block4;
                }
                case DECREASING: {
                    if (!(strict ? val[index] >= previous : val[index] > previous)) break;
                    break block4;
                }
                default: {
                    throw new MathInternalError();
                }
            }
            previous = val[index];
            ++index;
        }
        if (index == max) {
            return true;
        }
        if (abort) {
            throw new NonMonotonicSequenceException(val[index], (Number)previous, index, dir, strict);
        }
        return false;
    }

    public static void checkOrder(double[] val, OrderDirection dir, boolean strict) throws NonMonotonicSequenceException {
        MathArrays.checkOrder(val, dir, strict, true);
    }

    public static void checkOrder(double[] val) throws NonMonotonicSequenceException {
        MathArrays.checkOrder(val, OrderDirection.INCREASING, true);
    }

    public static void checkRectangular(long[][] in) throws NullArgumentException, DimensionMismatchException {
        MathUtils.checkNotNull(in);
        int i = 1;
        while (i < in.length) {
            if (in[i].length != in[0].length) {
                throw new DimensionMismatchException((Localizable)LocalizedFormats.DIFFERENT_ROWS_LENGTHS, in[i].length, in[0].length);
            }
            ++i;
        }
    }

    public static void checkPositive(double[] in) throws NotStrictlyPositiveException {
        int i = 0;
        while (i < in.length) {
            if (in[i] <= 0.0) {
                throw new NotStrictlyPositiveException(in[i]);
            }
            ++i;
        }
    }

    public static void checkNonNegative(long[] in) throws NotPositiveException {
        int i = 0;
        while (i < in.length) {
            if (in[i] < 0L) {
                throw new NotPositiveException(in[i]);
            }
            ++i;
        }
    }

    public static void checkNonNegative(long[][] in) throws NotPositiveException {
        int i = 0;
        while (i < in.length) {
            int j = 0;
            while (j < in[i].length) {
                if (in[i][j] < 0L) {
                    throw new NotPositiveException(in[i][j]);
                }
                ++j;
            }
            ++i;
        }
    }

    public static double safeNorm(double[] v) {
        double rdwarf = 3.834E-20;
        double rgiant = 1.304E19;
        double s1 = 0.0;
        double s2 = 0.0;
        double s3 = 0.0;
        double x1max = 0.0;
        double x3max = 0.0;
        double floatn = v.length;
        double agiant = rgiant / floatn;
        int i = 0;
        while (i < v.length) {
            double xabs = Math.abs(v[i]);
            if (xabs < rdwarf || xabs > agiant) {
                double r;
                if (xabs > rdwarf) {
                    if (xabs > x1max) {
                        r = x1max / xabs;
                        s1 = 1.0 + s1 * r * r;
                        x1max = xabs;
                    } else {
                        r = xabs / x1max;
                        s1 += r * r;
                    }
                } else if (xabs > x3max) {
                    r = x3max / xabs;
                    s3 = 1.0 + s3 * r * r;
                    x3max = xabs;
                } else if (xabs != 0.0) {
                    r = xabs / x3max;
                    s3 += r * r;
                }
            } else {
                s2 += xabs * xabs;
            }
            ++i;
        }
        double norm = s1 != 0.0 ? x1max * Math.sqrt(s1 + s2 / x1max / x1max) : (s2 == 0.0 ? x3max * Math.sqrt(s3) : (s2 >= x3max ? Math.sqrt(s2 * (1.0 + x3max / s2 * (x3max * s3))) : Math.sqrt(x3max * (s2 / x3max + x3max * s3))));
        return norm;
    }

    public static void sortInPlace(double[] x, double[] ... yList) throws DimensionMismatchException, NullArgumentException {
        MathArrays.sortInPlace(x, OrderDirection.INCREASING, yList);
    }

    public static void sortInPlace(double[] x, final OrderDirection dir, double[] ... yList) throws NullArgumentException, DimensionMismatchException {
        if (x == null) {
            throw new NullArgumentException();
        }
        int len = x.length;
        ArrayList<Pair<Double, double[]>> list = new ArrayList<Pair<Double, double[]>>(len);
        int yListLen = yList.length;
        int i = 0;
        while (i < len) {
            double[] yValues = new double[yListLen];
            int j = 0;
            while (j < yListLen) {
                double[] y = yList[j];
                if (y == null) {
                    throw new NullArgumentException();
                }
                if (y.length != len) {
                    throw new DimensionMismatchException(y.length, len);
                }
                yValues[j] = y[i];
                ++j;
            }
            list.add(new Pair<Double, double[]>(x[i], yValues));
            ++i;
        }
        Comparator<Pair<Double, double[]>> comp = new Comparator<Pair<Double, double[]>>(){

            @Override
            public int compare(Pair<Double, double[]> o1, Pair<Double, double[]> o2) {
                int val;
                switch (dir) {
                    case INCREASING: {
                        val = o1.getKey().compareTo(o2.getKey());
                        break;
                    }
                    case DECREASING: {
                        val = o2.getKey().compareTo(o1.getKey());
                        break;
                    }
                    default: {
                        throw new MathInternalError();
                    }
                }
                return val;
            }
        };
        Collections.sort(list, comp);
        int i2 = 0;
        while (i2 < len) {
            Pair e = (Pair)list.get(i2);
            x[i2] = (Double)e.getKey();
            double[] yValues = (double[])e.getValue();
            int j = 0;
            while (j < yListLen) {
                yList[j][i2] = yValues[j];
                ++j;
            }
            ++i2;
        }
    }

    public static int[] copyOf(int[] source) {
        return MathArrays.copyOf(source, source.length);
    }

    public static double[] copyOf(double[] source) {
        return MathArrays.copyOf(source, source.length);
    }

    public static int[] copyOf(int[] source, int len) {
        int[] output = new int[len];
        System.arraycopy(source, 0, output, 0, FastMath.min(len, source.length));
        return output;
    }

    public static double[] copyOf(double[] source, int len) {
        double[] output = new double[len];
        System.arraycopy(source, 0, output, 0, FastMath.min(len, source.length));
        return output;
    }

    public static double linearCombination(double[] a, double[] b) throws DimensionMismatchException {
        int len = a.length;
        if (len != b.length) {
            throw new DimensionMismatchException(len, b.length);
        }
        double[] prodHigh = new double[len];
        double prodLowSum = 0.0;
        int i = 0;
        while (i < len) {
            double ai = a[i];
            double ca = 1.34217729E8 * ai;
            double aHigh = ca - (ca - ai);
            double aLow = ai - aHigh;
            double bi = b[i];
            double cb = 1.34217729E8 * bi;
            double bHigh = cb - (cb - bi);
            double bLow = bi - bHigh;
            prodHigh[i] = ai * bi;
            double prodLow = aLow * bLow - (prodHigh[i] - aHigh * bHigh - aLow * bHigh - aHigh * bLow);
            prodLowSum += prodLow;
            ++i;
        }
        double prodHighCur = prodHigh[0];
        double prodHighNext = prodHigh[1];
        double sHighPrev = prodHighCur + prodHighNext;
        double sPrime = sHighPrev - prodHighNext;
        double sLowSum = prodHighNext - (sHighPrev - sPrime) + (prodHighCur - sPrime);
        int lenMinusOne = len - 1;
        int i2 = 1;
        while (i2 < lenMinusOne) {
            prodHighNext = prodHigh[i2 + 1];
            double sHighCur = sHighPrev + prodHighNext;
            sPrime = sHighCur - prodHighNext;
            sLowSum += prodHighNext - (sHighCur - sPrime) + (sHighPrev - sPrime);
            sHighPrev = sHighCur;
            ++i2;
        }
        double result = sHighPrev + (prodLowSum + sLowSum);
        if (Double.isNaN(result)) {
            result = 0.0;
            int i3 = 0;
            while (i3 < len) {
                result += a[i3] * b[i3];
                ++i3;
            }
        }
        return result;
    }

    public static double linearCombination(double a1, double b1, double a2, double b2) {
        double prod1High = a1 * b1;
        double prod2High = a2 * b2;
        double s12High = prod1High + prod2High;
        double ca1 = 1.34217729E8 * a1;
        double a1High = ca1 - (ca1 - a1);
        double a1Low = a1 - a1High;
        double cb1 = 1.34217729E8 * b1;
        double b1High = cb1 - (cb1 - b1);
        double b1Low = b1 - b1High;
        double prod1Low = a1Low * b1Low - (prod1High - a1High * b1High - a1Low * b1High - a1High * b1Low);
        double ca2 = 1.34217729E8 * a2;
        double a2High = ca2 - (ca2 - a2);
        double a2Low = a2 - a2High;
        double cb2 = 1.34217729E8 * b2;
        double b2High = cb2 - (cb2 - b2);
        double b2Low = b2 - b2High;
        double prod2Low = a2Low * b2Low - (prod2High - a2High * b2High - a2Low * b2High - a2High * b2Low);
        double s12Prime = s12High - prod2High;
        double s12Low = prod2High - (s12High - s12Prime) + (prod1High - s12Prime);
        double result = s12High + (prod1Low + prod2Low + s12Low);
        if (Double.isNaN(result)) {
            result = a1 * b1 + a2 * b2;
        }
        return result;
    }

    public static double linearCombination(double a1, double b1, double a2, double b2, double a3, double b3) {
        double prod1High = a1 * b1;
        double prod2High = a2 * b2;
        double s12High = prod1High + prod2High;
        double prod3High = a3 * b3;
        double s123High = s12High + prod3High;
        double ca1 = 1.34217729E8 * a1;
        double a1High = ca1 - (ca1 - a1);
        double a1Low = a1 - a1High;
        double cb1 = 1.34217729E8 * b1;
        double b1High = cb1 - (cb1 - b1);
        double b1Low = b1 - b1High;
        double prod1Low = a1Low * b1Low - (prod1High - a1High * b1High - a1Low * b1High - a1High * b1Low);
        double ca2 = 1.34217729E8 * a2;
        double a2High = ca2 - (ca2 - a2);
        double a2Low = a2 - a2High;
        double cb2 = 1.34217729E8 * b2;
        double b2High = cb2 - (cb2 - b2);
        double b2Low = b2 - b2High;
        double prod2Low = a2Low * b2Low - (prod2High - a2High * b2High - a2Low * b2High - a2High * b2Low);
        double ca3 = 1.34217729E8 * a3;
        double a3High = ca3 - (ca3 - a3);
        double a3Low = a3 - a3High;
        double cb3 = 1.34217729E8 * b3;
        double b3High = cb3 - (cb3 - b3);
        double b3Low = b3 - b3High;
        double prod3Low = a3Low * b3Low - (prod3High - a3High * b3High - a3Low * b3High - a3High * b3Low);
        double s12Prime = s12High - prod2High;
        double s12Low = prod2High - (s12High - s12Prime) + (prod1High - s12Prime);
        double s123Prime = s123High - prod3High;
        double s123Low = prod3High - (s123High - s123Prime) + (s12High - s123Prime);
        double result = s123High + (prod1Low + prod2Low + prod3Low + s12Low + s123Low);
        if (Double.isNaN(result)) {
            result = a1 * b1 + a2 * b2 + a3 * b3;
        }
        return result;
    }

    public static double linearCombination(double a1, double b1, double a2, double b2, double a3, double b3, double a4, double b4) {
        double prod1High = a1 * b1;
        double prod2High = a2 * b2;
        double s12High = prod1High + prod2High;
        double prod3High = a3 * b3;
        double s123High = s12High + prod3High;
        double prod4High = a4 * b4;
        double s1234High = s123High + prod4High;
        double ca1 = 1.34217729E8 * a1;
        double a1High = ca1 - (ca1 - a1);
        double a1Low = a1 - a1High;
        double cb1 = 1.34217729E8 * b1;
        double b1High = cb1 - (cb1 - b1);
        double b1Low = b1 - b1High;
        double prod1Low = a1Low * b1Low - (prod1High - a1High * b1High - a1Low * b1High - a1High * b1Low);
        double ca2 = 1.34217729E8 * a2;
        double a2High = ca2 - (ca2 - a2);
        double a2Low = a2 - a2High;
        double cb2 = 1.34217729E8 * b2;
        double b2High = cb2 - (cb2 - b2);
        double b2Low = b2 - b2High;
        double prod2Low = a2Low * b2Low - (prod2High - a2High * b2High - a2Low * b2High - a2High * b2Low);
        double ca3 = 1.34217729E8 * a3;
        double a3High = ca3 - (ca3 - a3);
        double a3Low = a3 - a3High;
        double cb3 = 1.34217729E8 * b3;
        double b3High = cb3 - (cb3 - b3);
        double b3Low = b3 - b3High;
        double prod3Low = a3Low * b3Low - (prod3High - a3High * b3High - a3Low * b3High - a3High * b3Low);
        double ca4 = 1.34217729E8 * a4;
        double a4High = ca4 - (ca4 - a4);
        double a4Low = a4 - a4High;
        double cb4 = 1.34217729E8 * b4;
        double b4High = cb4 - (cb4 - b4);
        double b4Low = b4 - b4High;
        double prod4Low = a4Low * b4Low - (prod4High - a4High * b4High - a4Low * b4High - a4High * b4Low);
        double s12Prime = s12High - prod2High;
        double s12Low = prod2High - (s12High - s12Prime) + (prod1High - s12Prime);
        double s123Prime = s123High - prod3High;
        double s123Low = prod3High - (s123High - s123Prime) + (s12High - s123Prime);
        double s1234Prime = s1234High - prod4High;
        double s1234Low = prod4High - (s1234High - s1234Prime) + (s123High - s1234Prime);
        double result = s1234High + (prod1Low + prod2Low + prod3Low + prod4Low + s12Low + s123Low + s1234Low);
        if (Double.isNaN(result)) {
            result = a1 * b1 + a2 * b2 + a3 * b3 + a4 * b4;
        }
        return result;
    }

    public static boolean equals(float[] x, float[] y) {
        if (x == null || y == null) {
            return !(x == null ^ y == null);
        }
        if (x.length != y.length) {
            return false;
        }
        int i = 0;
        while (i < x.length) {
            if (!Precision.equals(x[i], y[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalsIncludingNaN(float[] x, float[] y) {
        if (x == null || y == null) {
            return !(x == null ^ y == null);
        }
        if (x.length != y.length) {
            return false;
        }
        int i = 0;
        while (i < x.length) {
            if (!Precision.equalsIncludingNaN(x[i], y[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(double[] x, double[] y) {
        if (x == null || y == null) {
            return !(x == null ^ y == null);
        }
        if (x.length != y.length) {
            return false;
        }
        int i = 0;
        while (i < x.length) {
            if (!Precision.equals(x[i], y[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalsIncludingNaN(double[] x, double[] y) {
        if (x == null || y == null) {
            return !(x == null ^ y == null);
        }
        if (x.length != y.length) {
            return false;
        }
        int i = 0;
        while (i < x.length) {
            if (!Precision.equalsIncludingNaN(x[i], y[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static double[] normalizeArray(double[] values, double normalizedSum) throws MathIllegalArgumentException, MathArithmeticException {
        if (Double.isInfinite(normalizedSum)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NORMALIZE_INFINITE, new Object[0]);
        }
        if (Double.isNaN(normalizedSum)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NORMALIZE_NAN, new Object[0]);
        }
        double sum = 0.0;
        int len = values.length;
        double[] out = new double[len];
        int i = 0;
        while (i < len) {
            if (Double.isInfinite(values[i])) {
                throw new MathIllegalArgumentException(LocalizedFormats.INFINITE_ARRAY_ELEMENT, values[i], i);
            }
            if (!Double.isNaN(values[i])) {
                sum += values[i];
            }
            ++i;
        }
        if (sum == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ARRAY_SUMS_TO_ZERO, new Object[0]);
        }
        i = 0;
        while (i < len) {
            out[i] = Double.isNaN(values[i]) ? Double.NaN : values[i] * normalizedSum / sum;
            ++i;
        }
        return out;
    }

    public static <T> T[] buildArray(Field<T> field, int length) {
        Object[] array = (Object[])Array.newInstance(field.getRuntimeClass(), length);
        Arrays.fill(array, field.getZero());
        return array;
    }

    public static <T> T[][] buildArray(Field<T> field, int rows, int columns) {
        Object[][] array;
        if (columns < 0) {
            T[] dummyRow = MathArrays.buildArray(field, 0);
            array = (Object[][])Array.newInstance(dummyRow.getClass(), rows);
        } else {
            array = (Object[][])Array.newInstance(field.getRuntimeClass(), rows, columns);
            int i = 0;
            while (i < rows) {
                Arrays.fill(array[i], field.getZero());
                ++i;
            }
        }
        return array;
    }

    public static interface Function {
        public double evaluate(double[] var1);

        public double evaluate(double[] var1, int var2, int var3);
    }

    public static enum OrderDirection {
        INCREASING,
        DECREASING;

    }
}

