/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.client;

import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.AsyncCallback;

public class TimingOutCallback
implements AsyncCallback {
    private final long timeout;
    private Object result;
    private Throwable error;
    private boolean responseSeen;

    public TimingOutCallback(long pTimeout) {
        this.timeout = pTimeout;
    }

    public synchronized Object waitForResponse() throws Throwable {
        if (!this.responseSeen) {
            this.wait(this.timeout);
            if (!this.responseSeen) {
                throw new TimeoutException(0, "No response after waiting for " + this.timeout + " milliseconds.");
            }
        }
        if (this.error != null) {
            throw this.error;
        }
        return this.result;
    }

    @Override
    public synchronized void handleError(XmlRpcRequest pRequest, Throwable pError) {
        this.responseSeen = true;
        this.error = pError;
        this.notify();
    }

    @Override
    public synchronized void handleResult(XmlRpcRequest pRequest, Object pResult) {
        this.responseSeen = true;
        this.result = pResult;
        this.notify();
    }

    public static class TimeoutException
    extends XmlRpcException {
        private static final long serialVersionUID = 4875266372372105081L;

        public TimeoutException(int pCode, String message) {
            super(pCode, message);
        }
    }
}

