/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.metadata;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.w3c.dom.Node;

public class Util {
    private static final Class jaxbElementClass;

    static {
        Class<?> c;
        try {
            c = Class.forName("javax.xml.bind.Element");
        }
        catch (ClassNotFoundException e) {
            c = null;
        }
        jaxbElementClass = c;
    }

    public static String getSignatureType(Class pType) {
        if (pType == Integer.TYPE || pType == Integer.class) {
            return "int";
        }
        if (pType == Double.TYPE || pType == Double.class) {
            return "double";
        }
        if (pType == Boolean.TYPE || pType == Boolean.class) {
            return "boolean";
        }
        if (pType == String.class) {
            return "string";
        }
        if (Object[].class.isAssignableFrom(pType) || List.class.isAssignableFrom(pType)) {
            return "array";
        }
        if (Map.class.isAssignableFrom(pType)) {
            return "struct";
        }
        if (Date.class.isAssignableFrom(pType) || Calendar.class.isAssignableFrom(pType)) {
            return "dateTime.iso8601";
        }
        if (pType == byte[].class) {
            return "base64";
        }
        if (pType == Void.TYPE) {
            return "ex:nil";
        }
        if (pType == Byte.TYPE || pType == Byte.class) {
            return "ex:i1";
        }
        if (pType == Short.TYPE || pType == Short.class) {
            return "ex:i2";
        }
        if (pType == Long.TYPE || pType == Long.class) {
            return "ex:i8";
        }
        if (pType == Float.TYPE || pType == Float.class) {
            return "ex:float";
        }
        if (Node.class.isAssignableFrom(pType)) {
            return "ex:node";
        }
        if (jaxbElementClass != null && jaxbElementClass.isAssignableFrom(pType)) {
            return "ex:jaxbElement";
        }
        if (Serializable.class.isAssignableFrom(pType)) {
            return "base64";
        }
        return null;
    }

    public static String[][] getSignature(Method[] pMethods) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        int i = 0;
        while (i < pMethods.length) {
            String[] sig = Util.getSignature(pMethods[i]);
            if (sig != null) {
                result.add(sig);
            }
            ++i;
        }
        return (String[][])result.toArray((T[])new String[result.size()][]);
    }

    public static String[] getSignature(Method pMethod) {
        Class<?>[] paramClasses = pMethod.getParameterTypes();
        String[] sig = new String[paramClasses.length + 1];
        String s = Util.getSignatureType(pMethod.getReturnType());
        if (s == null) {
            return null;
        }
        sig[0] = s;
        int i = 0;
        while (i < paramClasses.length) {
            s = Util.getSignatureType(paramClasses[i]);
            if (s == null) {
                return null;
            }
            sig[i + 1] = s;
            ++i;
        }
        return sig;
    }

    public static String getMethodHelp(Class pClass, Method[] pMethods) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < pMethods.length) {
            String help = Util.getMethodHelp(pClass, pMethods[i]);
            if (help != null) {
                result.add(help);
            }
            ++i;
        }
        switch (result.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (String)result.get(0);
            }
        }
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < result.size()) {
            sb.append(i2 + 1);
            sb.append(": ");
            sb.append(result.get(i2));
            sb.append("\n");
            ++i2;
        }
        return sb.toString();
    }

    public static String getMethodHelp(Class pClass, Method pMethod) {
        StringBuffer sb = new StringBuffer();
        sb.append("Invokes the method ");
        sb.append(pClass.getName());
        sb.append(".");
        sb.append(pMethod.getName());
        sb.append("(");
        Class<?>[] paramClasses = pMethod.getParameterTypes();
        int i = 0;
        while (i < paramClasses.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(paramClasses[i].getName());
            ++i;
        }
        sb.append(").");
        return sb.toString();
    }

    public static String getSignature(Object[] args) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < args.length) {
            if (i > 0) {
                sb.append(", ");
            }
            if (args[i] == null) {
                sb.append("null");
            } else {
                sb.append(args[i].getClass().getName());
            }
            ++i;
        }
        return sb.toString();
    }

    public static Object newInstance(Class pClass) throws XmlRpcException {
        try {
            return pClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new XmlRpcException("Failed to instantiate class " + pClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new XmlRpcException("Illegal access when instantiating class " + pClass.getName(), e);
        }
    }
}

