/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.impl;

import java.util.HashMap;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.ColoredCartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.ColoredCartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.RGBAColor;
import org.eclipse.apogy.common.geometry.data3d.impl.CartesianTriangularMeshColorizerImpl;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class CartesianTriangularMeshColorizerCustomImpl
extends CartesianTriangularMeshColorizerImpl {
    @Override
    public abstract RGBAColor computeColor(CartesianTriangularMesh var1, CartesianPositionCoordinates var2);

    public ColoredCartesianTriangularMesh doProcess(CartesianTriangularMesh input, IProgressMonitor monitor) throws Exception {
        int workUnits = input.getPoints().size() + input.getPolygons().size();
        int workUnitIncrement = (int)Math.floor((float)workUnits / 100.0f);
        monitor.beginTask("Colorizing mesh", workUnits);
        HashMap<CartesianPositionCoordinates, ColoredCartesianPositionCoordinates> originalToColoredPointMap = new HashMap<CartesianPositionCoordinates, ColoredCartesianPositionCoordinates>();
        int workPerformed = 0;
        monitor.subTask("Computing vertex colors...");
        for (CartesianPositionCoordinates point : input.getPoints()) {
            RGBAColor color = this.computeColor(input, point);
            ColoredCartesianPositionCoordinates coloredPoint = ApogyCommonGeometryData3DFacade.INSTANCE.createColoredCartesianPositionCoordinates(point.getX(), point.getY(), point.getZ(), color.getRed(), color.getGreen(), color.getBlue());
            originalToColoredPointMap.put(point, coloredPoint);
            if (++workPerformed >= workUnitIncrement) {
                this.getProgressMonitor().worked(workPerformed);
                workPerformed = 0;
            }
            if (!monitor.isCanceled()) continue;
            return null;
        }
        if (workPerformed > 0) {
            monitor.worked(workPerformed);
        }
        workPerformed = 0;
        ColoredCartesianTriangularMesh mesh = ApogyCommonGeometryData3DFactory.eINSTANCE.createColoredCartesianTriangularMesh();
        mesh.getPoints().addAll(originalToColoredPointMap.values());
        monitor.subTask("Creating colored mesh...");
        for (CartesianTriangle triangle : input.getPolygons()) {
            CartesianTriangle newTriangle = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianTriangle();
            for (CartesianPositionCoordinates vertex : triangle.getVertices()) {
                ColoredCartesianPositionCoordinates cc = (ColoredCartesianPositionCoordinates)originalToColoredPointMap.get(vertex);
                if (cc != null) {
                    newTriangle.getVertices().add((Object)cc);
                }
                if (!monitor.isCanceled()) continue;
                return null;
            }
            mesh.getPolygons().add((Object)newTriangle);
            if (++workPerformed < workUnitIncrement) continue;
            monitor.worked(workPerformed);
            workPerformed = 0;
        }
        if (workPerformed > 0) {
            monitor.worked(workPerformed);
        }
        return mesh;
    }
}

