/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.impl;

import java.util.Iterator;
import org.eclipse.apogy.common.geometry.data3d.CartesianPolygon;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.impl.CubeSamplingShapeImpl;

public class CubeSamplingShapeCustomImpl<PolygonType extends CartesianPolygon>
extends CubeSamplingShapeImpl<PolygonType> {
    private double minX = Double.NaN;
    private double minY = Double.NaN;
    private double minZ = Double.NaN;
    private double maxX = Double.NaN;
    private double maxY = Double.NaN;
    private double maxZ = Double.NaN;

    @Override
    public void setCorner1(CartesianPositionCoordinates newCorner1) {
        this.minX = Double.NaN;
        this.minY = Double.NaN;
        this.minZ = Double.NaN;
        this.maxX = Double.NaN;
        this.maxY = Double.NaN;
        this.maxZ = Double.NaN;
        super.setCorner1(newCorner1);
    }

    @Override
    public void setCorner2(CartesianPositionCoordinates newCorner2) {
        this.minX = Double.NaN;
        this.minY = Double.NaN;
        this.minZ = Double.NaN;
        this.maxX = Double.NaN;
        this.maxY = Double.NaN;
        this.maxZ = Double.NaN;
        super.setCorner2(newCorner2);
    }

    @Override
    public boolean isPolygonInside(PolygonType polygon) {
        if (this.isIncludeJustTouching()) {
            CartesianPositionCoordinates center = polygon.getCentroid();
            if (this.isInside(center)) {
                return true;
            }
            boolean inside = false;
            Iterator it = polygon.getVertices().iterator();
            while (it.hasNext() && !inside) {
                inside = this.isInside((CartesianPositionCoordinates)it.next());
            }
            return inside;
        }
        boolean inside = true;
        Iterator it = polygon.getVertices().iterator();
        while (it.hasNext() && inside) {
            inside = this.isInside((CartesianPositionCoordinates)it.next());
        }
        return inside;
    }

    @Override
    public boolean isInside(CartesianPositionCoordinates point) {
        if (this.isIncludeJustTouching()) {
            return this.getMinX() <= point.getX() && point.getX() <= this.getMaxX() && this.getMinY() <= point.getY() && point.getY() <= this.getMaxY() && this.getMinZ() <= point.getZ() && point.getZ() <= this.getMaxZ();
        }
        return this.getMinX() < point.getX() && point.getX() < this.getMaxX() && this.getMinY() < point.getY() && point.getY() < this.getMaxY() && this.getMinZ() < point.getZ() && point.getZ() < this.getMaxZ();
    }

    private double getMinX() {
        if (Double.isNaN(this.minX) && this.getCorner1() != null && this.getCorner2() != null) {
            this.minX = this.getCorner1().getX() < this.getCorner2().getX() ? this.getCorner1().getX() : this.getCorner2().getX();
        }
        return this.minX;
    }

    private double getMinY() {
        if (Double.isNaN(this.minY) && this.getCorner1() != null && this.getCorner2() != null) {
            this.minY = this.getCorner1().getY() < this.getCorner2().getY() ? this.getCorner1().getY() : this.getCorner2().getY();
        }
        return this.minY;
    }

    private double getMinZ() {
        if (Double.isNaN(this.minZ) && this.getCorner1() != null && this.getCorner2() != null) {
            this.minZ = this.getCorner1().getZ() < this.getCorner2().getZ() ? this.getCorner1().getZ() : this.getCorner2().getZ();
        }
        return this.minZ;
    }

    private double getMaxX() {
        if (Double.isNaN(this.maxX) && this.getCorner1() != null && this.getCorner2() != null) {
            this.maxX = this.getCorner1().getX() > this.getCorner2().getX() ? this.getCorner1().getX() : this.getCorner2().getX();
        }
        return this.maxX;
    }

    private double getMaxY() {
        if (Double.isNaN(this.maxY) && this.getCorner1() != null && this.getCorner2() != null) {
            this.maxY = this.getCorner1().getY() > this.getCorner2().getY() ? this.getCorner1().getY() : this.getCorner2().getY();
        }
        return this.maxY;
    }

    private double getMaxZ() {
        if (Double.isNaN(this.maxZ) && this.getCorner1() != null && this.getCorner2() != null) {
            this.maxZ = this.getCorner1().getZ() > this.getCorner2().getZ() ? this.getCorner1().getZ() : this.getCorner2().getZ();
        }
        return this.maxZ;
    }

    @Override
    public CartesianPositionCoordinates getCorner1() {
        return null;
    }

    @Override
    public CartesianPositionCoordinates getCorner2() {
        return null;
    }

    @Override
    public boolean isIncludeJustTouching() {
        return false;
    }

    @Override
    public void setIncludeJustTouching(boolean value) {
    }
}

