/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JDIPlaceholderVariable;
import org.eclipse.jdt.internal.debug.ui.ExpressionInformationControlCreator;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDIModelPresentation;
import org.eclipse.jdt.internal.debug.ui.JavaWordFinder;
import org.eclipse.jdt.internal.debug.ui.LambdaUtils;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.text.java.hover.IJavaEditorTextHover;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class JavaDebugHover
implements IJavaEditorTextHover,
ITextHoverExtension,
ITextHoverExtension2 {
    private IEditorPart fEditor;

    public void setEditor(IEditorPart editor) {
        this.fEditor = editor;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return JavaWordFinder.findWord(textViewer.getDocument(), offset);
    }

    protected IJavaStackFrame getFrame() {
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable != null) {
            return (IJavaStackFrame)adaptable.getAdapter(IJavaStackFrame.class);
        }
        return null;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        Object object = this.getHoverInfo2(textViewer, hoverRegion);
        if (object instanceof IVariable) {
            IVariable var = (IVariable)object;
            return JavaDebugHover.getVariableText(var);
        }
        return null;
    }

    private IVariable resolveLocalVariable(IJavaStackFrame frame, ITextViewer textViewer, IRegion hoverRegion) {
        if (frame != null) {
            try {
                IDocument document = textViewer.getDocument();
                if (document != null) {
                    String variableName = document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                    return JavaDebugHover.findLocalVariable(frame, variableName);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return null;
    }

    public static IVariable findLocalVariable(IJavaStackFrame frame, String variableName) {
        block3: {
            if (frame != null) {
                try {
                    return frame.findVariable(variableName);
                }
                catch (DebugException x) {
                    if (x.getStatus().getCode() == 100) break block3;
                    JDIDebugUIPlugin.log(x);
                }
            }
        }
        return null;
    }

    private static String getVariableText(IVariable variable) {
        StringBuilder buffer = new StringBuilder();
        JDIModelPresentation modelPresentation = JavaDebugHover.getModelPresentation();
        buffer.append("<p><pre>");
        String variableText = modelPresentation.getVariableText((IJavaVariable)variable);
        buffer.append(JavaDebugHover.replaceHTMLChars(variableText));
        buffer.append("</pre></p>");
        modelPresentation.dispose();
        if (buffer.length() > 0) {
            return buffer.toString();
        }
        return null;
    }

    private static String replaceHTMLChars(String variableText) {
        StringBuilder buffer = new StringBuilder(variableText.length());
        char[] characters = variableText.toCharArray();
        int i = 0;
        while (i < characters.length) {
            char character = characters[i];
            switch (character) {
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '\"': {
                    buffer.append("&quot;");
                    break;
                }
                default: {
                    buffer.append(character);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    private static JDIModelPresentation getModelPresentation() {
        JDIModelPresentation presentation = new JDIModelPresentation();
        String[][] booleanPrefs = new String[][]{{IJDIPreferencesConstants.PREF_SHOW_QUALIFIED_NAMES, "DISPLAY_QUALIFIED_NAMES"}};
        String viewId = "org.eclipse.debug.ui.VariableView";
        int i = 0;
        while (i < booleanPrefs.length) {
            boolean preferenceValue = JavaDebugHover.getBooleanPreferenceValue(viewId, booleanPrefs[i][0]);
            presentation.setAttribute(booleanPrefs[i][1], preferenceValue ? Boolean.TRUE : Boolean.FALSE);
            ++i;
        }
        return presentation;
    }

    public static boolean getBooleanPreferenceValue(String id, String preference) {
        String compositeKey = String.valueOf(id) + "." + preference;
        IPreferenceStore store = JDIDebugUIPlugin.getDefault().getPreferenceStore();
        boolean value = false;
        value = store.contains(compositeKey) ? store.getBoolean(compositeKey) : store.getBoolean(preference);
        return value;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new ExpressionInformationControlCreator();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        IJavaStackFrame frame = this.getFrame();
        if (frame != null) {
            block67: {
                IDocument document = textViewer.getDocument();
                if (document != null) {
                    try {
                        String variableName = document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                        if (!variableName.equals("this")) break block67;
                        try {
                            IJavaVariable variable = frame.findVariable(variableName);
                            if (variable != null) {
                                return variable;
                            }
                        }
                        catch (DebugException debugException) {
                            return null;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
            }
            ICodeAssist codeAssist = null;
            if (this.fEditor != null) {
                IEditorInput input = this.fEditor.getEditorInput();
                Object element = JavaUI.getWorkingCopyManager().getWorkingCopy(input);
                if (element == null) {
                    element = input.getAdapter(IClassFile.class);
                }
                if (element instanceof ICodeAssist) {
                    codeAssist = (ICodeAssist)element;
                }
            }
            if (codeAssist == null) {
                return this.resolveLocalVariable(frame, textViewer, hoverRegion);
            }
            IJavaElement[] resolve = null;
            try {
                resolve = codeAssist.codeSelect(hoverRegion.getOffset(), 0);
            }
            catch (JavaModelException javaModelException) {
                resolve = new IJavaElement[]{};
            }
            try {
                int i = 0;
                while (i < resolve.length) {
                    IJavaElement javaElement = resolve[i];
                    if (javaElement instanceof IField) {
                        IField field = (IField)javaElement;
                        IJavaFieldVariable variable = null;
                        IJavaDebugTarget debugTarget = (IJavaDebugTarget)frame.getDebugTarget();
                        if (Flags.isStatic((int)field.getFlags())) {
                            IJavaType[] javaTypes = debugTarget.getJavaTypes(field.getDeclaringType().getFullyQualifiedName());
                            if (javaTypes != null) {
                                int j = 0;
                                while (j < javaTypes.length) {
                                    IJavaType type = javaTypes[j];
                                    if (type instanceof IJavaReferenceType) {
                                        IJavaReferenceType referenceType = (IJavaReferenceType)type;
                                        variable = referenceType.getField(field.getElementName());
                                    }
                                    if (variable != null) break;
                                    ++j;
                                }
                            }
                            if (variable == null) {
                                Object constant = field.getConstant();
                                if (constant != null) {
                                    IJavaValue value = null;
                                    if (constant instanceof Integer) {
                                        value = debugTarget.newValue(((Integer)constant).intValue());
                                    } else if (constant instanceof Byte) {
                                        value = debugTarget.newValue(((Byte)constant).byteValue());
                                    } else if (constant instanceof Boolean) {
                                        value = debugTarget.newValue(((Boolean)constant).booleanValue());
                                    } else if (constant instanceof Character) {
                                        value = debugTarget.newValue(((Character)constant).charValue());
                                    } else if (constant instanceof Double) {
                                        value = debugTarget.newValue(((Double)constant).doubleValue());
                                    } else if (constant instanceof Float) {
                                        value = debugTarget.newValue(((Float)constant).floatValue());
                                    } else if (constant instanceof Long) {
                                        value = debugTarget.newValue(((Long)constant).longValue());
                                    } else if (constant instanceof Short) {
                                        value = debugTarget.newValue(((Short)constant).shortValue());
                                    } else if (constant instanceof String) {
                                        value = debugTarget.newValue((String)constant);
                                    }
                                    if (value != null) {
                                        variable = new JDIPlaceholderVariable(field.getElementName(), value);
                                    }
                                }
                                if (variable == null) {
                                    return null;
                                }
                            }
                        } else if (!frame.isStatic() && !frame.isNative()) {
                            FieldAccess fieldAccess;
                            ASTNode node;
                            if (!(codeAssist instanceof ITypeRoot)) {
                                return null;
                            }
                            ITypeRoot typeRoot = (ITypeRoot)codeAssist;
                            CompilationUnit root = SharedASTProvider.getAST((ITypeRoot)typeRoot, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_NO, null);
                            if (root == null) {
                                ASTParser parser = ASTParser.newParser((int)4);
                                parser.setSource(typeRoot);
                                parser.setFocalPosition(hoverRegion.getOffset());
                                root = parser.createAST(null);
                            }
                            if ((node = NodeFinder.perform((ASTNode)root, (int)hoverRegion.getOffset(), (int)hoverRegion.getLength())) == null) {
                                return null;
                            }
                            StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
                            if (locationInParent == FieldAccess.NAME_PROPERTY ? !((fieldAccess = (FieldAccess)node.getParent()).getExpression() instanceof ThisExpression) : locationInParent == QualifiedName.NAME_PROPERTY) {
                                return null;
                            }
                            String typeSignature = Signature.createTypeSignature((String)field.getDeclaringType().getFullyQualifiedName(), (boolean)true);
                            typeSignature = typeSignature.replace('.', '/');
                            IJavaObject ths = frame.getThis();
                            if (ths != null) {
                                variable = ths.getField(field.getElementName(), typeSignature);
                            }
                        }
                        if (variable != null) {
                            return variable;
                        }
                        break;
                    }
                    if (javaElement instanceof ILocalVariable) {
                        ILocalVariable var = (ILocalVariable)javaElement;
                        IJavaElement parent = var.getParent();
                        while (!(parent instanceof IMethod) && parent != null) {
                            parent = parent.getParent();
                        }
                        if (parent instanceof IMethod) {
                            IMethod method = (IMethod)parent;
                            boolean equal = false;
                            if (method.isBinary()) {
                                if (method.getSignature().equals(frame.getSignature()) && method.getElementName().equals(frame.getMethodName())) {
                                    equal = true;
                                } else if (LambdaUtils.isLambdaFrame((IJavaStackFrame)frame)) {
                                    return LambdaUtils.findLocalVariableFromLambdaScope(frame, var);
                                }
                            } else {
                                String frameDeclaringTypeName = frame.getDeclaringTypeName();
                                int genericPartOffset = frameDeclaringTypeName.indexOf(60);
                                if (genericPartOffset != -1) {
                                    frameDeclaringTypeName = frameDeclaringTypeName.substring(0, genericPartOffset);
                                }
                                if ((frame.isConstructor() && method.isConstructor() || frame.getMethodName().equals(method.getElementName())) && frameDeclaringTypeName.endsWith(method.getDeclaringType().getElementName()) && frame.getArgumentTypeNames().size() == method.getNumberOfParameters()) {
                                    equal = true;
                                } else {
                                    int index = frame.getDeclaringTypeName().indexOf(36);
                                    if (index > 0) {
                                        String name = frame.getDeclaringTypeName().substring(index + 1);
                                        try {
                                            Integer.getInteger(name);
                                            return JavaDebugHover.findLocalVariable(frame, "val$" + var.getElementName());
                                        }
                                        catch (NumberFormatException numberFormatException) {}
                                    } else if (LambdaUtils.isLambdaFrame((IJavaStackFrame)frame)) {
                                        return LambdaUtils.findLocalVariableFromLambdaScope(frame, var);
                                    }
                                }
                            }
                            if (equal || method.isLambdaMethod()) {
                                return JavaDebugHover.findLocalVariable(frame, var.getElementName());
                            }
                        }
                        break;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                JDIDebugPlugin.log((Throwable)e);
            }
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new ExpressionInformationControlCreator();
    }
}

