/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.cft.server.core.AbstractApplicationDelegate;
import org.eclipse.cft.server.core.ICloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.application.ApplicationRegistry;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.DeploymentInfoWorkingCopy;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.wizards.MappedURLsWizardPage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;

public class MappedURLsWizard
extends Wizard {
    private final String appName;
    private final CloudFoundryServer cloudServer;
    private List<String> existingURIs;
    private CloudFoundryApplicationModule applicationModule;
    private MappedURLsWizardPage page;

    public MappedURLsWizard(CloudFoundryServer cloudServer, CloudFoundryApplicationModule applicationModule, List<String> existingURIs) {
        Assert.isNotNull((Object)applicationModule);
        this.cloudServer = cloudServer;
        this.appName = applicationModule.getDeployedApplicationName();
        this.applicationModule = applicationModule;
        this.existingURIs = existingURIs;
        this.setWindowTitle(Messages.MappedURLsWizard_TITLE_MOD_MAPPED_URL);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new MappedURLsWizardPage(this.cloudServer, this.existingURIs, (ICloudFoundryApplicationModule)this.applicationModule);
        this.addPage((IWizardPage)this.page);
    }

    public List<String> getURLs() {
        return this.page.getURLs();
    }

    public boolean requiresURL() {
        IModule localModule = this.applicationModule.getLocalModule();
        if (localModule == null) {
            return true;
        }
        AbstractApplicationDelegate delegate = ApplicationRegistry.getApplicationDelegate((IModule)localModule);
        return delegate == null || delegate.requiresURL();
    }

    public boolean performFinish() {
        this.page.setErrorMessage(null);
        final IStatus[] result = new IStatus[1];
        Object runnable = null;
        this.page.setMessage(Messages.MappedURLsWizard_TEXT_UPDATE_URL);
        runnable = !this.applicationModule.isDeployed() ? new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    DeploymentInfoWorkingCopy wc = MappedURLsWizard.this.applicationModule.resolveDeploymentInfoWorkingCopy(monitor);
                    wc.setUris(MappedURLsWizard.this.page.getURLs());
                    wc.save();
                }
                catch (CoreException e) {
                    result[0] = e.getStatus();
                }
            }
        } : new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    MappedURLsWizard.this.cloudServer.getBehaviour().operations().mappedUrlsUpdate(MappedURLsWizard.this.appName, MappedURLsWizard.this.page.getURLs()).run(monitor);
                }
                catch (CoreException e) {
                    result[0] = e.getStatus();
                }
            }
        };
        try {
            this.getContainer().run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            result[0] = CloudFoundryPlugin.getErrorStatus((Throwable)e);
        }
        catch (InterruptedException e) {
            result[0] = CloudFoundryPlugin.getErrorStatus((Throwable)e);
        }
        if (result[0] != null && !result[0].isOK()) {
            this.page.setErrorMessage(NLS.bind((String)Messages.MappedURLsWizard_ERROR_CHANGE_URL, (Object)result[0].getMessage()));
            return false;
        }
        return true;
    }
}

