/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.debug;

import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerUtil;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;

public enum CloudFoundryProperties {
    isServerSupported{

        @Override
        public boolean testProperty(IModule[] modules, CloudFoundryServer cloudFoundryServer) {
            if (cloudFoundryServer != null) {
                return CloudServerUtil.isCloudFoundryServer(cloudFoundryServer.getServer());
            }
            return false;
        }
    }
    ,
    isServerStarted{

        @Override
        public boolean testProperty(IModule[] modules, CloudFoundryServer cloudFoundryServer) {
            IServer server;
            if (cloudFoundryServer != null && (server = cloudFoundryServer.getServer()) != null) {
                return server.getServerState() == 2;
            }
            return false;
        }
    }
    ,
    isServerStopped{

        @Override
        public boolean testProperty(IModule[] modules, CloudFoundryServer cloudFoundryServer) {
            IServer server;
            if (cloudFoundryServer != null && (server = cloudFoundryServer.getServer()) != null) {
                return server.getServerState() == 4;
            }
            return false;
        }
    }
    ,
    isModuleStopped{

        @Override
        public boolean testProperty(IModule[] modules, CloudFoundryServer cloudFoundryServer) {
            return 4.getDeployedAppState(modules, cloudFoundryServer.getServer()) == 4;
        }
    }
    ,
    isModuleStarted{

        @Override
        public boolean testProperty(IModule[] modules, CloudFoundryServer cloudFoundryServer) {
            return 5.getDeployedAppState(modules, cloudFoundryServer.getServer()) == 2;
        }
    }
    ,
    isCloudModuleStarted{

        @Override
        public boolean testProperty(IModule[] modules, CloudFoundryServer cloudFoundryServer) {
            return isModuleStarted.testProperty(modules, cloudFoundryServer);
        }
    }
    ,
    isCloudModuleLocal{

        @Override
        public boolean testProperty(IModule[] modules, CloudFoundryServer cloudFoundryServer) {
            CloudFoundryApplicationModule cloudModule;
            if (modules != null && modules.length > 0 && (cloudModule = cloudFoundryServer.getExistingCloudModule(modules[0])) != null) {
                return !cloudModule.isExternal();
            }
            return false;
        }
    }
    ,
    isEnableSshOnModule{

        @Override
        public boolean testProperty(IModule[] modules, CloudFoundryServer cloudFoundryServer) {
            CloudFoundryApplicationModule cloudModule;
            if (modules != null && modules.length > 0 && (cloudModule = cloudFoundryServer.getExistingCloudModule(modules[0])) != null && cloudModule.getApplication() != null) {
                boolean result = cloudModule.getApplication().isEnableSsh();
                return result;
            }
            return false;
        }
    }
    ,
    isDiegoEnabledOnModule{

        @Override
        public boolean testProperty(IModule[] modules, CloudFoundryServer cloudFoundryServer) {
            CloudFoundryApplicationModule cloudModule;
            if (modules != null && modules.length > 0 && (cloudModule = cloudFoundryServer.getExistingCloudModule(modules[0])) != null && cloudModule.getApplication() != null) {
                boolean result = cloudModule.getApplication().isDiego();
                return result;
            }
            return false;
        }
    }
    ,
    isModuleProjectAccessible{

        @Override
        public boolean testProperty(IModule[] modules, CloudFoundryServer cloudFoundryServer) {
            if (modules == null || modules.length == 0) {
                return false;
            }
            IProject project = modules[0].getProject();
            return project != null && project.isAccessible();
        }
    }
    ,
    isSSO{

        @Override
        public boolean testProperty(IModule[] modules, CloudFoundryServer cloudFoundryServer) {
            return cloudFoundryServer != null && cloudFoundryServer.isSso();
        }
    };


    private CloudFoundryProperties() {
    }

    public boolean testProperty(IModule[] modules, CloudFoundryServer cloudFoundryServer) {
        return false;
    }

    protected static int getDeployedAppState(IModule[] modules, IServer server) {
        return modules != null && modules.length > 0 ? server.getModuleState(modules) : -1;
    }

    /* synthetic */ CloudFoundryProperties(String string, int n, CloudFoundryProperties cloudFoundryProperties) {
        this();
    }
}

