/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import org.eclipse.cft.server.core.internal.CloudFoundryBrandingExtensionPoint;
import org.eclipse.cft.server.core.internal.CloudFoundryConstants;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.CloudFoundryURLNavigation;
import org.eclipse.cft.server.ui.internal.CloudUiUtil;
import org.eclipse.cft.server.ui.internal.IPartChangeListener;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.PartChangeEvent;
import org.eclipse.cft.server.ui.internal.UIPart;
import org.eclipse.cft.server.ui.internal.editor.CloudUrlWidget;
import org.eclipse.cft.server.ui.internal.wizards.RegisterAccountWizard;
import org.eclipse.cft.server.ui.internal.wizards.WizardHandleContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class CloudFoundryCredentialsPart
extends UIPart
implements IPartChangeListener {
    private CloudFoundryServer cfServer;
    private Text emailText;
    private TabFolder folder;
    private Text passwordText;
    private String serverTypeId;
    private String service;
    private CloudUrlWidget urlWidget;
    private Button validateButton;
    private Button registerAccountButton;
    private Button cfSignupButton;
    private IRunnableContext runnableContext;

    public CloudFoundryCredentialsPart(CloudFoundryServer cfServer, WizardPage wizardPage) {
        this(cfServer);
        if (wizardPage != null) {
            wizardPage.setTitle(NLS.bind((String)Messages.CloudFoundryCredentialsPart_TEXT_CREDENTIAL_WIZ_TITLE, (Object)this.service));
            wizardPage.setDescription(Messages.SERVER_WIZARD_VALIDATOR_CLICK_TO_VALIDATE);
            ImageDescriptor banner = CloudFoundryImages.getWizardBanner(this.serverTypeId);
            if (banner != null) {
                wizardPage.setImageDescriptor(banner);
            }
            this.runnableContext = wizardPage.getWizard() != null && wizardPage.getWizard().getContainer() != null ? wizardPage.getWizard().getContainer() : null;
        }
    }

    public CloudFoundryCredentialsPart(CloudFoundryServer cfServer, WizardHandleContext context) {
        this(cfServer);
        IWizardHandle wizardHandle = context.getWizardHandle();
        if (wizardHandle != null) {
            wizardHandle.setTitle(NLS.bind((String)Messages.CloudFoundryCredentialsPart_TEXT_CREDENTIAL_WIZ_TITLE, (Object)this.service));
            wizardHandle.setDescription(Messages.SERVER_WIZARD_VALIDATOR_CLICK_TO_VALIDATE);
            ImageDescriptor banner = CloudFoundryImages.getWizardBanner(this.serverTypeId);
            if (banner != null) {
                wizardHandle.setImageDescriptor(banner);
            }
            this.runnableContext = context.getRunnableContext();
        }
    }

    public CloudFoundryCredentialsPart(CloudFoundryServer cfServer) {
        this.cfServer = cfServer;
        this.serverTypeId = cfServer.getServer().getServerType().getId();
        this.service = CloudFoundryBrandingExtensionPoint.getServiceName((String)this.serverTypeId);
        this.runnableContext = PlatformUI.getWorkbench().getProgressService();
    }

    @Override
    public Control createPart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.folder = new TabFolder(composite, 0);
        this.folder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloudFoundryCredentialsPart.this.updateUI(false);
            }
        });
        try {
            this.createExistingUserComposite(this.folder);
            this.updateUI(false);
        }
        catch (Throwable e1) {
            CloudFoundryPlugin.logError((Throwable)e1);
        }
        return composite;
    }

    public void setServer(CloudFoundryServer server) {
        this.cfServer = server;
    }

    private void createExistingUserComposite(TabFolder folder) throws CoreException {
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite topComposite = new Composite(composite, 0);
        topComposite.setLayout((Layout)new GridLayout(2, false));
        topComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label emailLabel = new Label(topComposite, 0);
        emailLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        emailLabel.setText(Messages.COMMONTXT_EMAIL_WITH_COLON);
        this.emailText = new Text(topComposite, 2048);
        this.emailText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.emailText.setEditable(true);
        this.emailText.setFocus();
        if (this.cfServer.getUsername() != null) {
            this.emailText.setText(this.cfServer.getUsername());
        }
        this.emailText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CloudFoundryCredentialsPart.this.cfServer.setUsername(CloudFoundryCredentialsPart.this.emailText.getText());
                CloudFoundryCredentialsPart.this.updateUI(false);
            }
        });
        Label passwordLabel = new Label(topComposite, 0);
        passwordLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        passwordLabel.setText(Messages.COMMONTXT_PW);
        this.passwordText = new Text(topComposite, 0x400800);
        this.passwordText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.passwordText.setEditable(true);
        if (this.cfServer.getPassword() != null) {
            this.passwordText.setText(this.cfServer.getPassword());
        }
        this.passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CloudFoundryCredentialsPart.this.cfServer.setPassword(CloudFoundryCredentialsPart.this.passwordText.getText());
                CloudFoundryCredentialsPart.this.updateUI(false);
            }
        });
        this.urlWidget = new CloudUrlWidget(this.cfServer){

            @Override
            protected void setUpdatedSelectionInServer() {
                super.setUpdatedSelectionInServer();
                CloudFoundryCredentialsPart.this.updateUI(false);
            }
        };
        this.urlWidget.createControls(topComposite, this.runnableContext);
        String url = this.urlWidget.getURLSelection();
        if (url != null) {
            this.cfServer.setUrl(CloudUiUtil.getUrlFromDisplayText(url));
        }
        final Composite validateComposite = new Composite(composite, 0);
        validateComposite.setLayout((Layout)new GridLayout(3, false));
        validateComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.validateButton = new Button(validateComposite, 8);
        this.validateButton.setText(Messages.CloudFoundryCredentialsPart_TEXT_VALIDATE_BUTTON);
        this.validateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CloudFoundryCredentialsPart.this.updateUI(true);
            }
        });
        this.registerAccountButton = new Button(validateComposite, 8);
        this.registerAccountButton.setText(Messages.CloudFoundryCredentialsPart_TEXT_REGISTER_BUTTON);
        this.registerAccountButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RegisterAccountWizard wizard = new RegisterAccountWizard(CloudFoundryCredentialsPart.this.cfServer);
                WizardDialog dialog = new WizardDialog(validateComposite.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    if (wizard.getEmail() != null) {
                        CloudFoundryCredentialsPart.this.emailText.setText(wizard.getEmail());
                    }
                    if (wizard.getPassword() != null) {
                        CloudFoundryCredentialsPart.this.passwordText.setText(wizard.getPassword());
                    }
                }
            }
        });
        this.cfSignupButton = new Button(validateComposite, 8);
        this.cfSignupButton.setText(CloudFoundryConstants.PUBLIC_CF_SERVER_SIGNUP_LABEL);
        this.cfSignupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String signupURL = CloudFoundryBrandingExtensionPoint.getSignupURL((String)CloudFoundryCredentialsPart.this.serverTypeId, (String)CloudFoundryCredentialsPart.this.cfServer.getUrl());
                if (signupURL != null) {
                    CloudFoundryURLNavigation nav = new CloudFoundryURLNavigation(signupURL);
                    nav.navigateExternal();
                }
            }
        });
        TabItem item = new TabItem(folder, 0);
        item.setText(Messages.COMMONTXT_ACCOUNT_INFO);
        item.setControl((Control)composite);
    }

    public void updateUI(boolean validateAgainstServer) {
        int eventType = validateAgainstServer ? 1002 : 1000;
        this.notifyChange(new PartChangeEvent(this.runnableContext, Status.OK_STATUS, this, eventType));
        this.updateButtons();
    }

    protected void updateButtons() {
        String url = this.cfServer.getUrl();
        this.cfSignupButton.setEnabled(CloudFoundryURLNavigation.canEnableCloudFoundryNavigation(this.serverTypeId, url));
        this.registerAccountButton.setEnabled(CloudFoundryBrandingExtensionPoint.supportsRegistration((String)this.serverTypeId, (String)url));
    }

    @Override
    public void handleChange(PartChangeEvent event) {
        if (event == null) {
            return;
        }
        int type = event.getType();
        boolean valuesFilled = (type == 1003 || type == 1001) && event.getStatus() != null && event.getStatus().isOK();
        this.validateButton.setEnabled(valuesFilled);
    }
}

