/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.cft.server.core.CFServiceInstance;
import org.eclipse.cft.server.core.CFServiceOffering;
import org.eclipse.cft.server.core.CFServicePlan;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Rectangle;

class ServiceInstance {
    private String name;
    private String userDefinedName;
    private int selectedPlan = 0;
    private Rectangle appxLocation = null;
    private final String[] planNames;
    private final String[] planDisplayNames;
    private final List<CFServicePlan> sortedPlans;
    private final CFServiceOffering offering;

    public ServiceInstance(String name, List<CFServicePlan> plans, CFServiceOffering offering) {
        this.name = name;
        this.sortedPlans = new ArrayList<CFServicePlan>(plans);
        Collections.sort(this.sortedPlans, new Comparator<CFServicePlan>(){

            @Override
            public int compare(CFServicePlan p1, CFServicePlan p2) {
                if (p1.isFree()) {
                    return -1;
                }
                if (p2.isFree()) {
                    return 1;
                }
                return 0;
            }
        });
        this.offering = offering;
        this.planNames = new String[this.sortedPlans.size()];
        this.planDisplayNames = new String[this.sortedPlans.size()];
        int x = 0;
        while (x < this.sortedPlans.size()) {
            CFServicePlan plan = this.sortedPlans.get(x);
            this.planNames[x] = plan.getName();
            this.planDisplayNames[x] = plan.isFree() ? NLS.bind((String)Messages.CloudFoundryServiceWizardPageRightPanel_FREE_PLAN, (Object)plan.getName()) : plan.getName();
            ++x;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getSelectedPlan() {
        return this.selectedPlan;
    }

    public void setSelectedPlan(int selectedPlan) {
        this.selectedPlan = selectedPlan;
    }

    public void setUserDefinedName(String userDefinedName) {
        this.userDefinedName = userDefinedName;
    }

    public String getUserDefinedName() {
        return this.userDefinedName;
    }

    public String[] getPlanNames() {
        return this.planNames;
    }

    public String[] getPlanDisplayNames() {
        return this.planDisplayNames;
    }

    public List<CFServicePlan> getPlans() {
        return this.sortedPlans;
    }

    public void setAppxLocation(Rectangle appxLocation) {
        this.appxLocation = appxLocation;
    }

    public Rectangle getAppxLocation() {
        return this.appxLocation;
    }

    public CFServiceInstance convertToLocalService() {
        CFServiceInstance localService = new CFServiceInstance("");
        localService.setName(this.getUserDefinedName());
        localService.setVersion(this.offering.getVersion());
        localService.setService(this.offering.getName());
        localService.setPlan(this.planNames[this.getSelectedPlan()]);
        localService.setIsLocal(true);
        return localService;
    }
}

