/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.rse.internal;

import org.eclipse.cft.server.core.internal.CloudFoundryBrandingExtensionPoint;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.rse.internal.CloudFoundryConnectorService;
import org.eclipse.cft.server.rse.internal.CloudFoundryConnectorServiceManager;
import org.eclipse.cft.server.rse.internal.CloudFoundryRsePlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rse.core.IRSECoreRegistry;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.view.SystemPerspectiveHelpers;
import org.eclipse.rse.internal.ui.view.SystemView;
import org.eclipse.rse.internal.ui.view.SystemViewPart;
import org.eclipse.ui.PlatformUI;

public class ConfigureRemoteCloudFoundryAction
extends Action {
    private CloudFoundryServer server;
    private String serverTypeId;

    public ConfigureRemoteCloudFoundryAction(CloudFoundryServer server) {
        this.server = server;
        this.serverTypeId = server.getServer().getServerType().getId();
    }

    public void run() {
        IRSECoreRegistry coreReg = RSECorePlugin.getTheCoreRegistry();
        ISystemRegistry sysReg = RSECorePlugin.getTheSystemRegistry();
        String systemTypeId = CloudFoundryBrandingExtensionPoint.getRemoteSystemTypeId((String)this.serverTypeId);
        if (systemTypeId != null && systemTypeId.trim().length() > 0) {
            IRSESystemType systemType = coreReg.getSystemTypeById(systemTypeId);
            IHost host = null;
            IHost[] hosts = sysReg.getHostsBySystemType(systemType);
            if (hosts.length >= 1) {
                host = hosts[0];
            }
            if (host == null) {
                try {
                    host = sysReg.createHost(systemType, systemType.getLabel(), this.server.getUrl(), "");
                    ISubSystem[] subSystems = sysReg.getSubSystems(host);
                    CloudFoundryConnectorServiceManager serviceManager = CloudFoundryConnectorServiceManager.getInstance();
                    CloudFoundryConnectorService service = (CloudFoundryConnectorService)serviceManager.createConnectorService(host);
                    int i = 0;
                    while (i < subSystems.length) {
                        service.registerSubSystem(subSystems[i]);
                        ++i;
                    }
                }
                catch (Exception e) {
                    CloudFoundryRsePlugin.logError((String)"An error occurred while connecting to service.", (Throwable)e);
                }
            }
            if (host != null) {
                SystemViewPart viewPart = (SystemViewPart)SystemPerspectiveHelpers.showView((String)"org.eclipse.rse.ui.view.systemView");
                final SystemView view = viewPart.getSystemView();
                ISubSystem[] subSystems = sysReg.getSubSystems(host);
                if (subSystems.length > 0) {
                    final ISubSystem system = subSystems[0];
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            view.setExpandedState((Object)system.getHost(), true);
                            view.setExpandedState((Object)system, true);
                            view.setSelection((ISelection)new StructuredSelection((Object)system));
                        }
                    });
                }
            }
        }
    }
}

