/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cft.server.core.AbstractApplicationDelegate;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.application.ApplicationProvider;
import org.eclipse.cft.server.core.internal.application.ApplicationRegistry;
import org.eclipse.cft.server.ui.internal.wizards.ApplicationWizardDelegate;
import org.eclipse.cft.server.ui.internal.wizards.ApplicationWizardProvider;
import org.eclipse.cft.server.ui.internal.wizards.IApplicationWizardDelegate;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IModule;

public class ApplicationWizardRegistry {
    private static Map<String, ApplicationWizardProvider> wizardProviders;
    private static final String APPLICATION_DELEGATE_EXT_ELEMENT = "applicationWizardDelegate";
    public static String EXTENSION_POINT;

    static {
        EXTENSION_POINT = "org.eclipse.cft.server.ui.applicationWizard";
    }

    public static ApplicationWizardDelegate getWizardProvider(IModule module) {
        ApplicationProvider applicationProvider = ApplicationRegistry.getApplicationProvider((IModule)module);
        return ApplicationWizardRegistry.getWizardDelegate(applicationProvider);
    }

    protected static ApplicationWizardDelegate getWizardDelegate(ApplicationProvider applicationProvider) {
        ApplicationWizardProvider wizardProvider;
        if (applicationProvider == null) {
            return null;
        }
        if (wizardProviders == null) {
            ApplicationWizardRegistry.load();
        }
        if ((wizardProvider = wizardProviders.get(applicationProvider.getProviderID())) != null) {
            return wizardProvider.getDelegate((AbstractApplicationDelegate)applicationProvider.getDelegate());
        }
        return null;
    }

    public static IApplicationWizardDelegate getDefaultJavaWebWizardDelegate() {
        ApplicationProvider javaWebProvider = ApplicationRegistry.getDefaultJavaWebApplicationProvider();
        return ApplicationWizardRegistry.getWizardDelegate(javaWebProvider);
    }

    private static void load() {
        wizardProviders = new HashMap<String, ApplicationWizardProvider>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT);
        if (extensionPoint == null) {
            CloudFoundryPlugin.logError((String)("Failed to load Cloud Foundry application wizard providers from: " + EXTENSION_POINT));
        } else {
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    if (APPLICATION_DELEGATE_EXT_ELEMENT.equals(config.getName())) {
                        ApplicationWizardProvider wizardProvider = new ApplicationWizardProvider(config, EXTENSION_POINT);
                        String providerID = wizardProvider.getProviderID();
                        if (providerID == null) {
                            CloudFoundryPlugin.logError((String)("Failed to load application wizard provider from extension point: " + EXTENSION_POINT + ". Missing provider ID."));
                        } else {
                            wizardProviders.put(providerID, wizardProvider);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }
}

