/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cft.server.core.internal.ApplicationUrlLookupService;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerUtil;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.ui.internal.wizards.ApplicationWizardDelegate;
import org.eclipse.cft.server.ui.internal.wizards.ApplicationWizardDescriptor;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryApplicationEnvVarWizardPage;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryApplicationServicesWizardPage;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryApplicationWizardPage;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryDeploymentWizardPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;

public class DefaultApplicationWizardDelegate
extends ApplicationWizardDelegate {
    @Override
    public List<IWizardPage> getWizardPages(ApplicationWizardDescriptor descriptor, IServer server, IModule module) {
        ArrayList<IWizardPage> defaultPages = new ArrayList<IWizardPage>();
        try {
            this.createPages(descriptor, server, module, defaultPages);
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError((String)("Unable to open application deployment wizard for server type " + server.getId() + " and module " + module.getName()), (Throwable)e);
        }
        return defaultPages;
    }

    protected void createPages(ApplicationWizardDescriptor applicationDescriptor, IServer server, IModule module, List<IWizardPage> defaultPages) throws CoreException {
        CloudFoundryServer cloudServer = CloudServerUtil.getCloudServer((IServer)server);
        CloudFoundryApplicationModule appModule = cloudServer.getExistingCloudModule(module);
        ApplicationUrlLookupService urllookup = ApplicationUrlLookupService.getCurrentLookup((CloudFoundryServer)cloudServer);
        CloudFoundryDeploymentWizardPage deploymentPage = new CloudFoundryDeploymentWizardPage(cloudServer, appModule, applicationDescriptor, urllookup, this);
        CloudFoundryApplicationWizardPage applicationNamePage = new CloudFoundryApplicationWizardPage(cloudServer, appModule, applicationDescriptor);
        defaultPages.add((IWizardPage)applicationNamePage);
        defaultPages.add((IWizardPage)deploymentPage);
        CloudFoundryApplicationServicesWizardPage servicesPage = new CloudFoundryApplicationServicesWizardPage(cloudServer, appModule, applicationDescriptor);
        defaultPages.add((IWizardPage)servicesPage);
        defaultPages.add((IWizardPage)new CloudFoundryApplicationEnvVarWizardPage(cloudServer, applicationDescriptor.getDeploymentInfo()));
    }
}

