/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cft.server.core.AbstractCloudFoundryUrl;
import org.eclipse.cft.server.core.internal.CloudFoundryBrandingExtensionPoint;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.UserDefinedCloudFoundryUrl;
import org.eclipse.cft.server.ui.internal.wizards.CloudUrlWizardPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class CloudUrlWizard
extends Wizard {
    private final String serverID;
    private final List<AbstractCloudFoundryUrl> allCloudUrls;
    private CloudUrlWizardPage page;
    private String url;
    private String name;
    private boolean selfSigned;

    public CloudUrlWizard(String serverID, List<CloudFoundryBrandingExtensionPoint.CloudServerURL> allCloudUrls, String url, String name, boolean selfSigned) {
        this.serverID = serverID;
        if (allCloudUrls == null) {
            this.allCloudUrls = null;
        } else {
            this.allCloudUrls = new ArrayList<AbstractCloudFoundryUrl>();
            for (CloudFoundryBrandingExtensionPoint.CloudServerURL serverUrl : allCloudUrls) {
                this.allCloudUrls.add((AbstractCloudFoundryUrl)serverUrl);
            }
        }
        this.url = url;
        this.name = name;
        this.selfSigned = selfSigned;
        this.setWindowTitle(Messages.CloudUrlWizard_TITLE_ADD_VALIDATE);
        this.setNeedsProgressMonitor(true);
    }

    public CloudUrlWizard(String serverID, String url, String name, boolean selfSigned, List<AbstractCloudFoundryUrl> allCloudUrls) {
        this.serverID = serverID;
        this.allCloudUrls = allCloudUrls;
        this.url = url;
        this.name = name;
        this.selfSigned = selfSigned;
        this.setWindowTitle(Messages.CloudUrlWizard_TITLE_ADD_VALIDATE);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new CloudUrlWizardPage(CloudFoundryImages.getWizardBanner(this.serverID), this.url, this.name, this.selfSigned, this.allCloudUrls);
        this.addPage((IWizardPage)this.page);
    }

    public CloudFoundryBrandingExtensionPoint.CloudServerURL getCloudUrl() {
        String dURL = this.page != null ? this.page.getUrl() : this.url;
        String dName = this.page != null ? this.page.getName() : this.name;
        boolean selfSigned = this.page != null ? this.page.getSelfSigned() : this.selfSigned;
        return new CloudFoundryBrandingExtensionPoint.CloudServerURL(dName, dURL, true, selfSigned);
    }

    public AbstractCloudFoundryUrl getCloudFoundryUrl() {
        String dURL = this.page != null ? this.page.getUrl() : this.url;
        String dName = this.page != null ? this.page.getName() : this.name;
        boolean selfSigned = this.page != null ? this.page.getSelfSigned() : this.selfSigned;
        return new UserDefinedCloudFoundryUrl(dName, dURL, selfSigned);
    }

    public boolean performFinish() {
        return this.validateURL();
    }

    protected boolean launchURLValidation(final Exception[] exception, IProgressMonitor monitor) {
        this.url = this.page.getUrl();
        this.selfSigned = this.page.getSelfSigned();
        String jobName = Messages.CloudUrlWizard_JOB_VALIDATE_URL;
        final boolean[] shouldProceed = new boolean[1];
        try {
            int useAnimatedProgress = 0;
            monitor.beginTask(jobName, useAnimatedProgress);
            try {
                exception[0] = null;
                final Synchroniser synchroniser = new Synchroniser();
                Job job = new Job(jobName){

                    protected IStatus run(IProgressMonitor arg0) {
                        try {
                            try {
                                CloudFoundryPlugin.getCloudFoundryClientFactory().getCloudFoundryOperations(CloudUrlWizard.this.url, CloudUrlWizard.this.selfSigned).getCloudInfo();
                                shouldProceed[0] = true;
                            }
                            catch (Exception e) {
                                exception[0] = e;
                                synchroniser.completed();
                            }
                        }
                        finally {
                            synchroniser.completed();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(10);
                job.schedule();
                while (!monitor.isCanceled() && !synchroniser.isComplete()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (OperationCanceledException e) {
                throw new InterruptedException(e.getLocalizedMessage());
            }
        }
        catch (InterruptedException e) {
            shouldProceed[0] = false;
            exception[0] = e;
        }
        return shouldProceed[0];
    }

    protected boolean validateURL() {
        final Exception[] exception = new Exception[1];
        final Boolean[] shouldProceed = new Boolean[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                shouldProceed[0] = CloudUrlWizard.this.launchURLValidation(exception, monitor);
            }
        };
        try {
            this.getContainer().run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            exception[0] = e;
        }
        catch (InterruptedException e) {
            exception[0] = e;
        }
        if (!shouldProceed[0].booleanValue()) {
            String errorMessage = this.getErrorMessage(exception[0], this.url);
            shouldProceed[0] = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.CloudUrlWizard_ERROR_KEEP_TITLE, (String)(String.valueOf(errorMessage) + Messages.CloudUrlWizard_ERROR_KEEP_BODY));
        }
        return shouldProceed[0];
    }

    protected String getErrorMessage(Exception exception, String url) {
        StringBuilder builder = new StringBuilder();
        builder.append(Messages.CloudUrlWizard_ERROR_VALIDATE);
        builder.append(url);
        if (exception != null) {
            String errorMessage;
            String string = errorMessage = exception.getMessage() != null ? exception.getMessage() : exception.toString();
            if (errorMessage != null) {
                builder.append(Messages.CloudUrlWizard_ERROR_VALIDATE_DUE_TO);
                builder.append(errorMessage);
            }
        }
        return builder.toString();
    }

    static class Synchroniser {
        private boolean isComplete = false;

        Synchroniser() {
        }

        public synchronized void completed() {
            this.isComplete = true;
        }

        public synchronized boolean isComplete() {
            return this.isComplete;
        }
    }
}

